
<nav id="sidebar" class="navbar navbar-expand-md p-0"> <!-- sticky-top -->
    <div class="d-flex flex-column flex-shrink-0 w-100 bg-primary" style="height: 100vh;">
        <div class="px-3">
            <a href="/" class="">
                <span class=""><img class="mx-auto d-block" src="/logo-white.png" style="max-width: 150px"></span>
            </a>
            
            <!-- Mode Toggle -->
            <div class="mode-toggle-container mt-2 mb-2">
                <div class="btn-group w-100" role="group">
                    <button type="button" class="btn btn-light btn-sm active" disabled>
                        <i class="fas fa-boxes"></i> Wholesale
                    </button>
                    <button type="button" class="btn btn-outline-light btn-sm" wire:click="switchToCommission">
                        <i class="fas fa-percentage"></i> Commission
                    </button>
                </div>
            </div>
            
            <hr class="text-white my-2">
        </div>
        <ul class="nav nav-pills flex-column mb-auto">
            <li class="">
                <a class="menu-button ps-4 p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ request()->segment(1) == '' ? 'bg-primary' : '' }}" href="{{ route('dashboard') }}" class="nav-link">
                    <span class="fw-semibold">
                        <i class="fas fa-tachometer-alt text-white" style="width: 20px; height: 20px;"></i>
                        <span class="ms-3">Dashboard</span>
                    </span>
                </a>
            </li>


            <livewire:navigation.navigation-dropdown    dropdownName="PD"
                                                        img="dev.png"
                                                        :subs="[
                                                            'Designs' => 'designs',
                                                            'Styles' => 'styles',
                                                            'Samples Management' => 'samples',
                                                            'Bulk Samples' => 'samplesbulk',
                                                            'Styles Overview' => 'stylesoverview'
                                                        ]"
                                                        wire:key="ProductDevelopment" />

            <livewire:navigation.navigation-dropdown    dropdownName="Sales"
                                                        img="sales.png"
                                                        :subs="[
                                                            'Orders' => 'orders',
                                                        ]"
                                                        :tertiary="[
                                                            'Pricing Management' => [
                                                                'KWT Pricing' => 'pricing',
                                                                'KWA Pricing' => 'kwapricing'
                                                            ],
                                                            'Order Import' => [
                                                                'KWT Orders' => 'importordersupload',
                                                                'KWA Orders' => 'importaiorderskwa',
                                                                'ASOS Orders' => 'importaiordersasos',
                                                            ],
                                                        ]"
                                                        wire:key="OrdersSales" />

            <livewire:navigation.navigation-dropdown    dropdownName="Production"
                                                        img="production.png"
                                                        :subs="[
                                                            'Shipments' => 'shipments',
                                                            'Shipment Schedule' => 'shipmentschedule',
                                                            'Factory Purchase Orders' => 'factorypo',
                                                            'Yarn Purchase Orders' => 'yarnpo',
                                                            'Calendar' => 'wholesalecalendar'
                                                        ]"
                                                        :tertiary="[
                                                            'Critical Paths' => [
                                                                'Critical Path (Wholesale)' => 'criticalpath',
                                                                'Critical Path (ASOS)' => 'asoscriticalpath'
                                                            ],
                                                            'Packing List Import' => [
                                                                'ASOS Ananta PL' => 'importpackinglistasos',
                                                                'ASOS Ananta PO' => 'importasosanantapo',
                                                            ]
                                                        ]"
                                                        wire:key="ProductionLogistics" />

            <livewire:navigation.navigation-dropdown    dropdownName="Finance"
                                                        img="finance.png"
                                                        :subs="[
                                                            'Sample Invoicing' => 'samplesinvoice',
                                                            'Sample Invoicing (New)' => 'samplesinvoicenew',
                                                            'Bank File' => 'bankfile',
                                                            'Erdos Invoice Import' => 'erdosimportai',
                                                            'Wholesale Cashflow' => 'cashflow',
                                                        ]"
                                                        wire:key="FinanceInvoicing" />

            <li><hr class="text-white mx-3 my-2"></li>

            <livewire:navigation.navigation-dropdown    dropdownName="Analytics"
                                                        img="production.png"
                                                        :subs="[
                                                            'Drop Lookup' => 'prodlookup',
                                                            'Price History' => 'pricehistory',
                                                        ]"
                                                        :tertiary="[
                                                            'Sales Reports' => [
                                                                'Sales Values' => 'salesvalues',
                                                                'Sales Outlook' => 'salesoutlook'
                                                            ]
                                                        ]"
                                                        wire:key="ReportsAnalytics" />

            <livewire:navigation.navigation-dropdown    dropdownName="Master Data"
                                                        img="production.png"
                                                        :subs="[
                                                            'Customers' => 'customers',
                                                            'Suppliers' => 'suppliers',
                                                            'Departments' => 'departments',
                                                            'Seasons' => 'seasons',
                                                            'Invoice Layouts' => 'invoicelayouts',
                                                        ]"
                                                        :tertiary="[
                                                            'Yarns & Materials' => [
                                                                'Yarns' => 'yarns',
                                                                'Materials' => 'materials',
                                                                'Counts' => 'counts',
                                                            ],
                                                            'Product Attributes' => [
                                                                'Sizes' => 'sizes',
                                                                'Gauges' => 'gauges',
                                                                'Sample Types' => 'sampletypes',
                                                            ]
                                                        ]"
                                                        wire:key="MasterData" />

            @can('admin-only')
            <livewire:navigation.navigation-dropdown    dropdownName="System"
                                                        img="import.png"
                                                        :subs="[
                                                            'Pricing Import' => 'importprices',
                                                            'Users' => 'users',
                                                        ]"
                                                        :tertiary="[
                                                            'Activity Logs' => [
                                                                'Style Logs' => 'viewstylelogs',
                                                                'Order Logs' => 'vieworderlogs',
                                                                'System Logs' => 'viewlogs',
                                                            ]
                                                        ]"
                                                        wire:key="System" />
            @endcan

        </ul>
        <hr>
        <div class="px-3 pb-3">
            <button class="btn btn-outline-light w-100" onclick="toggleTheme()">
                <i class="fas fa-adjust"></i> Toggle Theme
            </button>
            <script>
                (function() {
                    try {
                        var stored = localStorage.getItem('theme');
                        if (!stored && window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) stored = 'dark';
                        applyTheme(stored || 'light');
                    } catch (e) {}
                })();
                function applyTheme(theme){
                    if(theme === 'dark'){
                        document.documentElement.setAttribute('data-bs-theme','dark');
                    } else {
                        document.documentElement.setAttribute('data-bs-theme','light');
                    }
                    try { localStorage.setItem('theme', theme); } catch(e) {}
                }
                function toggleTheme(){
                    var current = document.documentElement.getAttribute('data-bs-theme') || 'light';
                    applyTheme(current === 'dark' ? 'light' : 'dark');
                }
            </script>
        </div>
      </div>
</nav>
