<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Users
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    {{-- <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button> --}}
                </div>
            </div>
            {{-- @if(!$hideFilters)
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif --}}
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Last Update</th>
                            <th>Last View</th>
                            @foreach($this->functionalRoles as $roleId => $roleLabel)
                                <th class="text-center" style="font-size: 0.75rem;">{{ $roleLabel }}</th>
                            @endforeach
                            @foreach($this->teams as $team)
                                <th>{{ $team }}</th>
                            @endforeach
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($this->users as $user)
                            <tr>
                                <td>{{ $user->id }}</td>
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->email }}</td>
                                <td>{{ $user->latestAudit?->created_at->format('Y-m-d | h:m') }}</td>
                                <td>{{ cache()->get("user-last-seen-{$user->id}")?->format('Y-m-d | H:i') }}</td>
                                @foreach ($this->functionalRoles as $roleId => $roleLabel)
                                    <td class="text-center">
                                        @php
                                            $hasRole = $user->functionalRoles->contains('id', $roleId);
                                        @endphp
                                        <span
                                            style="cursor: pointer"
                                            class="badge {{ $hasRole ? 'bg-success' : 'bg-light text-muted' }}"
                                            wire:click="toggleFunctionalRole({{ $user->id }}, {{ $roleId }})"
                                            title="Click to toggle"
                                        >
                                            @if($hasRole)
                                                <i class="fas fa-check"></i>
                                            @else
                                                <i class="fas fa-minus"></i>
                                            @endif
                                        </span>
                                    </td>
                                @endforeach
                                @foreach ($this->teams as $t => $team)
                                    <td class="text-center">
                                        @php
                                            $teamRelation = $user->teams->firstWhere('id', $t);
                                            $teamRole = $teamRelation?->pivot->role;
                                        @endphp

                                        @if ($teamRole)
                                            <span
                                                style="cursor: pointer"
                                                class="badge text-uppercase position-relative pe-3 cursor-pointer
                                                    @if ($teamRole === 'admin') bg-danger
                                                    @elseif ($teamRole === 'editor') bg-warning text-dark
                                                    @elseif ($teamRole === 'viewer') bg-primary
                                                    @else bg-light
                                                    @endif"
                                                wire:click="cycleTeamRole({{ $user->id }}, {{ $t }})"
                                                title="Click to change role"
                                            >
                                                {{ $teamRole }}

                                                <span
                                                    class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-white text-dark small"
                                                    style="cursor: pointer; font-size: 0.6rem;"
                                                    wire:click.stop="removeFromTeam({{ $user->id }}, {{ $t }})"
                                                    title="Remove"
                                                >
                                                    ×
                                                </span>
                                            </span>
                                        @else
                                            <span
                                                style="cursor: pointer"
                                                class="badge bg-light text-dark text-uppercase cursor-pointer"
                                                wire:click="addToTeam({{ $user->id }}, {{ $t }}, 'view')"
                                                title="Click to add to team"
                                            >
                                                add
                                            </span>
                                        @endif
                                    </td>
                                @endforeach

                                <td>

                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <x-modal name="edit" title="Edit Customer">
            <x-slot:body>
                <livewire:admin.customers.customer-edit wire:key="edit">
            </x-slot:body>
        </x-modal>


        <x-modal name="new" title="New Customer">
            <x-slot:body>
                <livewire:admin.customers.customer-edit wire:key="new">
            </x-slot:body>
        </x-modal>
    </div>

    <x-footer>
        <x-slot:center>
            {{-- {{ $customers->links() }} --}}
        </x-slot:center>
    </x-footer>
</div>
