<div class="container my-4">
    <div class="row mb-3">
        <div class="col-md-6">
            <label for="selectedModel" class="form-label fw-bold">Select Model</label>
            <select wire:model.live="selectedModel" id="selectedModel" class="form-select">
                <option value="">-- Choose a Model --</option>
                @foreach($models as $key => $class)
                    <option value="{{ $key }}">{{ ucfirst($key) }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-6">
            <label for="selectedId" class="form-label fw-bold">Enter ID</label>
            <input
                wire:model.live="selectedId"
                type="number"
                id="selectedId"
                class="form-control"
                placeholder="Example: 1">
        </div>
    </div>

    @if(! empty($logs))
        <table class="table table-bordered table-striped mt-3">
            <thead>
                <tr>
                    <th>Event</th>
                    <th>Old Values</th>
                    <th>New Values</th>
                    <th>User Name</th>
                    <th>Date Changed</th>
                </tr>
            </thead>
            <tbody>
                @forelse($logs as $log)
                    <tr>
                        <td>{{ $log->event }}</td>
                        <td>
                            @foreach($log->old_values as $key => $value)
                                <strong>{{ $key }}</strong>: {{ $value }}<br />
                            @endforeach
                        </td>
                        <td>
                            @foreach($log->new_values as $key => $value)
                                <strong>{{ $key }}</strong>: {{ $value }}<br />
                            @endforeach
                        </td>

                        <!-- Display user name; fallback if user doesn't exist -->
                        <td>
                            {{ $log->user->name ?? 'Unknown User' }}
                        </td>

                        <td>{{ $log->created_at->format('Y-m-d H:i:s') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5">No logs found for this record.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    @endif
</div>
