<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Price History Audit
        </x-slot:title>
        <x-slot:sub>
            <div class="row align-items-center g-2">
                <div class="col-auto">
                    <select wire:model.live="searchType" class="form-select form-select-sm">
                        <option value="style_code">Style Code</option>
                        <option value="order_number">Order Number / PO</option>
                        <option value="shipment_line_id">Shipment Line ID</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <div class="input-group input-group-sm">
                        <input 
                            wire:model="search" 
                            wire:keydown.enter="performSearch"
                            type="text" 
                            class="form-control" 
                            placeholder="{{ $searchType === 'style_code' ? 'e.g. ABC123' : ($searchType === 'order_number' ? 'e.g. PO12345' : 'e.g. 12345') }}"
                        />
                        <button wire:click="performSearch" class="btn btn-primary" type="button">
                            <i class="bi bi-search"></i> Search
                        </button>
                        @if($search)
                            <button wire:click="clearSearch" class="btn btn-outline-secondary" type="button">
                                <i class="bi bi-x-lg"></i>
                            </button>
                        @endif
                    </div>
                </div>
                <div class="col-auto">
                    <div wire:loading class="spinner-border spinner-border-sm text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </x-slot:sub>
    </x-title-bar>

    <div id="page-content-container" class="container-fluid py-3">
        @if(!$searched && empty($search))
            {{-- Initial State --}}
            <div class="price-history-welcome text-center py-5">
                <div class="price-history-icon mb-4">
                    <i class="bi bi-clock-history"></i>
                </div>
                <h4 class="mb-3">Price History Audit Trail</h4>
                <p class="text-muted mb-4">
                    Search by style code, order number, or shipment line ID to view price change history.
                </p>
                <div class="row justify-content-center g-3">
                    <div class="col-md-3">
                        <div class="card price-history-hint-card h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-tag text-primary fs-3 mb-2"></i>
                                <h6>Style Code</h6>
                                <small class="text-muted">View all price changes for a specific style</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card price-history-hint-card h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-receipt text-success fs-3 mb-2"></i>
                                <h6>Order Number</h6>
                                <small class="text-muted">See price changes related to a customer order</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card price-history-hint-card h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-box-seam text-warning fs-3 mb-2"></i>
                                <h6>Shipment Line</h6>
                                <small class="text-muted">Track price history for a specific shipment</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @elseif($searched && empty($results))
            {{-- No Results --}}
            <div class="alert alert-warning d-flex align-items-center">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <span>No results found for "<strong>{{ $search }}</strong>" in {{ str_replace('_', ' ', $searchType) }}.</span>
            </div>
        @elseif(!empty($results))
            <div class="row g-3">
                {{-- Search Results Column --}}
                <div class="col-lg-4">
                    <div class="card price-history-results-card">
                        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                            <span><i class="bi bi-list-ul me-2"></i>Search Results</span>
                            <span class="badge bg-light text-primary">{{ count($results) }}</span>
                        </div>
                        <div class="card-body p-0 price-history-results-list">
                            @foreach($results as $result)
                                <div 
                                    wire:click="selectItem({{ $result['id'] }}, '{{ $result['type'] }}')"
                                    class="price-history-result-item {{ $selectedItemId == $result['id'] && $selectedItemType == $result['type'] ? 'active' : '' }}"
                                >
                                    @if($result['type'] === 'style')
                                        <div class="d-flex align-items-start gap-3">
                                            <div class="price-history-result-icon bg-primary-subtle">
                                                <i class="bi bi-tag text-primary"></i>
                                            </div>
                                            <div class="flex-grow-1 min-width-0">
                                                <div class="fw-semibold text-truncate">{{ $result['label'] }}</div>
                                                <small class="text-muted d-block text-truncate">{{ $result['customer'] }}</small>
                                                <small class="text-muted d-block text-truncate">{{ $result['design'] }}</small>
                                                <span class="badge bg-secondary mt-1">{{ $result['prices_count'] }} prices</span>
                                            </div>
                                        </div>
                                    @elseif($result['type'] === 'order')
                                        <div class="d-flex align-items-start gap-3">
                                            <div class="price-history-result-icon bg-success-subtle">
                                                <i class="bi bi-receipt text-success"></i>
                                            </div>
                                            <div class="flex-grow-1 min-width-0">
                                                <div class="fw-semibold text-truncate">{{ $result['label'] }}</div>
                                                <small class="text-muted d-block">{{ $result['customer'] }} | {{ $result['order_date'] }}</small>
                                                <small class="text-muted d-block text-truncate">{{ $result['styles'] }}</small>
                                                <span class="badge bg-secondary mt-1">{{ $result['lines_count'] }} lines</span>
                                            </div>
                                        </div>
                                    @elseif($result['type'] === 'shipment_line')
                                        <div class="d-flex align-items-start gap-3">
                                            <div class="price-history-result-icon bg-warning-subtle">
                                                <i class="bi bi-box-seam text-warning"></i>
                                            </div>
                                            <div class="flex-grow-1 min-width-0">
                                                <div class="fw-semibold">{{ $result['label'] }}</div>
                                                <small class="text-muted d-block">PO: {{ $result['order_po'] }}</small>
                                                <small class="text-muted d-block text-truncate">{{ $result['style_ref'] }} - {{ $result['colourway'] }}</small>
                                                @if($result['rt_invoice'])
                                                    <span class="badge bg-info mt-1">RT: {{ $result['rt_invoice'] }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                {{-- Price Audits Column --}}
                <div class="col-lg-8">
                    @if($selectedItemId)
                        <div class="card price-history-audits-card">
                            <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                                <span>
                                    <i class="bi bi-clock-history me-2"></i>
                                    Price Change History
                                </span>
                                <span class="badge bg-light text-dark">{{ $priceAudits->count() }} changes</span>
                            </div>
                            <div class="card-body p-0">
                                @if($priceAudits->isEmpty())
                                    <div class="text-center py-5 text-muted">
                                        <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                        <span>No price changes found for this item.</span>
                                    </div>
                                @else
                                    <div class="price-history-audit-list">
                                        @foreach($priceAudits as $audit)
                                            <div class="price-history-audit-item">
                                                <div class="price-history-audit-header">
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <span class="badge {{ $audit['event'] === 'created' ? 'bg-success' : ($audit['event'] === 'deleted' ? 'bg-danger' : 'bg-primary') }} text-uppercase">
                                                            {{ $audit['event'] }}
                                                        </span>
                                                        <span class="fw-semibold">{{ $audit['style_ref'] }}</span>
                                                        <span class="text-muted">|</span>
                                                        <span class="text-muted">{{ $audit['price_name'] }}</span>
                                                        @if($audit['size'] !== 'All')
                                                            <span class="badge bg-secondary">{{ $audit['size'] }}</span>
                                                        @endif
                                                    </div>
                                                    <div class="price-history-audit-meta">
                                                        <span class="me-3">
                                                            <i class="bi bi-person"></i> {{ $audit['user'] }}
                                                        </span>
                                                        <span>
                                                            <i class="bi bi-clock"></i> {{ $audit['timestamp'] }}
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="price-history-changes-table">
                                                    <table class="table table-sm mb-0">
                                                        <thead>
                                                            <tr>
                                                                <th style="width: 30%">Field</th>
                                                                <th style="width: 35%">Old Value</th>
                                                                <th style="width: 35%">New Value</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach($audit['changes'] as $change)
                                                                <tr>
                                                                    <td>
                                                                        <code class="text-pink">{{ str_replace('_', ' ', $change['field']) }}</code>
                                                                    </td>
                                                                    <td class="price-history-old-value">{{ $change['old'] }}</td>
                                                                    <td class="price-history-new-value">{{ $change['new'] }}</td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        </div>
                    @else
                        <div class="card">
                            <div class="card-body text-center py-5 text-muted">
                                <i class="bi bi-arrow-left-circle fs-1 d-block mb-3"></i>
                                <h5>Select an item from the results</h5>
                                <p class="mb-0">Click on a search result to view its price change history.</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @endif
    </div>
</div>



































