<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Order Audit Log Viewer
        </x-slot:title>
        <x-slot:sub>
            <div class="row m-2">
                <input wire:model.live.debounce.500ms="orderId" id="orderId" type="number" class="form-control" placeholder="e.g. 123" />
            </div>
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container">

        @if ($order)
            <h5 class="my-3">Audit Log for Style #{{ $order->id }} – {{ $order->customer_ref }}</h5>

            @php
                $hasChanges = false;
            @endphp

            <div class="table-responsive">
                <table class="table table-sm mb-0 text-center align-middle border" style="table-layout: fixed; border-collapse: collapse;">

                    <thead>
                        <tr>
                            <th class="bg-primary text-white" style="width: 33.3%">Field</th>
                            <th class="bg-primary text-white" style="width: 33.3%">Old Value</th>
                            <th class="bg-primary text-white" style="width: 33.3%">New Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($this->groupedLogs as $group)
                            @php
                                $first = $group->first();
                            @endphp

                            @if ($group->isNotEmpty())
                                {{-- Header Row for the group --}}
                                <tr class="bg-light">
                                    <td colspan="3" class="text-start fw-semibold">
                                        <strong>{{ $first['user'] ?? 'System' }}</strong>
                                        <span class="badge bg-dark text-uppercase ms-2">{{ $first['event'] ?? '' }}</span><br>
                                        <small class="text-muted">
                                            {{ $first['type'] ?? '' }} #{{ $first['id'] ?? '' }}
                                            – {{ $first['timestamp'] ?? '' }}
                                        </small>
                                    </td>
                                </tr>

                                {{-- Each field-level change in this group --}}
                                @foreach ($group as $change)
                                    <tr>
                                        {{-- {{dd($change['new'])}} --}}
                                        <td style="width: 33.3%">
                                            <code class="text-pink">{{ $change['field'] ?? '' }}</code><br>
                                            <small class="text-muted">{{ $change['timestamp'] ?? '' }}</small>
                                        </td>
                                        <td style="width: 33.3%">{{ $change['old'] ?? "" }}</td>
                                        <td style="width: 33.3%">{{ is_array($change['new']) ? json_encode($change['new']) : $change['new'] ?? "" }}</td>
                                    </tr>
                                @endforeach
                            @endif
                        @endforeach

                    </tbody>

                </table>
            </div>
        @elseif ($orderId)
            <div class="alert alert-warning mt-3">
                No order found with ID {{ $orderId }}.
            </div>
        @endif
    </div>
</div>
