@section('page-title')
Login/Register
@endsection
@section('html-class')
login-page
@endsection
<div>
    <div>
        <div>
            @if (session()->has('message'))
                <div>
                    {{ session('message') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div>
                    {{ session('error') }}
                </div>
            @endif
        </div>
    </div>
    @if($registerForm)
        <form class="login">
            <div>
                <div>
                    <div>
                        <label>Name :</label>
                        <input type="text" wire:model="name">
                        @error('name') <span class="error-msg">{{ $message }}</span>@enderror
                    </div>
                </div>
                <div>
                    <div >
                        <label>Email :</label>
                        <input type="text" wire:model="email">
                        @error('email')  <span class="error-msg">{{ $message }}</span>@enderror
                    </div>
                </div>
                <div>
                    <div >
                        <label>Password :</label>
                        <input type="password" wire:model="password">
                        @error('password')  <span class="error-msg">{{ $message }}</span>@enderror
                    </div>
                </div>
                <div style="margin-top: 40px">
                    <button wire:click.prevent="registerStore">Register</button>
                </div>
                <div>
                    <a style="margin-top: 10px" class="button" wire:click.prevent="register">Login</a>
                </div>
            </div>
        </form>
    @else
        <form class="login">
            <div >
                <div>
                    <div >
                        <label>Email</label>
                        <input type="text" wire:model="email">
                        @error('email')  <span class="error-msg">{{ $message }}</span>@enderror
                    </div>
                </div>
                <div>
                    <div >
                        <label>Password</label>
                        <input type="password" wire:model="password">
                        @error('password')  <span class="error-msg">{{ $message }}</span>@enderror
                    </div>
                </div>
                <div style="margin-top: 40px">
                    <button wire:click.prevent="login">Login</button>
                </div>
                <div>
                    <a style="margin-top: 10px" class="button" wire:click.prevent="register">Register</a>
                </div>
            </div>
        </form>
    @endif
</div>