<div>
    @if ($invoiceCreated)
        <div class="alert alert-success">Invoice draft created successfully!</div>
    @else
        @if ($errorMessage)
            <div class="alert alert-danger">{{ $errorMessage }}</div>
        @endif

        <div class="mb-3">
            <label for="customer_name" class="form-label">Customer Name:</label>
            <input type="text" class="form-control" id="customer_name" wire:model="customer_name">
        </div>

        <div class="mb-3">
            <label for="invoice_number" class="form-label">Invoice Number:</label>
            <input type="text" class="form-control" id="invoice_number" wire:model="invoice_number">
        </div>

        <div class="mb-3">
            <label for="invoice_date" class="form-label">Invoice Date:</label>
            <input type="date" class="form-control" id="invoice_date" wire:model="invoice_date">
        </div>

        <div class="mb-3">
            <label for="due_date" class="form-label">Due Date:</label>
            <input type="date" class="form-control" id="due_date" wire:model="due_date">
        </div>

        <div class="mb-3">
            <label for="line_items" class="form-label">Line Items:</label>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Quantity</th>
                        <th>Rate</th>
                        <th>Description</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($line_items as $index => $item)
                        <tr>
                            <td>
                                <input type="text" class="form-control" wire:model="line_items.{{ $index }}.name">
                            </td>
                            <td>
                                <input type="number" class="form-control" wire:model="line_items.{{ $index }}.quantity">
                            </td>
                            <td>
                                <input type="number" class="form-control" wire:model="line_items.{{ $index }}.rate">
                            </td>
                            <td>
                                <input type="text" class="form-control" wire:model="line_items.{{ $index }}.description">
                            </td>
                            <td>
                                @if ($loop->last)
                                    <button wire:click="addLineItem" class="btn btn-success">Add Line Item</button>
                                @endif
                                @if ($loop->first)
                                    <button wire:click="removeLineItem({{ $index }})" class="btn btn-danger">Remove</button>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <button wire:click="createInvoice" class="btn btn-primary">Create Invoice Draft</button>
    @endif
</div>
