<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Import Prices from CSV</h3>
                </div>
                <div class="card-body">
                    @if (session()->has('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if (session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if (session()->has('warning'))
                        <div class="alert alert-warning alert-dismissible fade show" role="alert">
                            {{ session('warning') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if (session()->has('info'))
                        <div class="alert alert-info alert-dismissible fade show" role="alert">
                            <pre style="white-space: pre-wrap; font-size: 12px;">{{ session('info') }}</pre>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if(config('app.debug'))
                        <div class="alert alert-info">
                            <strong>Debug Info:</strong><br>
                            File: {{ $csvFile ? 'Uploaded' : 'None' }}<br>
                            Season: {{ $selectedSeason ?: 'None' }}<br>
                            Styles Available: {{ count($styles) }}<br>
                            @if(count($styles) > 0)
                                First Style: ID={{ $styles->first()->id }}, customer_ref="{{ $styles->first()->customer_ref }}"<br>
                            @endif
                            Import Data: {{ count($importData) }} rows<br>
                            Processed Data: {{ count($processedData) }} rows<br>
                            Show Preview: {{ $showPreview ? 'Yes' : 'No' }}
                        </div>
                    @endif

                    @if (!$importComplete)
                        <form wire:submit.prevent="processCsvFile">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="selectedSeason" class="form-label">Select Season <span class="text-danger">*</span></label>
                                    <select wire:model="selectedSeason" class="form-select @error('selectedSeason') is-invalid @enderror" id="selectedSeason">
                                        <option value="">Choose a season...</option>
                                        @foreach($seasons as $season)
                                            <option value="{{ $season->id }}">{{ $season->description }}</option>
                                        @endforeach
                                    </select>
                                    @error('selectedSeason') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="csvFile" class="form-label">Upload CSV File <span class="text-danger">*</span></label>
                                    <input type="file" wire:model="csvFile" class="form-control @error('csvFile') is-invalid @enderror" id="csvFile" accept=".csv,.txt">
                                    @error('csvFile') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                    <div class="form-text">Upload a comma-separated CSV file with columns: Season, Style, Size, CMT, Quote</div>
                                </div>
                            </div>

                            @if($csvFile && $selectedSeason)
                                <div class="mb-3">
                                    <button type="button" wire:click="processCsvFile" class="btn btn-primary">
                                        <i class="fas fa-upload me-1"></i> Process File
                                    </button>
                                    @if(config('app.debug'))
                                        <button type="button" wire:click="testCsvContent" class="btn btn-info ms-2">
                                            <i class="fas fa-bug me-1"></i> Debug CSV
                                        </button>
                                    @endif
                                </div>
                            @elseif($csvFile && !$selectedSeason)
                                <div class="mb-3">
                                    <div class="alert alert-warning">
                                        Please select a season before processing the file.
                                    </div>
                                    @if(config('app.debug'))
                                        <button type="button" wire:click="testCsvContent" class="btn btn-info">
                                            <i class="fas fa-bug me-1"></i> Debug CSV
                                        </button>
                                    @endif
                                </div>
                            @endif
                        </form>

                        @if($showPreview && count($processedData) > 0)
                            <div class="mt-4">
                                <h5>Preview Import Data</h5>
                                <p class="text-muted">Review the data below and select correct styles for any unmatched entries (highlighted in red).</p>
                                
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>Line</th>
                                                <th>Season</th>
                                                <th>Style</th>
                                                <th>Size</th>
                                                <th>CMT</th>
                                                <th>Quote</th>
                                                <th>Match Status</th>
                                                <th>Select Style</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($processedData as $index => $row)
                                                <tr class="{{ !$row['has_match'] ? 'table-danger' : '' }}">
                                                    <td>{{ $row['original_line'] }}</td>
                                                    <td>{{ $row['season'] }}</td>
                                                    <td>{{ $row['style'] }}</td>
                                                    <td>{{ $row['size'] ?: 'N/A' }}</td>
                                                    <td>{{ $row['cmt'] }}</td>
                                                    <td>{{ $row['quote'] }}</td>
                                                    <td>
                                                        @if($row['has_match'])
                                                            <span class="badge bg-success">Matched</span>
                                                        @else
                                                            <span class="badge bg-danger">No Match</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(!$row['has_match'])
                                                            <select wire:change="updateStyleSelection({{ $index }}, $event.target.value)" class="form-select form-select-sm">
                                                                <option value="">Select Style...</option>
                                                                @foreach($styles as $style)
                                                                    <option value="{{ $style->id }}">{{ $style->customer_ref ?: 'No customer_ref' }}</option>
                                                                @endforeach
                                                            </select>
                                                        @else
                                                            <span class="text-success">{{ $row['matched_style']->customer_ref ?? 'N/A' }}</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <div class="mt-3">
                                    <button wire:click="savePrices" class="btn btn-success">
                                        <i class="fas fa-save me-1"></i> Save Prices
                                    </button>
                                    <button wire:click="resetImport" class="btn btn-secondary ms-2">
                                        <i class="fas fa-undo me-1"></i> Reset
                                    </button>
                                </div>
                            </div>
                        @endif
                    @else
                        <div class="text-center py-4">
                            <div class="mb-3">
                                <i class="fas fa-check-circle text-success" style="font-size: 3rem;"></i>
                            </div>
                            <h4 class="text-success">Import Complete!</h4>
                            <p class="text-muted">The prices have been successfully imported.</p>
                            <button wire:click="resetImport" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i> Import More Prices
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('livewire:load', function () {
        Livewire.on('fileProcessed', () => {
            // Scroll to preview section
            document.querySelector('.table-responsive')?.scrollIntoView({ behavior: 'smooth' });
        });
    });
</script>
@endpush
