<div id="page-content">
	<x-title-bar>
		<x-slot:title>
			MABLI Packing List Import
		</x-slot:title>
		<x-slot:end>
		</x-slot:end>
	</x-title-bar>

	<div class="container-fluid">
		<div class="row">
			<div class="col">
				@if (Session::get('message'))
					<div class="alert {{ Session::get('alert-class') ?? 'alert-info' }}" role="alert">
						{{ Session::get('message') }}
					</div>
				@endif
				@if($errors->all())
					<div class="alert alert-dark" role="alert">
						@foreach ($errors->all() as $error)
							{{ $error }}<br>
						@endforeach
					</div>
				@endif
			</div>
		</div>

		<div class="row p-3">
			<div class="col">
				<div class="input-group">
					<select class="form-select" wire:model="season">
						<option value="">Select Season...</option>
						@foreach($this->seasons as $s)
							<option value="{{$s->id}}">{{$s->description}}</option>
						@endforeach
					</select>
					<input type="file" wire:model="plFiles" multiple class="form-control" accept=".csv, .xls, .xlsx">
					<button class="btn btn-primary" wire:click="parse" wire:loading.attr="disabled" wire:target="parse,plFiles">
						<span wire:loading.remove>Upload</span>
						<span wire:loading wire:target="parse,plFiles">Processing...</span>
					</button>
				</div>
				<div class="form-check mt-2">
					<input id="saveToNewDrop" class="form-check-input" type="checkbox" wire:model="saveToNewDrop">
					<label class="form-check-label" for="saveToNewDrop">Save shipped to a new drop</label>
				</div>
			</div>
		</div>

		@if($this->summary && $this->sizeHeaders)
			<div class="row p-3" wire:loading.remove wire:target="parse,plFiles">
				<div class="col">
					<h6>Summary</h6>
					<table class="table table-sm">
						<thead>
							<tr>
								<th>Style</th>
								<th>Style Name</th>
								<th>Colour (PL | DB)</th>
								<th>Drop</th>
								@foreach($this->sizeHeaders as $sz)
									<th class="text-end">{{$sz}}</th>
								@endforeach
								<th class="text-end">Total (PL)</th>
							</tr>
						</thead>
						<tbody>
						@foreach($this->summary as $idx => $row)
							@php($rowKey = $row['style'].'|'.$row['style_name'].'|'.$row['colour'])
							@php($rowClass = $row['matched_row'] ? '' : 'bg-danger text-white')
							<tr class="{{$rowClass}}">
								<td>{{$row['style']}}</td>
								<td>{{$row['style_name']}}</td>
								<td>
									@if(!$row['matched_row'])
										<select class="form-select form-select-sm" wire:change="setColourOverride('{{$rowKey}}', $event.target.value)">
											<option value="">{{$row['colour']}} | {{ $row['db_colour'] ?: '—' }}</option>
											@foreach($row['colour_options'] as $opt)
												<option value="{{$opt}}" @if(($this->colourOverrides[$rowKey] ?? '') === $opt) selected @endif>{{$row['colour']}} | {{$opt}}</option>
											@endforeach
										</select>
									@else
										{{$row['colour']}} | {{ $row['db_colour'] ?: '—' }}
									@endif
								</td>
								<td>
									@if(!empty($row['drop_candidates']) && count($row['drop_candidates']) > 1)
										<select class="form-select form-select-sm" wire:model="selectedDrops.{{$rowKey}}">
											@foreach($row['drop_candidates'] as $opt)
												<option value="{{$opt['id']}}">{{$opt['label']}}</option>
											@endforeach
										</select>
									@elseif(!empty($row['drop_candidates']))
										<span>#{{$row['drop_candidates'][0]['id']}}</span>
									@endif
								</td>
								@foreach($this->sizeHeaders as $sz)
									@php($drop = $row['sls_sizes'][$sz] ?? 0)
									@php($pl = $row['sizes'][$sz] ?? 0)
									@php($diff = $drop != $pl)
									<td class="text-end align-middle @if($diff) bg-warning @endif">
										@if(($drop ?? 0) != 0 || ($pl ?? 0) != 0)
											<div>Drop: {{$drop}}</div>
											<div>PL: {{$pl}}</div>
										@endif
									</td>
								@endforeach
								<td class="text-end">{{$row['total']}}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>
		@endif

		@if($this->rows)
			<div class="row p-3" wire:loading.remove wire:target="parse,plFiles">
				<div class="col">
					<table class="table table-sm">
						<thead>
							<tr>
								<th>Carton</th>
								<th>Style</th>
								<th>Style Name</th>
								<th>Colour (printed)</th>
								<th>Colour (normalized)</th>
								<th>Size</th>
								<th class="text-end">Qty</th>
							</tr>
						</thead>
						<tbody>
						@foreach($this->rows as $r)
							<tr>
								<td>{{$r['carton'] ?? ''}}</td>
								<td>{{$r['style'] ?? ''}}</td>
								<td>{{$r['style_name'] ?? ''}}</td>
								<td>{{$r['colour'] ?? ''}}</td>
								<td>{{$r['colour_normalized'] ?? ''}}</td>
								<td>{{$r['size'] ?? ''}}</td>
								<td class="text-end">{{$r['qty'] ?? 0}}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
					<div class="text-end">
						<button class="btn btn-primary" wire:click="applyUpdate">Apply Update</button>
					</div>
				</div>
			</div>
		@endif

		<div wire:loading wire:target="parse,plFiles">
			<div class="row">
				<div class="col">
					<img class="rounded mx-auto d-block" src="loading-ai.gif">
					<div class="text-center mt-2">Parsing…</div>
				</div>
			</div>
		</div>
	</div>
</div>
