{{-- shipment-schedule-dev.blade.php --}}
<div id="page-content">
    {{-- Title Bar --}}
    <x-title-bar>
        <x-slot:title>
            Packing List Updater - AI
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
    </x-title-bar>
    <div class="chat-container">

        <div class="chat-input text-end p-3">
            <textarea id="packingListTextarea" class="rich form-control" style="height: 200px" type="text" placeholder="Paste Packing List"></textarea>
            {{-- <button class="btn btn-primary mt-3" wire:click="askQuestion">Send</button> --}}
        </div>
        <div class="chat-history p-3">
            @if($this->answer)
                <div class="row">
                    <div class="col">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Shipment Line ID</th>
                                    <th>Style</th>
                                    <th>Colourway</th>
                                    <th>SLS ID</th>
                                    <th>Size</th>
                                    <th>Ordered Qty</th>
                                    <th class="bg-amber">Shipped Qty</th>
                                    <th>Difference</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($this->answer->matches as $match)
                                <tr>
                                    <td>{{ $match->shipment_line_id ?? "" }}</td>
                                    <td>{{ $match->style_name ?? "" }}</td>
                                    <td>{{ $match->colourway ?? "" }}</td>
                                    <td>{{ $match->sls_id ?? "" }}</td>
                                    <td>{{ $match->size ?? "" }}</td>
                                    <td>{{ $match->qty_ordered ?? "" }}</td>
                                    <td class="bg-amber">{{ $match->shipped_qty ?? 0 }}</td>
                                    <td @if(!$match->shipped_qty >= ($match->qty_ordered * 0.9) && !$match->shipped_qty <= ($match->qty_ordered * 1.1))) class="bg-danger" @endif>{{ ($match->qty_ordered ?? 0) - ($match->shipped_qty ?? 0) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        Cartons: {{$this->answer->total_cartons}}<br>
                        Net Weight: {{$this->answer->net_weight}}<br>
                        Gross Weight: {{$this->answer->gross_weight}}
                    </div>
                </div>
                <div class="row">
                    <div class="col text-end">
                        <button class="btn btn-primary mt-3" wire:click="updateValues">Apply Update?</button>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <div id="answer"></div>

    @script
        <script>
            document.getElementById('packingListTextarea').addEventListener('paste', function() {
                this.disabled = true;
            });

            document.querySelector('textarea.rich').addEventListener('paste', (event) => {
                const clipboardData = event.clipboardData || window.clipboardData;
                const htmlContent = clipboardData.getData('text/html');
                const textContent = clipboardData.getData('text/plain');

                if (htmlContent.includes("<table")) {
                    const csvData = htmlTableToCSV(htmlContent);
                    console.log("CSV Data:", csvData);

                    // Dispatch the event to Livewire with CSV data
                    Livewire.dispatch('csvDataPasted', { csv: csvData });
                } else {
                    console.log("Plain Text Data:", textContent);
                    Livewire.dispatch('csvDataPasted', { csv: textContent }); // Optional for plain text
                }
            });

            function htmlTableToCSV(html) {
                const parser = new DOMParser();
                const doc = parser.parseFromString(html, 'text/html');
                const rows = Array.from(doc.querySelectorAll('table tr'));
                let csv = '';

                rows.forEach(row => {
                    const cells = Array.from(row.querySelectorAll('th, td'));
                    const rowText = cells.map(cell => `"${cell.textContent.trim()}"`).join(",");
                    csv += rowText + "\n";
                });

                return csv;
            }
        </script>
    @endscript
</div>
