<div id="page-content">
    {{-- Title Bar --}}
    <x-title-bar>
        <x-slot:title>
            Asos Packing List Import
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
    </x-title-bar>
    <div class="row">
        <div class="col">
            @if (Session::get('message'))
                <div class="alert {{ Session::get('alert-class') }}" role="alert">
                    {{ Session::get('message') }}
                </div>
            @endif
            @if($errors->all())
                <div class="alert alert-dark" role="alert">
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
    <div class="chat-container">

        <div class="chat-input text-end p-3">
            <div class="input-group">
                <input type="file" wire:model="packingListFiles" multiple class="form-control" accept=".pdf">
                <button class="btn btn-primary" wire:click="uploadPackingList" wire:loading.attr="disabled" @if($this->buttonDisabled()) disabled @endif>
                    <span wire:loading.remove>Upload Packing List</span>
                    <span wire:loading>Processing...</span>
                </button>
            </div>
        </div>
        <div class="chat-history p-3">
            @if($this->answer)
                <div class="row">
                    <div class="col">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>PO Number</th>
                                    <th>PO</th>
                                    <th>Style</th>
                                    <th>Colourway</th>
                                    <th>Size</th>
                                    <th>Ordered Qty</th>
                                    <th class="bg-amber">Shipped Qty</th>
                                    <th>Difference</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($this->answer->matches as $match)
                                    @foreach ($match->sizes as $size)
                                        <tr>
                                            <td>{{ $match->shipment_line_id ?? "" }}</td>
                                            <td>{{ $match->style_name ?? "" }}</td>
                                            <td>{{ $match->colourway ?? "" }}</td>
                                            <td>{{ $size->size ?? "" }}</td>
                                            <td>{{ $size->qty_ordered ?? "" }}</td>
                                            <td class="bg-amber">{{ $size->shipped_qty ?? 0 }}</td>
                                            <td>{{ $size->qty_ordered ?? 0 - $size->shipped_qty ?? 0 }}</td>
                                        </tr>
                                    @endforeach
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="row">
                    <div class="col text-end">
                        <button class="btn btn-primary mt-3" wire:click="updateValues">Apply Update?</button>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <div id="answer"></div>

    @script
        <script>
            document.getElementById('packingListTextarea').addEventListener('paste', function() {
                this.disabled = true;
            });

            document.querySelector('textarea.rich').addEventListener('paste', (event) => {
                const clipboardData = event.clipboardData || window.clipboardData;
                const htmlContent = clipboardData.getData('text/html');
                const textContent = clipboardData.getData('text/plain');

                if (htmlContent.includes("<table")) {
                    const csvData = htmlTableToCSV(htmlContent);
                    console.log("CSV Data:", csvData);

                    // Dispatch the event to Livewire with CSV data
                    Livewire.dispatch('csvDataPasted', { csv: csvData });
                } else {
                    console.log("Plain Text Data:", textContent);
                    Livewire.dispatch('csvDataPasted', { csv: textContent }); // Optional for plain text
                }
            });

            function htmlTableToCSV(html) {
                const parser = new DOMParser();
                const doc = parser.parseFromString(html, 'text/html');
                const rows = Array.from(doc.querySelectorAll('table tr'));
                let csv = '';

                rows.forEach(row => {
                    const cells = Array.from(row.querySelectorAll('th, td'));
                    const rowText = cells.map(cell => `"${cell.textContent.trim()}"`).join(",");
                    csv += rowText + "\n";
                });

                return csv;
            }
        </script>
    @endscript
</div>
