<div id="page-content">
    {{-- Title Bar --}}
    <x-title-bar>
        <x-slot:title>
            ASOS Packing List Import - Waltz Fashion
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
        <x-slot:sub>
            <h5 class="mb-0">Upload ASOS Packing List PDFs</h5>
        </x-slot:sub>
    </x-title-bar>
    
    <div class="row">
        <div class="col">
            @if (Session::get('message'))
                <div class="alert {{ Session::get('alert-class') }}" role="alert">
                    {{ Session::get('message') }}
                </div>
            @endif
            @if($errors->all())
                <div class="alert alert-dark" role="alert">
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
                </div>
            @endif
        </div>
    </div>

    {{-- File Upload Section --}}
    @if(!$showPreview)
    <div class="card">
        <div class="card-body">
            
            <div class="row mt-3">
                <div class="col-md-8">
                    <label for="files" class="form-label">Select PDF Files</label>
                    <input type="file" wire:model="packingListFiles" multiple class="form-control" id="files" accept=".pdf">
                    <div class="form-text">Maximum 30 files allowed. Supported format: PDF</div>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button class="btn btn-primary w-100" wire:click="uploadPackingList" wire:loading.attr="disabled" @if($this->buttonDisabled()) disabled @endif>
                        <span wire:loading.remove wire:target="uploadPackingList">
                            <i class="fas fa-upload me-2"></i>Process Files
                        </span>
                        <span wire:loading wire:target="uploadPackingList">
                            <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                        </span>
                    </button>
                </div>
            </div>
            
            @if($processingFiles)
            <div class="row mt-3">
                <div class="col">
                    <div class="alert alert-info">
                        <i class="fas fa-spinner fa-spin me-2"></i>
                        Processing files... Please wait.
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
    @endif

    {{-- Preview Table Section --}}
    @if($showPreview && !empty($previewData))
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Review Extracted Data</h5>
            <small class="text-muted">Please review the extracted data and database matches before confirming</small>
        </div>
        <div class="card-body">
            {{-- Summary Section --}}
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6 class="card-title">Processing Summary</h6>
                            <p class="mb-1"><strong>Files Processed:</strong> {{ count($previewData) }}</p>
                            <p class="mb-1"><strong>Database Matches:</strong> {{ collect($previewData)->where('db_matches.found', true)->count() }}</p>
                            <p class="mb-1"><strong>Files with Changes:</strong> {{ collect($previewData)->filter(fn($data) => $this->hasChanges($data))->count() }}</p>
                            <p class="mb-0"><strong>Total ASNs Found:</strong> {{ collect($previewData)->sum(fn($data) => count($data['asn_numbers'] ?? [])) }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6 class="card-title">Next Steps</h6>
                            <ol class="mb-0">
                                <li>Review the extracted data below</li>
                                <li>Verify database matches are correct</li>
                                <li>Check that changes look accurate</li>
                                <li>Click "Confirm & Save Changes" when ready</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            
            @foreach($previewData as $index => $data)
            <div class="mb-4">
                <h6 class="border-bottom pb-2">
                    <i class="fas fa-file-pdf me-2 text-danger"></i>
                    {{ $data['filename'] }}
                </h6>
                
                {{-- File Summary --}}
                <div class="row mb-3">
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-hashtag text-primary me-2"></i>
                            <div>
                                <small class="text-muted d-block">PO Number</small>
                                <strong>{{ $data['po_number'] ?? 'Not found' }}</strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-file-invoice text-success me-2"></i>
                            <div>
                                <small class="text-muted d-block">Factory Invoice</small>
                                <strong>{{ $data['factory_invoice'] ?? 'Not found' }}</strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-calendar text-info me-2"></i>
                            <div>
                                <small class="text-muted d-block">ExFty Date</small>
                                <strong>{{ $data['exfty'] ?? 'Not found' }}</strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-barcode text-warning me-2"></i>
                            <div>
                                <small class="text-muted d-block">ASN Numbers</small>
                                <strong>
                                    @if(!empty($data['asn_numbers']) && count($data['asn_numbers']) > 0)
                                        @foreach($data['asn_numbers'] as $index => $asn)
                                            <div class="badge bg-primary me-1 mb-1">{{ $asn }}</div>
                                        @endforeach
                                    @else
                                        Not found
                                    @endif
                                </strong>
                            </div>
                        </div>
                    </div>
                </div>
                
                {{-- ASN Summary --}}
                @if(!empty($data['asn_numbers']) && count($data['asn_numbers']) > 0)
                <div class="row mb-3">
                    <div class="col">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>{{ count($data['asn_numbers']) }} ASN(s) found:</strong>
                            @foreach($data['asn_numbers'] as $index => $asn)
                                <span class="badge bg-primary me-1">{{ $asn }}</span>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif
                
                {{-- Debug Information --}}
                @if(config('app.debug'))
                <div class="row mb-3">
                    <div class="col">
                        <div class="card bg-light">
                            <div class="card-header">
                                <h6 class="mb-0">Debug Information</h6>
                            </div>
                            <div class="card-body">
                                <p><strong>Data Keys:</strong> {{ json_encode(array_keys($data)) }}</p>
                                <p><strong>ASN Data Count:</strong> {{ count($data['asn_data'] ?? []) }}</p>
                                <p><strong>ASN Numbers:</strong> {{ json_encode($data['asn_numbers'] ?? []) }}</p>
                                <p><strong>Has ASN Data:</strong> {{ !empty($data['asn_data']) ? 'Yes' : 'No' }}</p>
                                @if(!empty($data['asn_data']))
                                    <p><strong>ASN Data Structure:</strong></p>
                                    <pre class="bg-white p-2 border">{{ json_encode($data['asn_data'], JSON_PRETTY_PRINT) }}</pre>
                                @endif
                                <p><strong>Full Data Structure:</strong></p>
                                <pre class="bg-white p-2 border">{{ json_encode($data, JSON_PRETTY_PRINT) }}</pre>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                
                {{-- Database Match Status --}}
                @if(!empty($data['db_matches']) && $data['db_matches']['found'])
                <div class="alert alert-success">
                    <i class="fas fa-check-circle me-2"></i>
                    Database match found for PO: {{ $data['db_matches']['customer_po'] ?? 'Unknown' }}
                </div>
                
                @if($this->hasChanges($data))
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    Changes detected! Review the data below before confirming.
                </div>
                @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    No changes detected. All data matches current database values.
                </div>
                @endif
                
                {{-- ASN Breakdown Section --}}
                @if(count($data['asn_numbers']) > 0)
                <div class="mb-4">
                    <h6 class="text-primary mb-3">
                        <i class="fas fa-barcode me-2"></i>ASN Breakdown
                        <button class="btn btn-sm btn-outline-primary ms-2" onclick="toggleAllAsns()">
                            <i class="fas fa-expand-alt me-1"></i>Expand All
                        </button>
                    </h6>
                    
                    @foreach($data['asn_numbers'] as $asn)
                        <div class="card mb-3">
                            <div class="card-header bg-light" style="cursor: pointer;" onclick="toggleAsn({{ $loop->index }})">
                                <h6 class="mb-0">
                                    <i class="fas fa-box text-primary me-2"></i>
                                    ASN: {{ $asn }}
                                    <span class="badge bg-primary ms-2">ASN #{{ $loop->iteration }}</span>
                                    <i class="fas fa-chevron-down float-end" id="asn-chevron-{{ $loop->index }}"></i>
                                </h6>
                            </div>
                            <div class="card-body" id="asn-content-{{ $loop->index }}">
                                {{-- Safety check for db_matches --}}
                                @if(!empty($data['db_matches']) && $data['db_matches']['found'])
                                    {{-- Database comparison table --}}
                                    <div class="table-responsive mb-3">
                                        <h6 class="text-secondary mb-2">ASN Data Comparison</h6>
                                        <table class="table table-sm table-bordered table-hover">
                                            <thead class="table-secondary">
                                                <tr>
                                                    <th width="25%">Field</th>
                                                    <th width="25%">Current (Database)</th>
                                                    <th width="25%">New (PDF)</th>
                                                    <th width="25%">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['net_weight'] ?? null, $data['asn_data'][$loop->index]['net_weight'] ?? null) }}">
                                                    <td><strong>Net Weight (kg)</strong></td>
                                                    <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['net_weight'] ?? null) !!}</td>
                                                    <td>{{ $data['asn_data'][$loop->index]['net_weight'] ?: 'Not found' }}</td>
                                                    <td>
                                                        @if(($data['db_matches']['current_data']['net_weight'] ?? null) != ($data['asn_data'][$loop->index]['net_weight'] ?? null))
                                                            <span class="badge bg-warning">Will Update</span>
                                                        @else
                                                            <span class="badge bg-secondary">No Change</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['gross_weight'] ?? null, $data['asn_data'][$loop->index]['gross_weight'] ?? null) }}">
                                                    <td><strong>Gross Weight (kg)</strong></td>
                                                    <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['gross_weight'] ?? null) !!}</td>
                                                    <td>{{ $data['asn_data'][$loop->index]['gross_weight'] ?: 'Not found' }}</td>
                                                    <td>
                                                        @if(($data['db_matches']['current_data']['gross_weight'] ?? null) != ($data['asn_data'][$loop->index]['gross_weight'] ?? null))
                                                            <span class="badge bg-warning">Will Update</span>
                                                        @else
                                                            <span class="badge bg-secondary">No Change</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['no_cartons'] ?? null, $data['asn_data'][$loop->index]['carton_count'] ?? null) }}">
                                                    <td><strong>Carton Count</strong></td>
                                                    <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['no_cartons'] ?? null) !!}</td>
                                                    <td>{{ $data['asn_data'][$loop->index]['carton_count'] ?: 'Not found' }}</td>
                                                    <td>
                                                        @if(($data['db_matches']['current_data']['no_cartons'] ?? null) != ($data['asn_data'][$loop->index]['carton_count'] ?? null))
                                                            <span class="badge bg-warning">Will Update</span>
                                                        @else
                                                            <span class="badge bg-secondary">No Change</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['exfty'] ?? null, $data['asn_data'][$loop->index]['date'] ?? null) }}">
                                                    <td><strong>ExFty Date</strong></td>
                                                    <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['exfty'] ?? null) !!}</td>
                                                    <td>{{ $data['asn_data'][$loop->index]['date'] ?: 'Not found' }}</td>
                                                    <td>
                                                        @if(($data['db_matches']['current_data']['exfty'] ?? null) != ($data['asn_data'][$loop->index]['date'] ?? null))
                                                            <span class="badge bg-warning">Will Update</span>
                                                        @else
                                                            <span class="badge bg-secondary">No Change</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['factory_invoice'] ?? null, $data['asn_data'][$loop->index]['factory_invoice'] ?? null) }}">
                                                    <td><strong>Factory Invoice</strong></td>
                                                    <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['factory_invoice'] ?? null) !!}</td>
                                                    <td>{{ $data['asn_data'][$loop->index]['factory_invoice'] ?: 'Not found' }}</td>
                                                    <td>
                                                        @if(($data['db_matches']['current_data']['factory_invoice'] ?? null) != ($data['asn_data'][$loop->index]['factory_invoice'] ?? null))
                                                            <span class="badge bg-warning">Will Update</span>
                                                        @else
                                                            <span class="badge bg-secondary">No Change</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr class="{{ $this->getAsnChangeClass($data['db_matches']['current_data']['asn'] ?? [], $data['asn_numbers']) }}">
                                                    <td><strong>ASN Numbers</strong></td>
                                                    <td>{!! $this->formatAsnNumbers($data['db_matches']['current_data']['asn'] ?? []) !!}</td>
                                                    <td>
                                                        @if(!empty($data['asn_numbers']))
                                                            @foreach($data['asn_numbers'] as $asn)
                                                                <div><code>{{ $asn }}</code></div>
                                                            @endforeach
                                                        @else
                                                            <span class="text-muted">No ASN numbers found</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @php
                                                            $currentAsns = $data['db_matches']['current_data']['asn'] ?? [];
                                                            $newAsns = $data['asn_numbers'] ?? [];
                                                            sort($currentAsns);
                                                            sort($newAsns);
                                                            $asnChanged = $currentAsns != $newAsns;
                                                        @endphp
                                                        @if($asnChanged)
                                                            <span class="badge bg-warning">Will Update</span>
                                                        @else
                                                            <span class="badge bg-secondary">No Change</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    {{-- No database match found --}}
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>No database match found</strong> - This appears to be new data that will be created.
                                    </div>
                                @endif
                                
                                {{-- Size Breakdown for this ASN --}}
                                @if(!empty($data['asn_data'][$loop->index]['sizes']))
                                <div class="table-responsive">
                                    <h6 class="text-secondary mb-2">Size Breakdown</h6>
                                    <table class="table table-sm table-bordered table-hover">
                                        <thead class="table-secondary">
                                            <tr>
                                                <th width="20%">Size</th>
                                                <th width="20%">Current Qty</th>
                                                <th width="20%">New Qty</th>
                                                <th width="25%">Composition</th>
                                                <th width="15%">Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($data['asn_data'][$loop->index]['sizes'] as $sizeData)
                                            @php
                                                // Find matching size in database for comparison
                                                $sizeMatch = collect($data['db_matches']['size_matches'] ?? [])->firstWhere('size', $sizeData['size']);
                                                $currentQty = $sizeMatch['current_qty'] ?? 0;
                                                $found = $sizeMatch['found'] ?? false;
                                            @endphp
                                            <tr class="{{ $this->getChangeClass($currentQty, $sizeData['quantity']) }}">
                                                <td><strong>{{ $sizeData['size'] }}</strong></td>
                                                <td>{{ $currentQty }}</td>
                                                <td>{{ $sizeData['quantity'] }}</td>
                                                <td>{{ $sizeMatch['composition'] ?? 'Not found' }}</td>
                                                <td>
                                                    @if($found)
                                                        @if($currentQty != $sizeData['quantity'])
                                                            <span class="badge bg-warning">Will Update</span>
                                                        @else
                                                            <span class="badge bg-secondary">No Change</span>
                                                        @endif
                                                    @else
                                                        <span class="badge bg-danger">Size Not Found</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @else
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    No size information found for this ASN.
                                </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                @else
                    {{-- Fallback: Show global data when ASN-specific data is not available --}}
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>ASN-specific data not available.</strong> Showing global extracted data instead.
                    </div>
                    
                    <div class="card">
                        <div class="card-header bg-light">
                            <h6 class="mb-0">
                                <i class="fas fa-globe me-2"></i>Global Data (Fallback)
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive mb-3">
                                <h6 class="text-secondary mb-2">Global Data Comparison</h6>
                                <table class="table table-sm table-bordered table-hover">
                                    <thead class="table-secondary">
                                        <tr>
                                            <th width="25%">Field</th>
                                            <th width="25%">Current Value</th>
                                            <th width="25%">New Value</th>
                                            <th width="25%">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['net_weight'] ?? null, $data['net_weight'] ?? null) }}">
                                            <td><strong>Net Weight (kg)</strong></td>
                                            <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['net_weight'] ?? null) !!}</td>
                                            <td>{{ $data['net_weight'] ?: 'Not found' }}</td>
                                            <td>
                                                @if(($data['db_matches']['current_data']['net_weight'] ?? null) != ($data['net_weight'] ?? null))
                                                    <span class="badge bg-warning">Will Update</span>
                                                @else
                                                    <span class="badge bg-secondary">No Change</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['gross_weight'] ?? null, $data['gross_weight'] ?? null) }}">
                                            <td><strong>Gross Weight (kg)</strong></td>
                                            <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['gross_weight'] ?? null) !!}</td>
                                            <td>{{ $data['gross_weight'] ?: 'Not found' }}</td>
                                            <td>
                                                @if(($data['db_matches']['current_data']['gross_weight'] ?? null) != ($data['gross_weight'] ?? null))
                                                    <span class="badge bg-warning">Will Update</span>
                                                @else
                                                    <span class="badge bg-secondary">No Change</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr class="{{ $this->getChangeClass($data['db_matches']['current_data']['no_cartons'] ?? null, $data['no_cartons'] ?? null) }}">
                                            <td><strong>Carton Count</strong></td>
                                            <td>{!! $this->formatCurrentValue($data['db_matches']['current_data']['no_cartons'] ?? null) !!}</td>
                                            <td>{{ $data['no_cartons'] ?: 'Not found' }}</td>
                                            <td>
                                                @if(($data['db_matches']['current_data']['no_cartons'] ?? null) != ($data['no_cartons'] ?? null))
                                                    <span class="badge bg-warning">Will Update</span>
                                                @else
                                                    <span class="badge bg-secondary">No Change</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            
                            @if(!empty($data['sizes']))
                            <div class="table-responsive">
                                <h6 class="text-secondary mb-2">Global Size Breakdown</h6>
                                <table class="table table-sm table-bordered table-hover">
                                    <thead class="table-secondary">
                                        <tr>
                                            <th width="20%">Size</th>
                                            <th width="20%">Current Qty</th>
                                            <th width="20%">New Qty</th>
                                            <th width="25%">Composition</th>
                                            <th width="15%">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($data['sizes'] as $size)
                                        @php
                                            $sizeMatch = collect($data['db_matches']['size_matches'] ?? [])->firstWhere('size', $size['size']);
                                            $currentQty = $sizeMatch['current_qty'] ?? 0;
                                            $found = $sizeMatch['found'] ?? false;
                                        @endphp
                                        <tr class="{{ $this->getChangeClass($currentQty, $size['qty'] ?? $size['quantity'] ?? 0) }}">
                                            <td><strong>{{ $size['size'] }}</strong></td>
                                            <td>{{ $currentQty }}</td>
                                            <td>{{ $size['qty'] ?? $size['quantity'] ?? 'Not found' }}</td>
                                            <td>{{ $size['composition'] ?: 'Not found' }}</td>
                                            <td>
                                                @if($found)
                                                    @if($currentQty != ($size['qty'] ?? $size['quantity'] ?? 0))
                                                        <span class="badge bg-warning">Will Update</span>
                                                    @else
                                                        <span class="badge bg-secondary">No Change</span>
                                                    @endif
                                                @else
                                                    <span class="badge bg-danger">Size Not Found</span>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        @endforeach
    @endif
            
            {{-- Action Buttons --}}
            <div class="row mt-4">
                <div class="col">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <button class="btn btn-secondary" wire:click="cancelPreview">
                                <i class="fas fa-times me-2"></i>Cancel & Start Over
                            </button>
                        </div>
                        <div>
                            @php
                                $filesWithChanges = collect($previewData)->filter(fn($data) => $this->hasChanges($data))->count();
                                $totalFiles = count($previewData);
                            @endphp
                            
                            @if($filesWithChanges > 0)
                            <div class="alert alert-warning d-inline-block me-3 mb-0">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <strong>{{ $filesWithChanges }}</strong> of {{ $totalFiles }} files have changes
                            </div>
                            @endif
                            
                            <button class="btn btn-success btn-lg" wire:click="confirmAndSave" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="confirmAndSave">
                                    <i class="fas fa-check me-2"></i>Confirm & Save Changes
                                </span>
                                <span wire:loading wire:target="confirmAndSave">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Saving...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    @script
        <script>
            // Auto-hide alerts after 5 seconds
            setTimeout(function() {
                const alerts = document.querySelectorAll('.alert');
                alerts.forEach(function(alert) {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                });
            }, 5000);
            
            // Function to toggle all ASNs
            function toggleAllAsns() {
                const asnContents = document.querySelectorAll('[id^="asn-content-"]');
                const chevrons = document.querySelectorAll('[id^="asn-chevron-"]');
                
                asnContents.forEach(function(content, index) {
                    const chevron = chevrons[index];
                    if (chevron) {
                        chevron.classList.toggle('fa-chevron-down');
                        chevron.classList.toggle('fa-chevron-up');
                        content.style.display = content.style.display === 'none' ? 'block' : 'none';
                    }
                });
            }
            
            // Function to toggle a specific ASN
            function toggleAsn(index) {
                const content = document.getElementById(`asn-content-${index}`);
                const chevron = document.getElementById(`asn-chevron-${index}`);
                
                if (content && chevron) {
                    chevron.classList.toggle('fa-chevron-down');
                    chevron.classList.toggle('fa-chevron-up');
                    content.style.display = content.style.display === 'none' ? 'block' : 'none';
                }
            }
        </script>
    @endscript
</div>
