<div>
    <div class="w-100" wire:loading>
        Proccessing...
    </div>
    @if($imported)
        <div class="alert alert-success">
            Done! Orders imported successfully.
        </div>
    @else
        <div wire:loading.remove>
            @error('csvFile')
                <div class="alert alert-danger mb-3">
                    <strong>Error:</strong> {{ $message }}
                </div>
            @enderror
            
            <div class="form-group mb-3">
                <label for="csvFile">Select CSV File</label>
                <input type="file" class="form-control @error('csvFile') is-invalid @enderror" id="csvFile" wire:model="csvFile" accept=".csv">
                <small class="form-text text-muted">
                    Required columns: season, customer_address, description, colourways_name, customer_po, exfty
                </small>
            </div>
            <button class="btn btn-primary" wire:click="importOrders" @if(!$csvFile) disabled @endif>
                Import Orders
            </button>
        </div>
    @endif
</div>
