<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Import AI Orders - KWT
        </x-slot:title>
        <x-slot:end>
        </x-slot:end>
    </x-title-bar>
    <div class="container-fluid">
        {{-- Alert Messages --}}
        <div class="row mb-4">
            <div class="col">
                {{-- Upload Processing Results --}}
                @if(session('upload_success'))
                    <div class="alert alert-success alert-dismissible fade show shadow-sm order-upload-alert" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        {{ session('upload_success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('upload_errors'))
                    <div class="alert alert-warning alert-dismissible fade show shadow-sm order-upload-alert" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Some files could not be processed:</strong>
                        <ul class="mb-0 mt-2">
                            @foreach(session('upload_errors') as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('message'))
                    <div class="alert alert-info alert-dismissible fade show shadow-sm order-upload-alert" role="alert">
                        <i class="fas fa-info-circle me-2"></i>
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                {{-- Order Creation Results --}}
                @if(session('messages'))
                    @if(!empty(session('messages.errors')))
                        <div class="alert alert-danger alert-dismissible fade show shadow-sm order-upload-alert" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Errors Found:</strong>
                            <ul class="mb-0 mt-2">
                                @foreach(session('messages.errors') as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if(!empty(session('messages.saved')))
                        <div class="alert alert-success alert-dismissible fade show shadow-sm order-upload-alert" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            <strong>Orders Saved Successfully:</strong>
                            <ul class="mb-0 mt-2">
                                @foreach(session('messages.saved') as $saved)
                                    <li>{{ $saved }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                @endif
                @if($errors->all())
                    <div class="alert alert-warning alert-dismissible fade show shadow-sm order-upload-alert" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <strong>Validation Errors:</strong>
                        <ul class="mb-0 mt-2">
                        @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                        @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
            </div>
        </div>

        <!-- Configuration Section -->
        <div class="row mb-4 order-upload-section">
            <div class="col">
                <div class="card shadow-sm border-0 order-upload-card">
                    <div class="card-header bg-light border-0 order-upload-card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-cog me-2 text-primary"></i>Configuration
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="customer" class="form-label fw-semibold">Customer</label>
                                <select class="form-select" wire:model="customer" id="customer">
                        <option value="">Select Customer...</option>
                        @foreach($this->customers as $customer)
                            <option value="{{$customer->id}}">{{$customer->name}}</option>
                        @endforeach
                    </select>
                            </div>
                            <div class="col-md-6">
                                <label for="season" class="form-label fw-semibold">Season</label>
                                <select class="form-select" wire:model="season" id="season">
                        <option value="">Select Season...</option>
                        @foreach($this->seasons as $season)
                            <option value="{{$season->id}}">{{$season->description}}</option>
                        @endforeach
                    </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Upload Section -->
        <div class="row mb-4 order-upload-section">
            <div class="col">
                <div class="card shadow-sm border-0 order-upload-card">
                    <div class="card-header bg-light border-0 order-upload-card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-upload me-2 text-primary"></i>Upload Orders
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Input Method Toggle -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Input Method</label>
                            <div class="btn-group w-100" role="group" aria-label="Input method">
                                <input type="radio" class="btn-check" name="inputMethod" id="fileMethod" value="file" wire:model.live="inputMethod">
                                <label class="btn btn-outline-primary" for="fileMethod">
                                    <i class="fas fa-file-upload me-2"></i>Upload Files
                                </label>
                                
                                <input type="radio" class="btn-check" name="inputMethod" id="textMethod" value="text" wire:model.live="inputMethod">
                                <label class="btn btn-outline-primary" for="textMethod">
                                    <i class="fas fa-paste me-2"></i>Paste Text
                                </label>
                            </div>
                        </div>

                        <!-- File Upload Input -->
                        @if($inputMethod === 'file')
                        <div class="mb-3">
                            <label for="fileUpload" class="form-label fw-semibold">Select Files</label>
                            <div class="input-group">
                    <input type="file" wire:model="orderFiles" multiple class="form-control" accept=".xls, .xlsx, .pdf, .csv" id="fileUpload">
                    <button class="btn btn-primary" wire:click="uploadOrders" id="uploadButton" wire:loading.attr="disabled" @if($this->buttonDisabled()) disabled @endif>
                                    <span wire:loading.remove>
                                        <i class="fas fa-upload me-2"></i>Upload Orders
                                    </span>
                                    <span wire:loading>
                                        <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                                    </span>
                                </button>
                            </div>
                            <div class="form-text">
                                <i class="fas fa-info-circle me-1"></i>
                                Supported formats: PDF, Excel (.xls, .xlsx), CSV. Maximum 10 files.
                            </div>
                        </div>
                        @endif

                        <!-- Text Input -->
                        @if($inputMethod === 'text')
                        <div class="mb-3">
                            <label for="orderText" class="form-label fw-semibold">Order Content</label>
                            <textarea 
                                class="form-control" 
                                id="orderText" 
                                wire:model="orderText" 
                                rows="6" 
                                placeholder="Paste your order content here (PDF text, Excel data, or any order text)..."
                            ></textarea>
                            <div class="d-grid gap-2 mt-2">
                                <button class="btn btn-primary" wire:click="uploadOrders" wire:loading.attr="disabled">
                                    <span wire:loading.remove>
                                        <i class="fas fa-magic me-2"></i>Process Text
                                    </span>
                                    <span wire:loading>
                                        <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                                    </span>
                    </button>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        @if($this->files)
            <!-- Orders Table Section -->
            <div class="row mb-4 order-upload-section" wire:loading.remove>
                <div class="col">
                <div class="card shadow-sm border-0 order-upload-card">
                    <div class="card-header bg-light border-0 order-upload-card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-table me-2 text-primary"></i>Order Details
                        </h5>
                    </div>
                        <div class="card-body p-0">
                            <div class="table-responsive order-upload-table-responsive" x-data="{ clip:'' }"
                        @copy.window="if ($event.target.type==='date') clip=$event.target.value"
                        @paste.window="if ($event.target.type==='date' && clip) {
                                $event.preventDefault(); $event.target.value=clip;
                                $event.target.dispatchEvent(new Event('input',{bubbles:true}));
                        }">
                                <table class="table table-hover mb-0 order-upload-table">
                                <thead class="table-light">
                                    <tr>
                                        <th class="fw-semibold" style="white-space: nowrap;">
                                            <i class="fas fa-hashtag me-1"></i>PO Number
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap;">
                                            <i class="fas fa-calendar me-1"></i>Date
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap;">
                                            <i class="fas fa-shipping-fast me-1"></i>Incoterms
                                        </th>
                                        <th class="fw-semibold">
                                            <i class="fas fa-map-marker-alt me-1"></i>Delivery Address
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap;">
                                            <i class="fas fa-truck me-1"></i>Drop
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap; min-width: 200px">
                                            <i class="fas fa-calendar me-1"></i>Dates
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap; min-width: 300px">
                                            <i class="fas fa-info-circle me-1"></i>Style & Colourway
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap; min-width: 100px">
                                            <i class="fas fa-ruler me-1"></i>Size
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap; min-width: 100px">
                                            <i class="fas fa-cubes me-1"></i>Qty
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap;">
                                            <i class="fas fa-dollar-sign me-1"></i>Price (PO)
                                        </th>
                                        <th class="fw-semibold" style="white-space: nowrap;">
                                            <i class="fas fa-money-bill me-1"></i>Price (Loop)
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($this->files as $f => $file)
                                        @foreach($file['purchase_orders'] as $o => $order)
                                            @foreach($order['styles'] as $s => $style)
                                                @foreach($style['colorways'] as $c => $colorway)
                                                    @foreach($colorway['shipments'] ?? [] as $sh => $shipment)
                                                        @foreach($shipment['size_quantities'] ?? [] as $si => $size)
                                                    <tr>
                                                        @if ($loop->parent->parent->parent->first && $loop->parent->parent->first && $loop->parent->first && $loop->first)
                                                            <td rowspan="{{$this->countSizesInOrder($order)}}">
                                                                <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.po_number" wire:key="po_number-{{$f}}-{{$o}}">
                                                                <div class="mt-2">
                                                                    <span class="badge bg-primary fs-6">
                                                                        <i class="fas fa-cubes me-1"></i>Total: {{ number_format($this->getTotalQtyForOrder($order)) }}
                                                                    </span>
                                                                </div>
                                                            </td>
                                                            <td rowspan="{{$this->countSizesInOrder($order)}}">
                                                                <input type="date" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.date" wire:key="date-{{$f}}-{{$o}}">
                                                            </td>
                                                            <td rowspan="{{$this->countSizesInOrder($order)}}">
                                                                <select class="form-select" wire:model="files.{{$f}}.purchase_orders.{{$o}}.incoterms" wire:key="incoterms-{{$f}}-{{$o}}">
                                                                    <option value=""></option>
                                                                    <option value="EXW">EXW</option>
                                                                    <option value="FCA">FCA</option>
                                                                    <option value="CPT">CPT</option>
                                                                    <option value="CIP">CIP</option>
                                                                    <option value="DAP">DAP</option>
                                                                    <option value="DPU">DPU</option>
                                                                    <option value="DDP">DDP</option>
                                                                    <option value="FAS">FAS</option>
                                                                    <option value="FOB">FOB</option>
                                                                    <option value="CFR">CFR</option>
                                                                    <option value="CIF">CIF</option>
                                                                </select>
                                                            </td>
                                                            <td rowspan="{{$this->countSizesInOrder($order)}}" class="@if($order['delivery_address_id']) bg-good @else bg-red @endif">
                                                                <select class="form-select" wire:model="files.{{$f}}.purchase_orders.{{$o}}.delivery_address_id" wire:key="delivery_address-{{$f}}-{{$o}}">
                                                                    <option value="">Select...</option>
                                                                    @foreach($this->addresses as $address)
                                                                        <option value="{{$address['id']}}">{{$address['name']}}</option>
                                                                    @endforeach
                                                                </select>
                                                                
                                                            </td>
                                                        @endif
                                                        <!-- Drop info (merged cell) -->
                                                        @if($loop->first)
                                                            <td rowspan="{{ $this->countSizesInShipment($shipment) }}">
                                                                Drop {{ $sh + 1 }}
                                                            </td>
                                                            <td rowspan="{{ $this->countSizesInShipment($shipment) }}" class="date-column">
                                                                <div class="d-flex flex-column gap-2">
                                                                    <div>
                                                                        <label class="form-label small text-muted mb-1">
                                                                            <i class="fas fa-calendar-check me-1"></i>Customer Exfty
                                                                        </label>
                                                                        <input type="date" class="form-control form-control-sm" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.shipments.{{$sh}}.customer_exfty" wire:key="customer_exfty-{{$f}}-{{$o}}-{{$s}}-{{$c}}-{{$sh}}">
                                                                    </div>
                                                                    <div>
                                                                        <label class="form-label small text-muted mb-1">
                                                                            <i class="fas fa-warehouse me-1"></i>Customer Into W/H
                                                                        </label>
                                                                        <input type="date" class="form-control form-control-sm" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.shipments.{{$sh}}.customer_into_wh" wire:key="customer_into_wh-{{$f}}-{{$o}}-{{$s}}-{{$c}}-{{$sh}}">
                                                                    </div>
                                                                    <div>
                                                                        <label class="form-label small text-muted mb-1">
                                                                            <i class="fas fa-calendar-alt me-1"></i>Exfty
                                                                        </label>
                                                                        <input type="date" class="form-control form-control-sm" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.shipments.{{$sh}}.exfty" wire:key="exfty-{{$f}}-{{$o}}-{{$s}}-{{$c}}-{{$sh}}">
                                                                    </div>
                                                                    <div>
                                                                        <label class="form-label small text-muted mb-1">
                                                                            <i class="fas fa-play me-1"></i>Start Date
                                                                        </label>
                                                                        <input type="date" class="form-control form-control-sm" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.start_knit" wire:key="start_knit-{{$f}}-{{$o}}-{{$s}}-{{$c}}-{{$sh}}">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        @endif
                                                        
                                                        <!-- Style & Colorway info (merged cells) - show for each drop -->
                                                        @if($loop->first)
                                                            <td rowspan="{{ $this->countSizesInShipment($shipment) }}" class="@if(isset($style['unmatched']) && $style['unmatched']) bg-warning @elseif($colorway['colorway_id']) bg-good @elseif(isset($colorway['unmatched']) && $colorway['unmatched']) bg-warning @else bg-red @endif style-column">
                                                                @if(isset($style['unmatched']) && $style['unmatched'])
                                                                    <span class="text-warning">⚠️ Style not found</span>
                                                                @else
                                                                    <div class="d-flex flex-column gap-2">
                                                                        <div>
                                                                            <label class="form-label small text-muted mb-1">
                                                                                <i class="fas fa-palette me-1"></i>Style
                                                                            </label>
                                                                            <select style="min-width: 250px" class="form-select form-select-sm @if(isset($style['unmatched']) && $style['unmatched']) border-warning @endif" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.style_version_id" wire:change="selectStyle({{$f}}, {{$o}}, {{$s}}, $event.target.value)" wire:key="style-{{$f}}-{{$o}}-{{$s}}-{{$sh}}">
                                                                                <option value="">Select Style...</option>
                                                                                @foreach($this->styles() as $styleOption)
                                                                                    <option value="{{$styleOption->id}}">{{$styleOption->styles->customer_ref ?? ''}} | {{$styleOption->styles->designs_id ?? ''}} | {{$styleOption->styles->designs->description ?? ''}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                            @if(isset($style['unmatched']) && $style['unmatched'])
                                                                                <small class="text-warning d-block mt-1">⚠️ Style not found - please select manually</small>
                                                                            @endif
                                                                        </div>
                                                                        <div>
                                                                            <label class="form-label small text-muted mb-1">
                                                                                <i class="fas fa-palette me-1"></i>Colourway
                                                                            </label>
                                                                            @if(isset($style['unmatched']) && $style['unmatched'])
                                                                                <span class="text-warning">⚠️ Style not found - cannot load colorways</span>
                                                                            @elseif(!$style['style_version_id'])
                                                                                <span class="text-muted">Please select a style first</span>
                                                                            @else
                                                                                <select style="min-width: 250px" class="form-select form-select-sm @if(isset($colorway['unmatched']) && $colorway['unmatched']) border-warning @endif" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.colorway_id" wire:change="selectColorway({{$f}}, {{$o}}, {{$s}}, {{$c}}, $event.target.value)" wire:key="colorway-{{$f}}-{{$o}}-{{$s}}-{{$c}}-{{$sh}}">
                                                                                    <option value="">Select Colorway...</option>
                                                                                    @foreach($this->colourways($style['style_version_id']) as $cw)
                                                                                        <option value="{{$cw->id}}">{{$cw->style_versions->name ?? ""}} | {{$cw->name}}</option>
                                                                                    @endforeach
                                                                                </select>
                                                                                @if(isset($colorway['unmatched']) && $colorway['unmatched'])
                                                                                    <small class="text-warning d-block mt-1">⚠️ Colorway not found - please select manually</small>
                                                                                @endif
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                            </td>
                                                        @endif
                                                        
                                                        <!-- Size and quantity for this specific drop -->
                                                        <td>
                                                            <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.shipments.{{$sh}}.size_quantities.{{$si}}.size" wire:key="size-{{$f}}-{{$o}}-{{$s}}-{{$c}}-{{$sh}}-{{$si}}">
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.shipments.{{$sh}}.size_quantities.{{$si}}.quantity" wire:key="quantity-{{$f}}-{{$o}}-{{$s}}-{{$c}}-{{$sh}}-{{$si}}">
                                                        </td>
                                                        <td>{{ $size['price'] ?? "" }}</td>
                                                        <td>{{ $size['quote'] ?? "" }}</td>
                                                    </tr>
                                                        @endforeach
                                                    @endforeach
                                                @endforeach
                                            @endforeach
                                        @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

            </div>
            <!-- Bulk Date Application Section -->
            <div class="row mb-3 order-upload-section" x-data="{ clipp:'' }"
                        @copy.window="if ($event.target.type==='date') clipp=$event.target.value"
                        @paste.window="if ($event.target.type==='date' && clipp) {
                                $event.preventDefault(); $event.target.value=clipp;
                                $event.target.dispatchEvent(new Event('input',{bubbles:true}));
                        }">
                <div class="col">
                <div class="card order-upload-card">
                    <div class="card-header order-upload-card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-calendar-plus me-2 text-primary"></i>Bulk Date Application
                        </h5>
                    </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <!-- Scope Selection -->
                                <div class="col-12">
                                    <label class="form-label fw-semibold">Apply To</label>
                                    <div class="row g-2">
                                        <div class="col-md-4">
                                            <select class="form-select" wire:model="bulk_file_index" wire:change="$set('bulk_order_index', null); $set('bulk_drop_index', null)">
                                                <option value="">All Files</option>
                                                @foreach(array_keys($this->files ?? []) as $fileIdx)
                                                    <option value="{{$fileIdx}}">File {{$fileIdx+1}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <select class="form-select" wire:model="bulk_order_index" wire:change="$set('bulk_drop_index', null)">
                                                <option value="">All Orders</option>
                                                @if(isset($this->bulk_file_index) && isset($this->files[$this->bulk_file_index]['purchase_orders']))
                                                    @foreach(array_keys($this->files[$this->bulk_file_index]['purchase_orders']) as $orderIdx)
                                                        <option value="{{$orderIdx}}">Order {{$orderIdx+1}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <select class="form-select" wire:model="bulk_drop_index">
                                                <option value="">All Drops</option>
                                                @php $maxDrops = 0; @endphp
                                                @if(isset($this->bulk_file_index) && isset($this->bulk_order_index) && isset($this->files[$this->bulk_file_index]['purchase_orders'][$this->bulk_order_index]))
                                                    @foreach(($this->files[$this->bulk_file_index]['purchase_orders'][$this->bulk_order_index]['styles'] ?? []) as $s => $st)
                                                        @foreach(($st['colorways'] ?? []) as $c => $cw)
                                                            @php $maxDrops = max($maxDrops, count($cw['shipments'] ?? [])); @endphp
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                                @for($i=0; $i<$maxDrops; $i++)
                                                    <option value="{{$i}}">Drop {{ $i+1 }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Date Fields -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold">Order Date</label>
                                    <input type="date" class="form-control" wire:model="order_date" wire:key="order_date">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold">Incoterms</label>
                    <select class="form-select" wire:model="incoterms" wire:key="incoterms">
                        <option value=""></option>
                        <option value="EXW">EXW</option>
                        <option value="FCA">FCA</option>
                        <option value="CPT">CPT</option>
                        <option value="CIP">CIP</option>
                        <option value="DAP">DAP</option>
                        <option value="DPU">DPU</option>
                        <option value="DDP">DDP</option>
                        <option value="FAS">FAS</option>
                        <option value="FOB">FOB</option>
                        <option value="CFR">CFR</option>
                        <option value="CIF">CIF</option>
                    </select>
                </div>
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold">Customer Exfty</label>
                                    <input type="date" class="form-control" wire:model="customer_exfty" wire:key="customer_exfty">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold">Customer Into W/H</label>
                                    <input type="date" class="form-control" wire:model="customer_into_wh" wire:key="customer_into_wh">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold">Start Knit</label>
                                    <input type="date" class="form-control" wire:model="start_knit" wire:key="start_knit">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold">Exfty</label>
                                    <input type="date" class="form-control" wire:model="exfty" wire:key="exfty">
                                </div>
                                <div class="col-md-6 d-flex align-items-end">
                                    <button class="btn btn-primary btn-lg w-100" wire:click="bulkDates">
                                        <i class="fas fa-magic me-2"></i>Apply Dates
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                
            </div>
            <!-- Action Section -->
            <div class="row mb-3 order-upload-section" wire:loading.remove>
                <div class="col">
                    <div class="card order-upload-card">
                        <div class="card-body text-center">
                            <button class="btn btn-success px-4" wire:click="createOrders">
                                <i class="fas fa-check-circle me-2"></i>Create Orders
                            </button>
                            <p class="text-muted mt-2 mb-0">Review the order details above before creating</p>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <!-- Loading Section -->
        <div wire:loading>
            <div class="row order-upload-section">
                <div class="col">
                    <div class="card order-upload-card">
                        <div class="card-body text-center py-4">
                            <img class="rounded mx-auto d-block mb-3" src="loading-ai.gif" alt="Loading...">
                            <h5 class="text-muted">Processing Orders...</h5>
                            <p class="text-muted mb-0">AI is analyzing your order data</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @script
    <script>
        document.addEventListener('livewire:load', function () {
            // Handle file upload validation
            document.addEventListener('change', function(e) {
                if (e.target.id === 'fileUpload') {
                    const fileCount = e.target.files.length;

                if (fileCount > 10) {
                    alert("You are only allowed to upload a maximum of 10 files.");
                    $wire.dispatch('toggleuploadbutton', true);
                } else {
                    $wire.dispatch('toggleuploadbutton', false);
                    }
                }
            });
        });
    </script>
    @endscript
    <script>
        document.addEventListener('livewire:load', () => {
            let dateClipboard = '';

            // Remove any previous delegated handlers (defensive)
            document.removeEventListener('copy', handleCopy, true);
            document.removeEventListener('paste', handlePaste, true);

            // Attach once, in the capture phase, so it fires before Livewire’s own listeners.
            document.addEventListener('copy',  handleCopy,  true);
            document.addEventListener('paste', handlePaste, true);

            function handleCopy(e) {
                if (e.target.matches('input[type="date"]')) {
                    dateClipboard = e.target.value;          // store the copied date
                    // optional: toast or console.log
                }
            }

            function handlePaste(e) {
                if (e.target.matches('input[type="date"]') && dateClipboard) {
                    e.preventDefault();                      // stop the browser’s default paste
                    e.target.value = dateClipboard;          // set the value
                    // Tell Livewire the input changed:
                    e.target.dispatchEvent(new Event('input', { bubbles: true }));
                }
            }
        });
    </script>
    
    <style>
        /* Compact table styling */
        .table {
            font-size: 0.875rem;
        }
        
        .table th {
            font-size: 0.8rem;
            padding: 0.5rem 0.375rem;
            border-bottom: 2px solid #dee2e6;
        }
        
        .table td {
            padding: 0.375rem;
            vertical-align: top;
            border-bottom: 1px solid #dee2e6;
        }
        
        /* Date column styling */
        .date-column {
            min-width: 180px;
        }
        
        .date-column .form-label {
            font-size: 0.7rem;
            font-weight: 600;
            color: #6c757d;
            margin-bottom: 0.2rem;
        }
        
        .date-column .form-control-sm {
            font-size: 0.8rem;
            padding: 0.25rem 0.375rem;
            height: calc(1.5em + 0.5rem + 2px);
        }
        
        .date-column .d-flex.flex-column.gap-2 > div {
            margin-bottom: 0.375rem;
        }
        
        .date-column .d-flex.flex-column.gap-2 > div:last-child {
            margin-bottom: 0;
        }
        
        /* Style & Colorway column styling */
        .style-column {
            min-width: 250px;
        }
        
        .style-column .form-label {
            font-size: 0.7rem;
            font-weight: 600;
            color: #6c757d;
            margin-bottom: 0.2rem;
        }
        
        .style-column .form-select-sm {
            font-size: 0.8rem;
            padding: 0.25rem 0.375rem;
            height: calc(1.5em + 0.5rem + 2px);
        }
        
        .style-column .d-flex.flex-column.gap-2 > div {
            margin-bottom: 0.375rem;
        }
        
        .style-column .d-flex.flex-column.gap-2 > div:last-child {
            margin-bottom: 0;
        }
        
        /* Form controls */
        .form-control, .form-select {
            font-size: 0.8rem;
            padding: 0.25rem 0.375rem;
            height: calc(1.5em + 0.5rem + 2px);
        }
        
        /* Card styling */
        .card {
            border: 1px solid #dee2e6;
        }
        
        .card-header {
            padding: 0.75rem 1rem;
            background-color: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
        }
        
        .card-body {
            padding: 1rem;
        }
        
        /* Button styling */
        .btn {
            font-size: 0.875rem;
            padding: 0.375rem 0.75rem;
        }
        
        .btn-lg {
            font-size: 1rem;
            padding: 0.5rem 1rem;
        }
        
        /* Alert styling */
        .alert {
            font-size: 0.875rem;
            padding: 0.75rem 1rem;
        }
        
        /* Table responsive */
        .table-responsive {
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
        }
        
        /* Remove large margins */
        .order-upload-section {
            margin-bottom: 1.5rem !important;
        }
        
        .order-upload-card {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }
        
        /* Compact form groups */
        .form-label {
            font-size: 0.875rem;
            font-weight: 600;
            margin-bottom: 0.375rem;
        }
        
        /* Small text for help */
        .form-text {
            font-size: 0.75rem;
        }
        
        .text-muted {
            font-size: 0.8rem;
        }
    </style>
</div>
