<div>
    <h4>Simple Order Import</h4>

    @if (session()->has('message'))
        <div class="alert alert-info">{{ session('message') }}</div>
    @endif

    @if (!empty($errorsList))
        <div class="alert alert-warning">
            <ul class="mb-0">
                @foreach($errorsList as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row g-3 mb-3">
        <div class="col-md-4">
            <label class="form-label">Season</label>
            <select class="form-select" wire:model="season_id">
                <option value="">Select season</option>
                @foreach($this->seasons as $s)
                    <option value="{{ $s->id }}">{{ $s->description }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">Customer</label>
            <select class="form-select" wire:model="customer_id">
                <option value="">Select customer</option>
                @foreach($this->customers as $c)
                    <option value="{{ $c->id }}">{{ $c->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">CSV</label>
            <input type="file" class="form-control" wire:model="csv" accept=".csv">
        </div>
        <div class="col-md-12 d-flex gap-2 align-items-end">
            <button class="btn btn-secondary" wire:click="process" wire:loading.attr="disabled">
                Upload and Process
            </button>
            <div wire:loading class="text-muted small">Processing...</div>
        </div>
    </div>

    @if (!empty($preview))
        <div class="mb-3">
            <button class="btn btn-primary" wire:click="save">Save Orders</button>
        </div>
        @foreach($preview as $oIndex => $order)
            <div class="card mb-3">
                <div class="card-header">
                    <strong>PO:</strong> {{ $order['po'] }}
                </div>
                <div class="card-body p-0">
                    <div class="p-3 d-flex gap-3 align-items-end">
                        <div>
                            <label class="form-label">Order Date</label>
                            <input type="date" class="form-control" wire:model="preview.{{$oIndex}}.order_date">
                        </div>
                        <div>
                            <label class="form-label">Incoterms</label>
                            <select class="form-select" wire:model="preview.{{$oIndex}}.incoterms">
                                <option value="EXW">EXW</option>
                                <option value="FCA">FCA</option>
                                <option value="CPT">CPT</option>
                                <option value="CIP">CIP</option>
                                <option value="DAP">DAP</option>
                                <option value="DPU">DPU</option>
                                <option value="DDP">DDP</option>
                                <option value="FAS">FAS</option>
                                <option value="FOB">FOB</option>
                                <option value="CFR">CFR</option>
                                <option value="CIF">CIF</option>
                            </select>
                        </div>
                    </div>
                    <table class="table table-sm mb-0">
                        <thead>
                            <tr>
                                <th>RTD</th>
                                <th>Customer Ref</th>
                                <th>Colourway</th>
                                <th>Matched</th>
                                <th>Exfty</th>
                                <th>Customer Exfty</th>
                                <th>Into W/H</th>
                                <th>Sizes</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($order['styles'] as $style)
                                @foreach($style['colourways'] as $cw)
                                    <tr>
                                        <td>RTD{{ $style['rtd'] }}</td>
                                        <td>{{ $style['customer_ref'] }}</td>
                                        <td>{{ $cw['name'] }}</td>
                                        <td>
                                            @if(!empty($style['matches']))
                                                Style OK
                                            @else
                                                <span class="text-danger">Style not matched</span>
                                            @endif
                                            <br>
                                            @if(!empty($cw['match']))
                                                Colour OK
                                            @else
                                                <span class="text-danger">Colour not matched</span>
                                            @endif
                                        </td>
                                        <td>{{ $cw['exfty'] }}</td>
                                        <td>{{ $cw['customer_exfty'] }}</td>
                                        <td>{{ $cw['into_wh'] }}</td>
                                        <td>
                                            @foreach($cw['sizes'] as $sz)
                                                <span class="badge text-bg-light">{{ $sz['size'] }}: {{ $sz['qty'] }}</span>
                                            @endforeach
                                        </td>
                                    </tr>
                                @endforeach
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endforeach
        <div class="mb-3">
            <button class="btn btn-primary" wire:click="save">Save Orders</button>
        </div>
    @endif
</div>


