<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Import AI Orders - KWT
        </x-slot:title>
        <x-slot:end>
        </x-slot:end>
    </x-title-bar>
    <div class="container-fluid">
        {{-- Alert Messages --}}
        <div class="row">
            <div class="col">
                @if(session('messages'))
                    @if(!empty(session('messages.errors')))
                        <div class="alert alert-danger">
                            <ul>
                                @foreach(session('messages.errors') as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if(!empty(session('messages.saved')))
                        <div class="alert alert-success">
                            <p>Saved Orders:</p>
                            <ul>
                                @foreach(session('messages.saved') as $saved)
                                    <li>{{ $saved }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                @endif
                @if($errors->all())
                    <div class="alert alert-dark" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        <div class="row p-3">
            <div class="col">
                <div class="input-group">
                    {{-- <select wire:model="customerInvoice" class="form-select">
                        <option value="">— choose customer —</option>

                        @foreach ($zohoCustomers as $id => $name)
                            <option value="{{ $id }}">{{ $name }}</option>
                        @endforeach
                    </select> --}}
                    <input type="file" wire:model="orderFiles" multiple class="form-control" accept=".xls, .xlsx, .pdf, .csv" id="fileUpload">
                    <button class="btn btn-primary" wire:click="uploadOrders" id="uploadButton" wire:loading.attr="disabled" @if($this->buttonDisabled()) disabled @endif>
                        <span wire:loading.remove>Upload Orders</span>
                        <span wire:loading>Processing...</span>
                    </button>
                </div>
            </div>
        </div>

        @if($this->results)
            <div class="row p-3">
                <div class="col">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th style="white-space: nowrap;">Season</th>
                                    <th style="white-space: nowrap;">Date</th>
                                    <th style="white-space: nowrap;">PO Number</th>
                                    <th style="white-space: nowrap;">Invoice Number</th>
                                    <th style="white-space: nowrap;">Customer Ref</th>
                                    <th style="white-space: nowrap;">Qty</th>
                                    <th style="white-space: nowrap;">Erdos Price</th>
                                    <th style="white-space: nowrap;">RT Price</th>
                                    <th style="white-space: nowrap;">Invoice Value</th>
                                    <th style="white-space: nowrap;">%</th>
                                    <th style="white-space: nowrap;">Commission</th>
                                    <th style="white-space: nowrap;">Drops</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($this->results as $l => $line)
                                    <tr>
                                        <td>{{ $line['season'] }}</td>
                                        <td>{{ $line['date']->format('d/m/y') }}</td>
                                        <td>{{ $line['po_number'] }}</td>
                                        <td>{{ $line['invoice_no'] }}</td>
                                        <td>{{ $line['product_id'] }}</td>
                                        <td>{{ $line['quantity'] }}</td>
                                        <td>{{ number_format($line['unit_price'] ?? 0, 2) }}</td>
                                        <td class="@if(($line['rt_price'] ?? 0) != ($line['unit_price'] ?? 0)) bg-red @endif">{{ number_format($line['rt_price'] ?? 0, 2) }}</td>
                                        <td>{{ number_format($line['total_value'] ?? 0, 2) }}</td>
                                        <td>{{ number_format($line['commission_percent'] ?? 0, 2) }}</td>
                                        <td>{{ number_format($line['commission'] ?? 0, 2) }}</td>
                                        <td>
                                            @if($line['match'])
                                                <table class="table">
                                                    <thead>
                                                        <th>Drop</th>
                                                        <th>Qty</th>
                                                        <th style="width:100px">RT Invoice</th>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($line['match'] as $d=>$drop)
                                                            <tr>
                                                                <td>{{$drop->id}}</td>
                                                                <td>{{$drop->shipment_line_sizes_sum_shipped_qty}}</td>
                                                                <td>
                                                                    <input class="form-control" type="text"  wire:key="rtinvoice-{{$drop->id}}" wire:model.live.debounce="rtinvoice.{{$drop->id}}">
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            @else
                                                No Drops Matched.
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

            </div>

            <div class="row" wire:loading.remove>
                <div class="col text-end">
                    <button class="btn btn-primary mt-3" wire:click="createInvoices">Create Invoices?</button>
                </div>
            </div>
        @endif
        <div wire:loading>
            <div class="row">
                <div class="col">
                    <img class="rounded mx-auto d-block" src="loading-ai.gif">
                </div>
            </div>
        </div>
    </div>

    @script
    <script>
        document.addEventListener('livewire:load', function () {
            const fileInput = document.getElementById("fileUpload");

            fileInput.addEventListener("change", function () {
                const fileCount = fileInput.files.length;

                if (fileCount > 10) {
                    alert("You are only allowed to upload a maximum of 10 files.");
                    $wire.dispatch('toggleuploadbutton', true);
                } else {
                    $wire.dispatch('toggleuploadbutton', false);
                }
            });
        });
    </script>
    @endscript
</div>
