<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Erdos Import AI
        </x-slot:title>
        <x-slot:end>
        </x-slot:end>
    </x-title-bar>
    <div class="container-fluid">
        {{-- Alert Messages --}}
        <div class="row">
            <div class="col">
                @if(session('messages'))
                    @if(!empty(session('messages.errors')))
                        <div class="alert alert-danger">
                            <ul>
                                @foreach(session('messages.errors') as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if(!empty(session('messages.saved')))
                        <div class="alert alert-success">
                            <p>Saved Orders:</p>
                            <ul>
                                @foreach(session('messages.saved') as $saved)
                                    <li>{{ $saved }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                @endif
                @if($errors->all())
                    <div class="alert alert-dark" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        @if (!$zohoConnected)
            <button wire:click="initiateZohoOAuth" class="btn btn-primary">Connect to Zoho</button>
        @else
            <div class="row mt-3">
                <div class="col">
                    <div class="input-group">
                        <input type="file" wire:model="orderFiles" multiple class="form-control" accept=".xls, .xlsx, .pdf, .csv" id="fileUpload">
                        <button class="btn btn-primary" wire:click="uploadOrders" id="uploadButton" wire:loading.attr="disabled" @if($this->buttonDisabled()) disabled @endif>
                            <span wire:loading.remove>Upload Orders</span>
                            <span wire:loading>Processing...</span>
                        </button>
                    </div>
                </div>
            </div>
            @if($this->invoices)
                <div class="row mt-3">
                    <div class="col">
                        <div class="form-floating mb-3">
                            <select class="form-select" id="org" wire:model.live="org">
                                <option value="">Select...</option>
                                @foreach ($this->organisations() as $org)
                                <option value="{{ $org['organization_id'] }}">{{ $org['name'] }}</option>
                                @endforeach
                            </select>
                            <label for="org">Organisation</label>
                        </div>
                        <div class="form-floating mb-3">
                            <select class="form-select" id="cust" wire:model="cust">
                                <option value="">Select...</option>
                                @foreach ($this->customers() as $customer)
                                    <option value="{{ $customer['contact_id'] }}">{{ $customer['customer_name'] }}</option>
                                @endforeach
                            </select>
                            <label for="cust">Customer</label>
                        </div>
                        <div class="form-floating mb-3">
                            <select class="form-select" id="rtag-Cust" wire:model="reportingTagCustomer">
                                <option value="">Select...</option>
                                @foreach ($this->reportingTagCustomers() as $customer)
                                    <option value="{{ $customer['tag_option_id'] }}">{{ $customer['tag_option_name'] }}</option>
                                @endforeach
                            </select>
                            <label for="rtag-Cust">Reporting Tag - Customer</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="text" class="form-control" wire:model="reportingTagCommissionsCustomer">
                            <label for="vat">Customer Name</label>
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-floating mb-3">
                            <select class="form-select" id="department" wire:model="reportingTagDepartment">
                                <option value="">Select...</option>
                                @foreach ($this->reportingTagDepartments() as $department)
                                    <option value="{{ $department['tag_option_id'] }}">{{ $department['tag_option_name'] }}</option>
                                @endforeach
                            </select>
                            <label for="department">Reporting Tag - Department</label>
                        </div>
                        <div class="form-floating mb-3">
                            <select class="form-select" id="template" wire:model="template">
                                <option value="">Select...</option>
                                @foreach ($this->templates() as $template)
                                    <option value="{{ $template['template_id'] }}">{{ $template['template_name'] }}</option>
                                @endforeach
                            </select>
                            <label for="template">Template</label>
                        </div>
                        <div class="form-floating mb-3">
                            <select class="form-select" id="account" wire:model="account">
                                <option value="">Select...</option>
                                @foreach ($this->accounts() as $account)
                                    <option value="{{ $account['account_id'] }}">{{ $account['account_code'] }} - {{ $account['account_name'] }}</option>
                                @endforeach
                            </select>
                            <label for="account">Account</label>
                        </div>
                    </div>
                </div>
                <div class="row p-3" wire:loading.remove>
                    <div class="col">
                        <div x-data="{ clip:'' }"
                            @copy.window="if ($event.target.type==='date') clip=$event.target.value"
                            @paste.window="if ($event.target.type==='date' && clip) {
                                    $event.preventDefault(); $event.target.value=clip;
                                    $event.target.dispatchEvent(new Event('input',{bubbles:true}));
                            }">
                                <table class="table">
                                <thead>
                                    <tr>
                                        <th style="white-space: nowrap;">Season</th>
                                        <th style="white-space: nowrap;">Date</th>
                                        <th style="white-space: nowrap;">PO Number</th>
                                        <th style="white-space: nowrap;">Invoice Number</th>
                                        <th style="white-space: nowrap;">Customer Ref</th>
                                        <th style="white-space: nowrap;">Colour</th>
                                        <th style="white-space: nowrap;">Qty</th>
                                        <th style="white-space: nowrap;">Erdos Price</th>
                                        <th style="white-space: nowrap;">RT Price</th>
                                        <th style="white-space: nowrap;">Invoice Value</th>
                                        <th style="white-space: nowrap;">%</th>
                                        <th style="white-space: nowrap;">Commission</th>
                                        <th style="white-space: nowrap;">Drops</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($this->invoices as $i => $invoice)
                                        @foreach($invoice['lines'] as $l => $line)
                                            <tr>
                                                <td>{{ $invoice['season'] }}</td>
                                                <td>{{ $invoice['date']->format('d/m/y') }}</td>
                                                <td>{{ $invoice['po_number'] }}</td>
                                                <td>{{ $invoice['invoice_no'] }}</td>
                                                <td>{{ $line['product_id'] }}</td>
                                                <td>
                                                    @php $hasColour = !empty($line['colour'] ?? ''); @endphp
                                                    <span class="badge @if(!$hasColour) bg-warning text-dark @else bg-secondary @endif">
                                                        {{ $line['colour'] ?? 'Unresolved' }}
                                                    </span>
                                                </td>
                                                <td>{{ $line['quantity'] }}</td>
                                                <td>{{ number_format($line['unit_price'] ?? 0, 2) }}</td>
                                                <td class="@if(($line['rt_price'] ?? 0) != ($line['unit_price'] ?? 0)) bg-red @endif">{{ number_format($line['rt_price'] ?? 0, 2) }}</td>
                                                <td>{{ number_format($line['line_total'] ?? 0, 2) }}</td>
                                                <td>{{ number_format($line['commission_percent'] ?? 0, 2) }}</td>
                                                <td>{{ $line['commission'] ?? 0 }}</td>
                                                <td>
                                                    @if(!empty($line['match']))
                                                        <table class="table">
                                                            <thead>
                                                                <th>Drop</th>
                                                                <th>Qty</th>
                                                                <th style="width:100px">RT Invoice</th>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($line['match'] as $d=>$drop)
                                                                    <tr>
                                                                        <td>{{ $drop['model']->id ?? '' }}</td>
                                                                        <td>{{ (int)($drop['alloc'] ?? $drop['qty'] ?? 0) }}</td>
                                                                        <td>{{ $rtinvoice[$drop['model']->id ?? null] ?? ($drop['model']->rt_invoice ?? '') }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    @else
                                                        <div>
                                                            No Drops Matched.
                                                            @if(!empty($line['colour'] ?? ''))
                                                                <span class="badge bg-warning text-dark">Check colour match</span>
                                                            @endif
                                                            <div class="mt-2">
                                                                <small>Assign drop(s) — qty shows remaining on this page:</small>
                                                                <select multiple class="form-select form-select-sm" style="min-width: 220px;"
                                                                    wire:model.live="manualSelections.{{ $i }}.{{ $l }}"
                                                                    wire:input="recomputeUiRemaining({{ $i }})"
                                                                    wire:change="recomputeUiRemaining({{ $i }})">
                                                                    @php $uiRem = $invoice['ui_remaining'] ?? []; @endphp
                                                                    @foreach(($invoice['all_candidates'][$l] ?? []) as $cand)
                                                                        @php
                                                                            $id = (int) ($cand['id'] ?? 0);
                                                                            $shipped = (int) ($cand['shipped'] ?? 0);
                                                                            $already = (int) ($cand['no_invoiced'] ?? 0);
                                                                            $fallback = max(0, $shipped - $already);
                                                                            $rem = (int) ($uiRem[$id] ?? $fallback);
                                                                        @endphp
                                                                        @if($id)
                                                                            <option value="{{ $id }}" @if($rem <= 0) disabled @endif>
                                                                                #{{ $id }} — {{ $cand['colour'] ?? '' }} ({{ $rem }})
                                                                                @php $rinv = $rtinvoice[$id] ?? null; @endphp
                                                                                @if($rinv) — {{ $rinv }} @endif
                                                                            </option>
                                                                        @endif
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                            </div>
                        </div>

                </div>
                <div class="row" wire:loading.remove>
                    <div class="col text-end">
                        <button class="btn btn-primary mt-3" wire:click="createInvoices">Create Invoices</button>
                    </div>
                </div>
            @endif
            <div wire:loading>
                <div class="row">
                    <div class="col">
                        <img class="rounded mx-auto d-block" src="loading-ai.gif">
                    </div>
                </div>
            </div>
        @endif

    </div>

    @script
    <script>
        document.addEventListener('livewire:load', function () {
            const fileInput = document.getElementById("fileUpload");

            fileInput.addEventListener("change", function () {
                const fileCount = fileInput.files.length;

                if (fileCount > 10) {
                    alert("You are only allowed to upload a maximum of 10 files.");
                    $wire.dispatch('toggleuploadbutton', true);
                } else {
                    $wire.dispatch('toggleuploadbutton', false);
                }
            });
        });
    </script>
    @endscript
    <script>
        document.addEventListener('livewire:load', () => {
            let dateClipboard = '';

            // Remove any previous delegated handlers (defensive)
            document.removeEventListener('copy', handleCopy, true);
            document.removeEventListener('paste', handlePaste, true);

            // Attach once, in the capture phase, so it fires before Livewire’s own listeners.
            document.addEventListener('copy',  handleCopy,  true);
            document.addEventListener('paste', handlePaste, true);

            function handleCopy(e) {
                if (e.target.matches('input[type="date"]')) {
                    dateClipboard = e.target.value;          // store the copied date
                    // optional: toast or console.log
                }
            }

            function handlePaste(e) {
                if (e.target.matches('input[type="date"]') && dateClipboard) {
                    e.preventDefault();                      // stop the browser’s default paste
                    e.target.value = dateClipboard;          // set the value
                    // Tell Livewire the input changed:
                    e.target.dispatchEvent(new Event('input', { bubbles: true }));
                }
            }
        });
    </script>
    <script>
        window.addEventListener('open-zoho-oauth-popup', event => {
            const popup = window.open(event.detail.url, 'Zoho OAuth', 'width=600,height=600');

            // Periodically check if the popup is closed
            const checkPopupClosed = setInterval(() => {
                if (popup.closed) {
                    clearInterval(checkPopupClosed); // Stop checking
                    console.log('Popup closed');
                    reload();
                    // You can trigger any event or logic here
                    // window.dispatchEvent(new CustomEvent('zoho-oauth-popup-closed')); // Custom event to handle closure
                }
            }, 500); // Check every 500 milliseconds
        });

        // Listen for the custom event when the popup is closed
        window.addEventListener('zoho-oauth-popup-closed', () => {
            console.log('OAuth process completed or window closed.');
            // Handle any logic you need here
        });
    </script>
</div>
