<div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Commission Packing List Import</h3>
                </div>
                <div class="card-body">
                    
                    {{-- Session Messages --}}
                    @if(session()->has('message'))
                        <div class="alert {{ session('alert-class', 'alert-info') }}">
                            {{ session('message') }}
                        </div>
                    @endif

                    {{-- Customer Selection --}}
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="customer" class="form-label">Customer <span class="text-danger">*</span></label>
                            <select wire:model.live="selectedCustomer" class="form-control" id="customer">
                                <option value="">Select Customer</option>
                                @foreach($this->availableCustomers as $key => $name)
                                    <option value="{{ $key }}">{{ $name }}</option>
                                @endforeach
                            </select>
                            @error('selectedCustomer') <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                        
                        <div class="col-md-4">
                            <label for="season" class="form-label">Season (Optional)</label>
                            <select wire:model.live="selectedSeason" class="form-control" id="season">
                                <option value="">All Seasons</option>
                                @foreach($this->seasons as $season)
                                    <option value="{{ $season->id }}">{{ $season->description }}</option>
                                @endforeach
                            </select>
                            @error('selectedSeason') <div class="text-danger">{{ $message }}</div> @enderror
                            <small class="text-muted">Filter packing lists by season (optional)</small>
                        </div>
                    </div>

                    {{-- File Upload --}}
                    @if(!empty($selectedCustomer))
                        <div class="row mb-3">
                            <div class="col-12">
                                <label for="files" class="form-label">Upload Packing Lists <span class="text-danger">*</span></label>
                                <input type="file" 
                                       wire:model="packingListFiles" 
                                       multiple 
                                       accept=".pdf,.xlsx,.xls"
                                       class="form-control" 
                                       id="files"
                                       @if($isProcessing) disabled @endif>
                                @error('packingListFiles') <div class="text-danger">{{ $message }}</div> @enderror
                                @error('packingListFiles.*') <div class="text-danger">{{ $message }}</div> @enderror
                                <small class="text-muted">Supported formats: PDF, Excel (.xlsx, .xls). Max 10MB per file.</small>
                                
                                <div class="form-check mt-3">
                                    <input class="form-check-input" type="checkbox" wire:model="includeCompletedLines" id="includeCompletedLines">
                                    <label class="form-check-label" for="includeCompletedLines">
                                        <strong>Include already completed lines (for invoice generation only)</strong>
                                    </label>
                                    <small class="text-muted d-block">
                                        Check this to match packing lists to lines that have already been marked as shipped/complete manually. 
                                        Useful for generating invoices from existing completed shipments. Will not match to already invoiced lines.
                                    </small>
                                </div>
                                
                                @if(!empty($packingListFiles))
                                    <div class="mt-2">
                                        <strong>Selected Files:</strong>
                                        <ul class="list-unstyled">
                                            @foreach($packingListFiles as $file)
                                                <li class="text-success">
                                                    <i class="fas fa-file"></i> {{ $file->getClientOriginalName() }}
                                                    <small class="text-muted">({{ number_format($file->getSize() / 1024, 1) }} KB)</small>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>

                        {{-- Action Buttons --}}
                        <div class="row mb-3">
                            <div class="col-12">
                                <button type="button" 
                                        wire:click="processFiles" 
                                        class="btn btn-primary"
                                        @if($isProcessing || empty($packingListFiles)) disabled @endif>
                                    @if($isProcessing)
                                        <i class="fas fa-spinner fa-spin"></i> Processing...
                                    @else
                                        <i class="fas fa-cogs"></i> Process Files
                                    @endif
                                </button>
                                
                                <button type="button" 
                                        wire:click="resetForm" 
                                        class="btn btn-secondary ms-2"
                                        @if($isProcessing) disabled @endif>
                                    <i class="fas fa-redo"></i> Reset
                                </button>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Please select a customer to continue.
                        </div>
                    @endif

                    {{-- Processing Status --}}
                    @if($isProcessing)
                        <div class="alert alert-info">
                            <i class="fas fa-spinner fa-spin"></i> Processing files, please wait...
                        </div>
                    @endif

                    {{-- Validation Errors --}}
                    @if(!empty($validationErrors))
                        <div class="alert alert-danger">
                            <h5><i class="fas fa-exclamation-triangle"></i> Validation Errors</h5>
                            <ul class="mb-0">
                                @foreach($validationErrors as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{-- Data Preview --}}
                    @if($showPreview && !empty($extractedData))
                        <div class="card mt-4">
                            <div class="card-header bg-success text-white">
                                <h4 class="card-title mb-0">
                                    <i class="fas fa-eye"></i> Packing List Preview
                                </h4>
                            </div>
                            <div class="card-body">
                                
                                {{-- Summary Stats --}}
                                <div class="row mb-3">
                                    <div class="col-md-3">
                                        <div class="card border-primary">
                                            <div class="card-body text-center p-3">
                                                <h5 class="card-title text-primary mb-1">{{ $extractedData['metadata']['files_processed'] ?? 0 }}</h5>
                                                <p class="card-text small mb-0">Files</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-success">
                                            <div class="card-body text-center p-3">
                                                <h5 class="card-title text-success mb-1">{{ count($extractedData['packing_lists'] ?? []) }}</h5>
                                                <p class="card-text small mb-0">Packing Lists</p>
                                            </div>
                                        </div>
                                    </div>
                                    @if(!empty($extractedData['metadata']['invoice_data']['invoice_no']) || !empty($extractedData['metadata']['invoice_data']['invoice_number']))
                                        <div class="col-md-6">
                                            <div class="card border-info">
                                                <div class="card-body text-center p-3">
                                                    <h5 class="card-title text-info mb-1">{{ $extractedData['metadata']['invoice_data']['invoice_no'] ?? $extractedData['metadata']['invoice_data']['invoice_number'] }}</h5>
                                                    <p class="card-text small mb-0">Factory Invoice</p>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>

                                {{-- Multi-file Information --}}
                                @if(!empty($extractedData['metadata']['filenames']) && count($extractedData['metadata']['filenames']) > 1)
                                    <div class="alert alert-info">
                                        <strong>Multiple Files Processed:</strong>
                                        <ul class="mb-0 mt-2">
                                            @foreach($extractedData['metadata']['filenames'] as $filename)
                                                <li>{{ $filename }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                {{-- Preview Table --}}
                                <div class="table-responsive">
                                    <table class="table table-striped table-sm">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>Status</th>
                                                <th>Style</th>
                                                <th>Color</th>
                                                <th>Order Line</th>
                                                <th>Total Qty</th>
                                                <th>Invoice Price</th>
                                                <th>Loop Price</th>
                                                <th>Cartons</th>
                                                <th>Size Breakdown</th>
                                                <th>Ex-Factory</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($this->getPreviewData() as $item)
                                                <tr class="{{ in_array($item['match_status'], ['style_matched_select_color', 'multiple_matches']) ? 'table-warning' : '' }}" 
                                                    wire:key="pl-row-{{ $item['index'] }}">
                                                    <td>{!! $item['status_badge'] !!}</td>
                                                    <td><strong>{{ $item['style'] }}</strong></td>
                                                    <td><strong>{{ $item['color'] }}</strong></td>
                                                    <td>
                                                        @if($item['order_line_display'])
                                                            <span class="badge bg-primary">{{ $item['order_line_display'] }}</span>
                                                        @elseif(!empty($item['possible_matches']))
                                                            <select class="form-select form-select-sm" 
                                                                    wire:model.live="selectedOrderLines.{{ $item['index'] }}"
                                                                    wire:key="select-{{ $item['index'] }}">
                                                                <option value="">
                                                                    @if($item['match_status'] === 'multiple_matches')
                                                                        Select from {{ count($item['possible_matches']) }} matches...
                                                                    @else
                                                                        Select color...
                                                                    @endif
                                                                </option>
                                                                @foreach($item['possible_matches'] as $match)
                                                                    <option value="{{ $match['shipment_line_id'] ?? $match['order_line_id'] }}">
                                                                        {{ $match['line_display'] ?? ($match['colourway_name'] . ' (Line ' . $match['order_line_id'] . ')') }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        @else
                                                            <span class="text-muted">N/A</span>
                                                        @endif
                                                    </td>
                                                    <td><span class="badge bg-info">{{ $item['total_qty'] }}</span></td>
                                                    <td class="{{ $item['price_match'] === 'match' ? 'bg-success bg-opacity-25' : '' }}">
                                                        @if($item['invoice_unit_price'])
                                                            <span class="fw-bold {{ $item['price_match'] === 'match' ? 'text-success' : '' }}">
                                                                £{{ number_format($item['invoice_unit_price'], 2) }}
                                                            </span>
                                                        @else
                                                            <span class="text-muted">N/A</span>
                                                        @endif
                                                    </td>
                                                    <td class="{{ $item['price_match'] === 'match' ? 'bg-success bg-opacity-25' : '' }}">
                                                        @if($item['system_unit_price'])
                                                            <span class="fw-bold {{ $item['price_match'] === 'match' ? 'text-success' : '' }}">
                                                                £{{ number_format($item['system_unit_price'], 2) }}
                                                            </span>
                                                            @if($item['price_match'] === 'higher')
                                                                <br><small class="badge bg-warning text-dark">
                                                                    +£{{ number_format(abs($item['price_difference']), 2) }}
                                                                </small>
                                                            @elseif($item['price_match'] === 'lower')
                                                                <br><small class="badge bg-danger">
                                                                    -£{{ number_format(abs($item['price_difference']), 2) }}
                                                                </small>
                                                            @endif
                                                        @else
                                                            <span class="text-muted">N/A</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ $item['cartons'] }}</td>
                                                    <td>
                                                        <small class="text-muted">{{ $item['size_breakdown'] }}</small>
                                                    </td>
                                                    <td><small>{{ $item['exfty'] }}</small></td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="10" class="text-center text-muted">No packing list data to preview</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                        <tfoot class="table-secondary">
                                            <tr>
                                                <th colspan="4" class="text-end">File Total:</th>
                                                <th><span class="badge bg-primary">{{ $extractedData['_file_total'] ?? 0 }}</span></th>
                                                <th colspan="5"></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                
                                {{-- Invoice Metadata --}}
                                @if(!empty($extractedData['metadata']['invoice_data']['invoice_no']) || !empty($extractedData['metadata']['invoice_data']['invoice_number']) || !empty($extractedData['metadata']['invoice_data']['po_number']) || !empty($extractedData['metadata']['invoice_data']['net_weight']) || !empty($extractedData['metadata']['invoice_data']['gross_weight']))
                                    <div class="alert alert-info mt-3">
                                        <div class="row">
                                            @if(!empty($extractedData['metadata']['invoice_data']['invoice_no']) || !empty($extractedData['metadata']['invoice_data']['invoice_number']))
                                                <div class="col-md-3">
                                                    <strong>Factory Invoice:</strong><br>
                                                    <span class="badge bg-primary">{{ $extractedData['metadata']['invoice_data']['invoice_no'] ?? $extractedData['metadata']['invoice_data']['invoice_number'] }}</span>
                                                </div>
                                            @endif
                                            @if(!empty($extractedData['metadata']['invoice_data']['po_number']))
                                                <div class="col-md-3">
                                                    <strong>PO Number:</strong><br>
                                                    <span class="badge bg-secondary">{{ $extractedData['metadata']['invoice_data']['po_number'] }}</span>
                                                </div>
                                            @endif
                                            @if(!empty($extractedData['metadata']['invoice_data']['net_weight']))
                                                <div class="col-md-3">
                                                    <strong>Net Weight:</strong><br>
                                                    {{ $extractedData['metadata']['invoice_data']['net_weight'] }} KGS
                                                </div>
                                            @endif
                                            @if(!empty($extractedData['metadata']['invoice_data']['gross_weight']))
                                                <div class="col-md-3">
                                                    <strong>Gross Weight:</strong><br>
                                                    {{ $extractedData['metadata']['invoice_data']['gross_weight'] }} KGS
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endif

                                {{-- Save/Import Buttons --}}
                                <div class="row mt-3">
                                    <div class="col-12">
                                        <button type="button" 
                                                wire:click="saveData" 
                                                class="btn btn-primary btn-lg"
                                                @if($isProcessing) disabled @endif>
                                            @if($isProcessing)
                                                <i class="fas fa-spinner fa-spin"></i> Saving...
                                            @else
                                                <i class="fas fa-save"></i> Save Only
                                            @endif
                                        </button>
                                        
                                        <button type="button" 
                                                wire:click="importData" 
                                                class="btn btn-success btn-lg ms-2"
                                                @if($isProcessing) disabled @endif>
                                            @if($isProcessing)
                                                <i class="fas fa-spinner fa-spin"></i> Saving...
                                            @else
                                                <i class="fas fa-check"></i> Save & Mark as Shipped
                                            @endif
                                        </button>
                                        <small class="text-muted d-block mt-2">
                                            <strong>Save Only:</strong> Saves shipped quantities without marking as complete (for review).<br>
                                            <strong>Save & Mark as Shipped:</strong> Saves quantities and marks lines as complete.
                                        </small>
                                    </div>
                                </div>
                                
                                {{-- Zoho Invoice Creation Section --}}
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header bg-info text-white">
                                                <h5 class="mb-0"><i class="fas fa-file-invoice"></i> Create Zoho Invoice (Optional)</h5>
                                            </div>
                                            <div class="card-body">
                                                @if($zohoConnected)
                                                    <div class="alert alert-success">
                                                        <i class="fas fa-check-circle"></i> Zoho is connected
                                                    </div>
                                                    
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label for="zohoOrg" class="form-label">Organisation <span class="text-danger">*</span></label>
                                                                <select wire:model.live="zohoOrg" 
                                                                        class="form-control" 
                                                                        id="zohoOrg"
                                                                        @if(!$this->isFinanceUser()) disabled style="background-color: #e9ecef;" @endif>
                                                                    <option value="">Select...</option>
                                                                    @foreach($this->organisations() as $org)
                                                                        <option value="{{ $org['organization_id'] }}">{{ $org['name'] }}</option>
                                                                    @endforeach
                                                                </select>
                                                                @if(!$this->isFinanceUser())
                                                                    <small class="text-muted">Finance user permission required to change</small>
                                                                @endif
                                                            </div>
                                                            
                                                            <div class="mb-3">
                                                                <label for="zohoCustomer" class="form-label">Customer <span class="text-danger">*</span></label>
                                                                <select wire:model="zohoCustomerId" class="form-control" id="zohoCustomer">
                                                                    <option value="">Select...</option>
                                                                    @foreach($this->customers() as $customer)
                                                                        <option value="{{ $customer['contact_id'] ?? $customer['customer_id'] ?? '' }}">
                                                                            {{ $customer['customer_name'] ?? $customer['contact_name'] ?? 'Unknown' }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            
                                                            <div class="mb-3">
                                                                <label for="reportingTagCustomer" class="form-label">Reporting Tag - Customer <span class="text-danger">*</span></label>
                                                                <select wire:model="reportingTagCustomer" class="form-control" id="reportingTagCustomer">
                                                                    <option value="">Select...</option>
                                                                    @foreach($this->reportingTagCustomers() as $customer)
                                                                        <option value="{{ $customer['tag_option_id'] }}">{{ $customer['tag_option_name'] }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            
                                                            <div class="mb-3">
                                                                <label for="reportingTagCommissionsCustomer" class="form-label">Customer Name</label>
                                                                <input type="text" 
                                                                       value="{{ $this->getLoopCustomerName() }}" 
                                                                       class="form-control" 
                                                                       id="reportingTagCommissionsCustomer"
                                                                       readonly
                                                                       style="background-color: #e9ecef;">
                                                                <small class="text-muted">Automatically populated from Loop</small>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label for="reportingTagDepartment" class="form-label">Reporting Tag - Department <span class="text-danger">*</span></label>
                                                                <select wire:model="reportingTagDepartment" 
                                                                        class="form-control" 
                                                                        id="reportingTagDepartment"
                                                                        @if(!$this->isFinanceUser()) disabled style="background-color: #e9ecef;" @endif>
                                                                    <option value="">Select...</option>
                                                                    @foreach($this->reportingTagDepartments() as $department)
                                                                        <option value="{{ $department['tag_option_id'] }}">{{ $department['tag_option_name'] }}</option>
                                                                    @endforeach
                                                                </select>
                                                                @if(!$this->isFinanceUser())
                                                                    <small class="text-muted">Finance user permission required to change</small>
                                                                @endif
                                                            </div>
                                                            
                                                            <div class="mb-3">
                                                                <label for="zohoTemplate" class="form-label">Template <span class="text-danger">*</span></label>
                                                                <select wire:model="zohoTemplate" 
                                                                        class="form-control" 
                                                                        id="zohoTemplate"
                                                                        @if(!$this->isFinanceUser()) disabled style="background-color: #e9ecef;" @endif>
                                                                    <option value="">Select...</option>
                                                                    @foreach($this->templates() as $template)
                                                                        <option value="{{ $template['template_id'] }}">{{ $template['template_name'] }}</option>
                                                                    @endforeach
                                                                </select>
                                                                @if(!$this->isFinanceUser())
                                                                    <small class="text-muted">Finance user permission required to change</small>
                                                                @endif
                                                            </div>
                                                            
                                                            <div class="mb-3">
                                                                <label for="zohoAccount" class="form-label">Account <span class="text-danger">*</span></label>
                                                                <select wire:model="zohoAccount" 
                                                                        class="form-control" 
                                                                        id="zohoAccount"
                                                                        @if(!$this->isFinanceUser()) disabled style="background-color: #e9ecef;" @endif>
                                                                    <option value="">Select...</option>
                                                                    @foreach($this->accounts() as $account)
                                                                        <option value="{{ $account['account_id'] }}">{{ $account['account_code'] }} - {{ $account['account_name'] }}</option>
                                                                    @endforeach
                                                                </select>
                                                                @if(!$this->isFinanceUser())
                                                                    <small class="text-muted">Finance user permission required to change</small>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <button type="button" 
                                                            wire:click="createZohoInvoice" 
                                                            class="btn btn-primary"
                                                            @if(empty($zohoCustomerId) || $isProcessing) disabled @endif>
                                                        <i class="fas fa-file-invoice-dollar"></i> Create Draft Invoice
                                                    </button>
                                                    <small class="text-muted d-block mt-2">
                                                        Creates a draft invoice in Zoho and sends notification to neil@roberttodds.com
                                                    </small>
                                                @else
                                                    <div class="alert alert-warning">
                                                        <i class="fas fa-exclamation-triangle"></i> Zoho is not connected
                                                    </div>
                                                    <button class="btn btn-primary" wire:click="initiateZohoOAuth">
                                                        <i class="fas fa-link"></i> Connect Zoho
                                                    </button>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    {{-- Import Results --}}
                    @if(!empty($importResults))
                        <div class="card mt-4">
                            <div class="card-header {{ $importResults['success'] ? 'bg-success' : 'bg-danger' }} text-white">
                                <h4 class="card-title mb-0">
                                    <i class="fas {{ $importResults['success'] ? 'fa-check-circle' : 'fa-times-circle' }}"></i>
                                    Import Results
                                </h4>
                            </div>
                            <div class="card-body">
                                @if($importResults['success'])
                                    <div class="alert alert-success">
                                        <h5>Import Completed Successfully!</h5>
                                        <ul class="mb-0">
                                            <li>Shipment Lines Updated: <strong>{{ $importResults['shipment_lines_updated'] }}</strong></li>
                                        </ul>
                                    </div>
                                @else
                                    <div class="alert alert-danger">
                                        <h5>Import Failed</h5>
                                        <ul class="mb-0">
                                            @foreach($importResults['errors'] as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>

    {{-- Loading Overlay --}}
    @if($isProcessing)
        <div class="position-fixed top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" 
             style="background: rgba(0,0,0,0.5); z-index: 9999;">
            <div class="bg-white p-4 rounded shadow">
                <div class="text-center">
                    <i class="fas fa-spinner fa-spin fa-3x text-primary mb-3"></i>
                    <h5>Processing...</h5>
                    <p class="text-muted">Please wait while we process your packing lists</p>
                </div>
            </div>
        </div>
    @endif
</div>

<script>
    // Auto-scroll to preview when it appears
    document.addEventListener('livewire:updated', () => {
        if (document.querySelector('.card .bg-success')) {
            document.querySelector('.card .bg-success').scrollIntoView({ 
                behavior: 'smooth', 
                block: 'start' 
            });
        }
    });

    // Handle Zoho OAuth popup
    Livewire.on('open-zoho-oauth-popup', (event) => {
        const width = 600;
        const height = 700;
        const left = (screen.width / 2) - (width / 2);
        const top = (screen.height / 2) - (height / 2);
        
        const popup = window.open(
            event.url,
            'ZohoOAuth',
            `width=${width},height=${height},top=${top},left=${left},scrollbars=yes`
        );

        // Poll for popup close
        const checkPopup = setInterval(() => {
            if (popup.closed) {
                clearInterval(checkPopup);
                // Refresh the component to check connection status
                Livewire.dispatch('$refresh');
            }
        }, 500);
    });
</script>
