<div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Commission Order Import</h3>
                </div>
                <div class="card-body">
                    
                    {{-- Session Messages --}}
                    @if(session()->has('message'))
                        <div class="alert {{ session('alert-class', 'alert-info') }}">
                            {{ session('message') }}
                        </div>
                    @endif

                    {{-- Customer and Season Selection --}}
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="customer" class="form-label">Customer <span class="text-danger">*</span></label>
                            <select wire:model.live="selectedCustomer" class="form-control" id="customer">
                                <option value="">Select Customer</option>
                                @foreach($this->availableCustomers as $key => $name)
                                    <option value="{{ $key }}">{{ $name }}</option>
                                @endforeach
                            </select>
                            @error('selectedCustomer') <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                        
                        <div class="col-md-4">
                            <label for="season" class="form-label">Season</label>
                            <select wire:model.live="selectedSeason" class="form-control" id="season">
                                <option value="">Auto-detect from files</option>
                                @foreach($this->seasons as $season)
                                    <option value="{{ $season->id }}">{{ $season->description }}</option>
                                @endforeach
                            </select>
                            @error('selectedSeason') <div class="text-danger">{{ $message }}</div> @enderror
                            @if(!empty($selectedSeason))
                                @if(!empty($extractedData['metadata']['detected_season']))
                                    <small class="text-success">Auto-detected: {{ $extractedData['metadata']['detected_season'] }}</small>
                                @else
                                    <small class="text-info">Season manually selected</small>
                                @endif
                            @else
                                <small class="text-muted">Will auto-detect from document content</small>
                            @endif
                        </div>
                    </div>

                    {{-- File Upload --}}
                    @if(!empty($selectedCustomer))
                        <div class="row mb-3">
                            <div class="col-12">
                                <label for="files" class="form-label">Upload Files <span class="text-danger">*</span></label>
                                <input type="file" 
                                       wire:model="orderFiles" 
                                       multiple 
                                       accept=".pdf,.xlsx,.xls"
                                       class="form-control" 
                                       id="files"
                                       @if($isProcessing) disabled @endif>
                                @error('orderFiles') <div class="text-danger">{{ $message }}</div> @enderror
                                @error('orderFiles.*') <div class="text-danger">{{ $message }}</div> @enderror
                                <small class="text-muted">Supported formats: PDF, Excel (.xlsx, .xls). Max 10MB per file.</small>
                                
                                @if(!empty($orderFiles))
                                    <div class="mt-2">
                                        <strong>Selected Files:</strong>
                                        <ul class="list-unstyled">
                                            @foreach($orderFiles as $file)
                                                <li class="text-success">
                                                    <i class="fas fa-file"></i> {{ $file->getClientOriginalName() }}
                                                    <small class="text-muted">({{ number_format($file->getSize() / 1024, 1) }} KB)</small>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>

                        {{-- Action Buttons --}}
                        <div class="row mb-3">
                            <div class="col-12">
                                <button type="button" 
                                        wire:click="processFiles" 
                                        class="btn btn-primary"
                                        @if($isProcessing || empty($orderFiles)) disabled @endif>
                                    @if($isProcessing)
                                        <i class="fas fa-spinner fa-spin"></i> Processing...
                                    @else
                                        <i class="fas fa-cogs"></i> Process Files
                                    @endif
                                </button>
                                
                                <button type="button" 
                                        wire:click="resetForm" 
                                        class="btn btn-secondary ms-2"
                                        @if($isProcessing) disabled @endif>
                                    <i class="fas fa-redo"></i> Reset
                                </button>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Please select a customer to continue.
                        </div>
                    @endif

                    {{-- Processing Status --}}
                    @if($isProcessing)
                        <div class="alert alert-info">
                            <i class="fas fa-spinner fa-spin"></i> Processing files, please wait...
                        </div>
                    @endif

                    {{-- Validation Errors --}}
                    @if(!empty($validationErrors))
                        <div class="alert alert-danger">
                            <h5><i class="fas fa-exclamation-triangle"></i> Validation Errors</h5>
                            <ul class="mb-0">
                                @foreach($validationErrors as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{-- Duplicate PO Resolution --}}
                    @if(!empty($duplicateOrders) && $showPreview)
                        <div class="alert alert-warning">
                            <h5><i class="fas fa-exclamation-circle"></i> Duplicate Purchase Orders Detected</h5>
                            <p class="mb-2">Choose how to handle each duplicate PO:</p>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>PO Number</th>
                                            <th>Existing Order ID</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($duplicateOrders as $po => $info)
                                            <tr>
                                                <td><code>{{ $po }}</code></td>
                                                <td>{{ $info['existing_order_id'] }}</td>
                                                <td>
                                                    <select class="form-select form-select-sm" wire:model.live="duplicateResolution.{{ $po }}.action">
                                                        <option value="cancel">Cancel Import</option>
                                                        <option value="add">Add Lines to Existing</option>
                                                        <option value="overwrite">Overwrite Existing</option>
                                                    </select>
                                                    <input type="hidden" wire:model="duplicateResolution.{{ $po }}.existing_order_id" value="{{ $info['existing_order_id'] }}">
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif

                    {{-- Data Preview --}}
                    @if($showPreview && !empty($extractedData))
                        <div class="card mt-4">
                            <div class="card-header bg-success text-white">
                                <h4 class="card-title mb-0">
                                    <i class="fas fa-eye"></i> Data Preview
                                </h4>
                            </div>
                            <div class="card-body">
                                
                                {{-- Summary Stats --}}
                                <div class="row mb-3">
                                    <div class="col-md-2">
                                        <div class="card border-primary">
                                            <div class="card-body text-center p-3">
                                                <h5 class="card-title text-primary mb-1">{{ $extractedData['metadata']['files_processed'] ?? 0 }}</h5>
                                                <p class="card-text small mb-0">Files</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="card border-success">
                                            <div class="card-body text-center p-3">
                                                <h5 class="card-title text-success mb-1">{{ count($extractedData['orders'] ?? []) }}</h5>
                                                <p class="card-text small mb-0">Orders</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="card border-info">
                                            <div class="card-body text-center p-3">
                                                <h5 class="card-title text-info mb-1">{{ array_sum(array_map(fn($o) => count($o['lines'] ?? []), $extractedData['orders'] ?? [])) }}</h5>
                                                <p class="card-text small mb-0">Total Lines</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-secondary">
                                            <div class="card-body p-3">
                                                <h6 class="card-title mb-1">Detected Season</h6>
                                                <p class="card-text mb-0">
                                                    @if(!empty($extractedData['metadata']['season_conflict']))
                                                        <span class="badge bg-warning text-dark">Conflict: {{ implode(', ', $extractedData['metadata']['all_detected_seasons'] ?? []) }}</span>
                                                    @else
                                                        <span class="badge bg-secondary">{{ $extractedData['metadata']['detected_season'] ?? 'None' }}</span>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="card border-secondary">
                                            <div class="card-body p-3">
                                                <h6 class="card-title mb-1">Selected Season</h6>
                                                <p class="card-text mb-0">
                                                    @if(!empty($selectedSeason))
                                                        <span class="badge bg-primary">{{ $this->seasons->find($selectedSeason)?->description ?? 'Unknown' }}</span>
                                                    @else
                                                        <span class="badge bg-warning text-dark">Not selected</span>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Multi-file Information --}}
                                @if(!empty($extractedData['metadata']['filenames']) && count($extractedData['metadata']['filenames']) > 1)
                                    <div class="alert alert-info">
                                        <strong>Multiple Files Processed:</strong>
                                        <ul class="mb-0 mt-2">
                                            @foreach($extractedData['metadata']['filenames'] as $filename)
                                                <li>{{ $filename }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                {{-- Total Validation Warning --}}
                                @if(!empty($extractedData['metadata']['total_warning']))
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle"></i> <strong>Quantity Mismatch Detected</strong>
                                        <p class="mb-0 mt-2">{{ $extractedData['metadata']['total_warning'] }}</p>
                                        <small class="d-block mt-2">
                                            <strong>Gemini Extracted:</strong> {{ $extractedData['metadata']['gemini_total'] ?? 'N/A' }} units<br>
                                            <strong>File Shows:</strong> {{ $extractedData['metadata']['traditional_total'] ?? 'N/A' }} units
                                        </small>
                                    </div>
                                @endif

                                {{-- Preview Table --}}
                                <div class="table-responsive">
                                    <table class="table table-striped table-sm">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>PO Number</th>
                                                <th>Order Date</th>
                                                <th>Style Number</th>
                                                <th>Colour</th>
                                                <th>Ex-Factory Date</th>
                                                <th>Total Qty</th>
                                                <th>Size / Qty / Price</th>
                                                <th style="width: 120px;">Set All Prices</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($this->getPreviewData() as $item)
                                                <tr>
                                                    <td><strong>{{ $item['purchase_order'] }}</strong></td>
                                                    <td>{{ $item['order_date'] }}</td>
                                                    <td><strong>{{ $item['style_number'] }}</strong></td>
                                                    <td>{{ $item['colour_name'] }}</td>
                                                    <td>{{ $item['customer_exfty_date'] }}</td>
                                                    <td><span class="badge bg-primary">{{ $item['total_qty'] }}</span></td>
                                                    <td style="width: 220px;">
                                                        <div class="d-flex flex-column gap-2">
                                                            @foreach($item['quantities'] as $sizeIndex => $qty)
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <span class="badge bg-secondary" style="font-size: 0.8rem; width: 45px; text-align: center;">{{ $qty['size'] }}</span>
                                                                    <span class="badge bg-info" style="font-size: 0.8rem; width: 35px; text-align: center;">{{ $qty['qty'] }}</span>
                                                                    <div class="input-group input-group-sm" style="width: 100px;">
                                                                        <span class="input-group-text" style="font-size: 0.85rem;">{{ $this->getCurrencySymbol() }}</span>
                                                                        <input 
                                                                            type="number" 
                                                                            step="0.01" 
                                                                            min="0"
                                                                            class="form-control form-control-sm" 
                                                                            style="font-size: 0.85rem;"
                                                                            value="{{ $priceOverrides[$item['order_index']][$item['line_index']][$sizeIndex] ?? $qty['price'] }}"
                                                                            wire:change="updatePrice({{ $item['order_index'] }}, {{ $item['line_index'] }}, {{ $sizeIndex }}, $event.target.value)"
                                                                            placeholder="0.00">
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="input-group input-group-sm">
                                                            <span class="input-group-text" style="font-size: 0.85rem;">{{ $this->getCurrencySymbol() }}</span>
                                                            <input 
                                                                type="number" 
                                                                step="0.01" 
                                                                min="0"
                                                                class="form-control form-control-sm" 
                                                                style="font-size: 0.85rem;"
                                                                placeholder="All sizes"
                                                                wire:change="updateLinePrice({{ $item['order_index'] }}, {{ $item['line_index'] }}, $event.target.value)"
                                                                title="Set same price for all sizes">
                                                        </div>
                                                        <small class="text-muted d-block mt-1" style="font-size: 0.75rem;">Avg: {{ $this->getCurrencySymbol() }}{{ $item['avg_price'] }}</small>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="8" class="text-center text-muted">No data to preview</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                        @if(!empty($this->getPreviewData()))
                                        <tfoot>
                                            <tr class="table-secondary fw-bold">
                                                <td colspan="5" class="text-end">GRAND TOTAL:</td>
                                                <td>
                                                    <span class="badge bg-dark" style="font-size: 1rem;">
                                                        {{ collect($this->getPreviewData())->sum('total_qty') }}
                                                    </span>
                                                </td>
                                                <td colspan="2" class="text-muted" style="font-size: 0.9rem;">
                                                    {{ count($this->getPreviewData()) }} line(s)
                                                </td>
                                            </tr>
                                        </tfoot>
                                        @endif
                                    </table>
                                </div>

                                {{-- Import Button --}}
                                @if(empty($validationErrors))
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <button type="button" 
                                                    wire:click="importData" 
                                                    class="btn btn-success btn-lg"
                                                    @if($isProcessing || empty($selectedSeason)) disabled @endif>
                                                @if($isProcessing)
                                                    <i class="fas fa-spinner fa-spin"></i> Importing...
                                                @else
                                                    <i class="fas fa-download"></i> Import Data
                                                @endif
                                            </button>
                                            @if(empty($selectedSeason))
                                                <small class="text-warning d-block mt-1">Please select a season to import</small>
                                            @endif
                                            @if(!empty($duplicateOrders))
                                                <small class="text-warning d-block mt-1">Duplicate POs present. Ensure an action is chosen for each.</small>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                    {{-- Import Results --}}
                    @if(!empty($importResults))
                        <div class="card mt-4">
                            <div class="card-header {{ $importResults['success'] ? 'bg-success' : 'bg-danger' }} text-white">
                                <h4 class="card-title mb-0">
                                    <i class="fas {{ $importResults['success'] ? 'fa-check-circle' : 'fa-times-circle' }}"></i>
                                    Import Results
                                </h4>
                            </div>
                            <div class="card-body">
                                @if($importResults['success'])
                                    <div class="alert alert-success">
                                        <h5>Import Completed Successfully!</h5>
                                        <ul class="mb-0">
                                            <li>Orders Created: <strong>{{ $importResults['orders_created'] }}</strong></li>
                                            <li>Order Lines Created: <strong>{{ $importResults['lines_created'] }}</strong></li>
                                        </ul>
                                    </div>
                                @else
                                    <div class="alert alert-danger">
                                        <h5>Import Failed</h5>
                                        <ul class="mb-0">
                                            @foreach($importResults['errors'] as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>

    {{-- Loading Overlay --}}
    @if($isProcessing)
        <div class="position-fixed top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" 
             style="background: rgba(0,0,0,0.5); z-index: 9999;">
            <div class="bg-white p-4 rounded shadow">
                <div class="text-center">
                    <i class="fas fa-spinner fa-spin fa-3x text-primary mb-3"></i>
                    <h5>Processing...</h5>
                    <p class="text-muted">Please wait while we process your files</p>
                </div>
            </div>
        </div>
    @endif
</div>

<script>
    // Auto-scroll to preview when it appears
    document.addEventListener('livewire:updated', () => {
        if (document.querySelector('.card .bg-success')) {
            document.querySelector('.card .bg-success').scrollIntoView({ 
                behavior: 'smooth', 
                block: 'start' 
            });
        }
    });
</script>

