<div @if(!$currentFile) wire:poll.10s @endif>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                {{-- Header --}}
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h2>
                            @if($currentFile)
                                Review File
                            @else
                                Batch Files: {{ $batch->batch_name }}
                            @endif
                        </h2>
                        <p class="text-muted mb-0">
                            Customer: <strong>{{ $batch->customer_name }}</strong>
                            @if(!$currentFile)
                                | Files: {{ $batch->total_files }} total
                                <span class="badge bg-secondary ms-2">Auto-refreshing</span>
                            @endif
                        </p>
                    </div>
                    @if($currentFile)
                        <a href="{{ route('commission.batch.review', ['batchId' => $batch->id]) }}" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left"></i> Back to File List
                        </a>
                    @else
                        <a href="{{ route('commission.batch.list') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Batches
                        </a>
                    @endif
                </div>

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if($currentFile)
                    {{-- File Header --}}
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
<div>
                                    <h5 class="mb-1">
                                        <i class="fas fa-file-alt"></i> {{ $currentFile->original_filename }}
                                    </h5>
                                    <span class="badge 
                                        @if($currentFile->status === 'extracted') bg-success
                                        @elseif($currentFile->status === 'imported') bg-info
                                        @elseif($currentFile->status === 'failed') bg-danger
                                        @else bg-secondary @endif">
                                        {{ ucfirst($currentFile->status) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($currentFile->hasFailed())
                        <div class="alert alert-danger">
                            <h5><i class="fas fa-exclamation-circle"></i> Extraction Failed</h5>
                            <p class="mb-2">{{ $currentFile->error_message }}</p>
                            <button wire:click="retryFile" class="btn btn-warning">
                                <i class="fas fa-redo"></i> Retry Extraction
                            </button>
                        </div>
                    @elseif($currentFile->isImported())
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i> This file has already been imported.
                        </div>
                    @elseif($currentFile->isReadyForReview())
                        {{-- Season Selection --}}
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label">Season</label>
                                        <select class="form-select" wire:model="selectedSeason" wire:loading.attr="disabled" wire:target="importFile">
                                            <option value="">-- Select Season --</option>
                                            @foreach($this->seasons as $season)
                                                <option value="{{ $season->id }}">{{ $season->description }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">File Info</label>
                                        <p class="mb-0">
                                            Orders: <strong>{{ $currentFile->total_orders }}</strong> | 
                                            Lines: <strong>{{ $currentFile->total_lines }}</strong> | 
                                            Total Qty: <strong>{{ $currentFile->total_quantity }}</strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Quantity Warning --}}
                        @if(!empty($currentFile->metadata['total_warning']))
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle"></i> <strong>{{ $currentFile->metadata['total_warning'] }}</strong>
                            </div>
                        @endif

                        {{-- Preview Table --}}
                        <div class="card mb-3">
                            <div class="card-body">
                                <h5 class="card-title">Preview Data</h5>
                                <div class="table-responsive">
                                    <table class="table table-striped table-sm">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>PO Number</th>
                                                <th>Order Date</th>
                                                <th>Style Number</th>
                                                <th>Colour</th>
                                                <th>Ex-Factory</th>
                                                <th>Total Qty</th>
                                                <th>Size / Qty / Price</th>
                                                <th>Set All Prices</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($this->previewData as $item)
                                                <tr>
                                                    <td><strong>{{ $item['purchase_order'] }}</strong></td>
                                                    <td>{{ $item['order_date'] }}</td>
                                                    <td>
                                                        <input 
                                                            type="text" 
                                                            class="form-control form-control-sm" 
                                                            value="{{ $item['style_number'] }}"
                                                            wire:change="updateStyleNumber({{ $item['order_index'] }}, {{ $item['line_index'] }}, $event.target.value)"
                                                            wire:loading.attr="disabled"
                                                            wire:target="importFile"
                                                            style="font-size: 0.85rem; min-width: 100px;"
                                                        >
                                                    </td>
                                                    <td>
                                                        <input 
                                                            type="text" 
                                                            class="form-control form-control-sm" 
                                                            value="{{ $item['colour_name'] }}"
                                                            wire:change="updateColour({{ $item['order_index'] }}, {{ $item['line_index'] }}, $event.target.value)"
                                                            wire:loading.attr="disabled"
                                                            wire:target="importFile"
                                                            style="font-size: 0.85rem; min-width: 120px;"
                                                        >
                                                    </td>
                                                    <td>
                                                        <input 
                                                            type="date" 
                                                            class="form-control form-control-sm" 
                                                            value="{{ $item['customer_exfty_date'] }}"
                                                            wire:change="updateExftyDate({{ $item['order_index'] }}, {{ $item['line_index'] }}, $event.target.value)"
                                                            wire:loading.attr="disabled"
                                                            wire:target="importFile"
                                                            style="font-size: 0.85rem; min-width: 140px;"
                                                        >
                                                    </td>
                                                    <td><span class="badge bg-primary">{{ $item['total_qty'] }}</span></td>
                                                    <td>
                                                        <div class="d-flex flex-column gap-1">
                                                            @foreach($item['quantities'] as $sizeIndex => $qty)
                                                                <div class="d-flex align-items-center gap-2">
                                                                    <span class="badge bg-secondary" style="font-size: 0.85rem; min-width: 45px; text-align: center;">
                                                                        {{ $qty['size'] ?? 'N/A' }}
                                                                    </span>
                                                                    <span class="badge bg-info text-dark" style="font-size: 0.85rem; min-width: 35px; text-align: center;">
                                                                        {{ $qty['qty'] ?? 0 }}
                                                                    </span>
                                                                    <div class="input-group input-group-sm" style="width: 120px;">
                                                                        <span class="input-group-text" style="min-width: 30px;">{{ $this->getCurrencySymbol() }}</span>
                                                                        <input 
                                                                            type="number" 
                                                                            class="form-control" 
                                                                            step="0.01"
                                                                            value="{{ $qty['price'] ?? 0 }}"
                                                                            wire:change="updatePrice({{ $item['order_index'] }}, {{ $item['line_index'] }}, {{ $sizeIndex }}, $event.target.value)"
                                                                            wire:loading.attr="disabled"
                                                                            wire:target="importFile"
                                                                            style="font-size: 0.85rem;"
                                                                        >
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="input-group input-group-sm" style="width: 120px;">
                                                            <span class="input-group-text" style="min-width: 30px;">{{ $this->getCurrencySymbol() }}</span>
                                                            <input 
                                                                type="number" 
                                                                class="form-control" 
                                                                step="0.01"
                                                                placeholder="All"
                                                                wire:change="updateLinePrice({{ $item['order_index'] }}, {{ $item['line_index'] }}, $event.target.value)"
                                                                wire:loading.attr="disabled"
                                                                wire:target="importFile"
                                                                style="font-size: 0.85rem;"
                                                            >
                                                        </div>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="8" class="text-center text-muted">No data to preview</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                        @if(!empty($this->previewData))
                                        <tfoot>
                                            <tr class="table-secondary fw-bold">
                                                <td colspan="5" class="text-end">GRAND TOTAL:</td>
                                                <td>
                                                    <span class="badge bg-dark" style="font-size: 1rem;">
                                                        {{ collect($this->previewData)->sum('total_qty') }}
                                                    </span>
                                                </td>
                                                <td colspan="2" class="text-muted" style="font-size: 0.9rem;">
                                                    {{ count($this->previewData) }} line(s)
                                                </td>
                                            </tr>
                                        </tfoot>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                        {{-- Action Buttons --}}
                        <div class="d-flex gap-2 mb-4">
                            <button wire:click="importFile" 
                                    class="btn btn-success btn-lg"
                                    wire:loading.attr="disabled"
                                    wire:loading.class="disabled"
                                    @if(empty($selectedSeason)) disabled @endif>
                                <span wire:loading.remove wire:target="importFile">
                                    <i class="fas fa-download"></i> Import This File
                                </span>
                                <span wire:loading wire:target="importFile">
                                    <i class="fas fa-spinner fa-spin"></i> Importing...
                                </span>
                            </button>
                            
                            <button 
                                type="button"
                                class="btn btn-warning btn-lg"
                                data-bs-toggle="modal" 
                                data-bs-target="#skipFileModal"
                                wire:loading.attr="disabled"
                                wire:target="importFile">
                                <i class="fas fa-ban"></i> Skip This File
                            </button>
                        </div>

                        {{-- Skip File Modal --}}
                        <div class="modal fade" id="skipFileModal" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Skip File</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Why are you skipping this file?</p>
                                        <input type="text" 
                                               class="form-control" 
                                               id="skipReasonInput" 
                                               placeholder="e.g., Duplicate order, Already imported manually, etc.">
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <button type="button" 
                                                class="btn btn-warning" 
                                                onclick="
                                                    let reason = document.getElementById('skipReasonInput').value || 'Not needed';
                                                    @this.call('skipFile', null, reason);
                                                    bootstrap.Modal.getInstance(document.getElementById('skipFileModal')).hide();
                                                ">
                                            <i class="fas fa-ban"></i> Skip File
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Loading Overlay (only show during import) --}}
                        <div wire:loading.delay wire:target="importFile" 
                             style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 9999; display: none; align-items: center; justify-content: center;">
                            <div class="card shadow-lg" style="min-width: 300px;">
                                <div class="card-body text-center">
                                    <div class="spinner-border text-success mb-3" role="status" style="width: 3rem; height: 3rem;">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    <h5 class="mb-2">Importing Data...</h5>
                                    <p class="text-muted mb-0">Please wait while we process your order.</p>
                                </div>
                            </div>
                        </div>
                        
                        <style>
                            [wire\:loading\.delay][wire\:target="importFile"] {
                                display: none !important;
                            }
                            [wire\:loading\.delay][wire\:target="importFile"].wire-loading {
                                display: flex !important;
                            }
                        </style>
                    @else
                        <div class="alert alert-info">
                            <i class="fas fa-spinner fa-spin"></i> File is still being processed. Please wait...
                        </div>
                    @endif
                @else
                    {{-- File List View (when no specific file selected) --}}
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Files in this Batch</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Filename</th>
                                            <th>Status</th>
                                            <th>Orders</th>
                                            <th>Lines</th>
                                            <th>Quantity</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($batch->files as $file)
                                            <tr>
                                                <td>
                                                    <i class="fas fa-file me-2 text-muted"></i>
                                                    <a href="#" wire:click.prevent="downloadFile({{ $file->id }})" class="text-decoration-none">
                                                        {{ $file->original_filename }}
                                                    </a>
                                                </td>
                                                <td>
                                                <span class="badge 
                                                    @if($file->status === 'extracted') bg-success
                                                    @elseif($file->status === 'imported') bg-info
                                                    @elseif($file->status === 'failed') bg-danger
                                                    @elseif($file->status === 'processing') bg-warning
                                                    @elseif($file->status === 'skipped') bg-secondary
                                                    @else bg-secondary @endif">
                                                    {{ ucfirst($file->status) }}
                                                </span>
                                                @if($file->status === 'skipped' && $file->skip_reason)
                                                    <br><small class="text-muted">{{ $file->skip_reason }}</small>
                                                @endif
                                            </td>
                                                <td>
                                                    <small class="text-muted">{{ $file->total_orders ?? 0 }}</small>
                                                </td>
                                                <td>
                                                    <small class="text-muted">{{ $file->total_lines ?? 0 }}</small>
                                                </td>
                                                <td>
                                                    <small class="text-muted">{{ $file->total_quantity ?? 0 }}</small>
                                                </td>
                                                <td>
                                                    @if($file->status === 'extracted')
                                                        <div class="btn-group btn-group-sm" role="group">
                                                            <a href="{{ route('commission.batch.review', ['batchId' => $batch->id, 'fileId' => $file->id]) }}" 
                                                               class="btn btn-primary">
                                                                <i class="fas fa-eye"></i> Review & Import
                                                            </a>
                                                            <button wire:click="retryFile({{ $file->id }})" 
                                                                    class="btn btn-warning"
                                                                    title="Re-extract this file">
                                                                <i class="fas fa-redo"></i>
                                                            </button>
                                                            <button type="button"
                                                                    class="btn btn-secondary"
                                                                    title="Skip this file"
                                                                    onclick="
                                                                        let reason = prompt('Why are you skipping this file?', 'Not needed');
                                                                        if (reason !== null) {
                                                                            @this.call('skipFile', {{ $file->id }}, reason);
                                                                        }
                                                                    ">
                                                                <i class="fas fa-ban"></i>
                                                            </button>
                                                        </div>
                                                    @elseif($file->status === 'imported')
                                                        <div class="btn-group btn-group-sm" role="group">
                                                            <a href="{{ route('commission.batch.review', ['batchId' => $batch->id, 'fileId' => $file->id]) }}" 
                                                               class="btn btn-info">
                                                                <i class="fas fa-check"></i> View
                                                            </a>
                                                            <button wire:click="retryFile({{ $file->id }})" 
                                                                    class="btn btn-warning"
                                                                    title="Re-extract this file (will not duplicate import)">
                                                                <i class="fas fa-redo"></i>
                                                            </button>
                                                        </div>
                                                    @elseif($file->status === 'skipped')
                                                        <button wire:click="retryFile({{ $file->id }})" 
                                                                class="btn btn-sm btn-warning"
                                                                title="Re-extract this file">
                                                            <i class="fas fa-redo"></i> Re-process
                                                        </button>
                                                    @elseif($file->status === 'failed')
                                                        <div class="btn-group btn-group-sm" role="group">
                                                            <button wire:click="retryFile({{ $file->id }})" class="btn btn-warning">
                                                                <i class="fas fa-redo"></i> Retry
                                                            </button>
                                                            <button type="button"
                                                                    class="btn btn-secondary"
                                                                    title="Skip this file"
                                                                    onclick="
                                                                        let reason = prompt('Why are you skipping this file?', 'Extraction failed');
                                                                        if (reason !== null) {
                                                                            @this.call('skipFile', {{ $file->id }}, reason);
                                                                        }
                                                                    ">
                                                                <i class="fas fa-ban"></i>
                                                            </button>
                                                        </div>
                                                        <div class="text-danger small mt-1">{{ $file->error_message }}</div>
                                                    @else
                                                        <span class="text-muted small">
                                                            <i class="fas fa-spinner fa-spin"></i> Processing...
                                                        </span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center text-muted py-4">
                                                    No files in this batch.
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
