<div wire:poll.10s>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
<div>
                        <h2>Commission Import Batches</h2>
                        <small class="text-muted">Auto-refreshing every 10 seconds</small>
                    </div>
                    <a href="{{ route('commission.batch.upload') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> New Batch
                    </a>
                </div>

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                {{-- Filters --}}
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" 
                                       class="form-control" 
                                       wire:model.live="search"
                                       placeholder="Search by batch name or customer...">
                            </div>
                            <div class="col-md-6">
                                <select class="form-select" wire:model.live="statusFilter">
                                    <option value="all">All Statuses</option>
                                    <option value="pending">Pending</option>
                                    <option value="processing">Processing</option>
                                    <option value="completed">Completed</option>
                                    <option value="failed">Failed</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Batches List --}}
                <div class="card">
                    <div class="card-body">
                        @if($batches->isEmpty())
                            <div class="text-center py-5 text-muted">
                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                <p class="mb-0">No batches found. <a href="{{ route('commission.batch.upload') }}">Upload your first batch</a>.</p>
                            </div>
                        @else
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Batch Name</th>
                                            <th>Customer</th>
                                            <th>Files</th>
                                            <th>Progress</th>
                                            <th>Status</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($batches as $batch)
                                            <tr>
                                                <td>
                                                    <strong>{{ $batch->batch_name }}</strong>
                                                </td>
                                                <td>{{ $batch->customer_name }}</td>
                                                <td>
                                                    <span class="badge bg-secondary">{{ $batch->total_files }} files</span>
                                                </td>
                                                <td style="width: 200px;">
                                                    <div class="progress">
                                                        <div class="progress-bar 
                                                            @if($batch->progress_percentage == 100) bg-success 
                                                            @elseif($batch->failed_files > 0) bg-warning 
                                                            @endif" 
                                                             role="progressbar" 
                                                             style="width: {{ $batch->progress_percentage }}%"
                                                             aria-valuenow="{{ $batch->progress_percentage }}" 
                                                             aria-valuemin="0" 
                                                             aria-valuemax="100">
                                                            {{ $batch->progress_percentage }}%
                                                        </div>
                                                    </div>
                                                    <small class="text-muted">
                                                        {{ $batch->actual_processed_files }}/{{ $batch->total_files }} processed
                                                        @if($batch->actual_failed_files > 0)
                                                            <span class="text-danger">({{ $batch->actual_failed_files }} failed)</span>
                                                        @endif
                                                        @if($batch->skipped_files > 0)
                                                            <span class="text-secondary">({{ $batch->skipped_files }} skipped)</span>
                                                        @endif
                                                    </small>
                                                </td>
                                                <td>
                                                    @if($batch->status === 'completed')
                                                        <span class="badge bg-success">Completed</span>
                                                    @elseif($batch->status === 'processing')
                                                        <span class="badge bg-primary">Processing</span>
                                                    @elseif($batch->status === 'failed')
                                                        <span class="badge bg-danger">Failed</span>
                                                    @else
                                                        <span class="badge bg-secondary">Pending</span>
                                                    @endif
                                                </td>
                                                <td>{{ $batch->created_at->diffForHumans() }}</td>
                                                <td>
                                                    <div class="btn-group btn-group-sm">
                                                        <a href="{{ route('commission.batch.review', ['batchId' => $batch->id]) }}" 
                                                           class="btn btn-primary"
                                                           title="View Files">
                                                            <i class="fas fa-folder-open"></i> View Files
                                                        </a>
                                                        <button wire:click="deleteBatch({{ $batch->id }})" 
                                                                class="btn btn-danger"
                                                                onclick="return confirm('Delete this batch and all its files?')"
                                                                title="Delete Batch">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            {{-- Pagination --}}
                            <div class="mt-3">
                                {{ $batches->links() }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
