<div>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">Commission PO Batch Upload</h2>

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="card">
                    <div class="card-body">
                        <form wire:submit.prevent="uploadBatch">
                            {{-- Batch Name --}}
                            <div class="mb-3">
                                <label for="batchName" class="form-label">Batch Name (Optional)</label>
                                <input type="text" 
                                       class="form-control" 
                                       id="batchName" 
                                       wire:model="batchName"
                                       placeholder="e.g., SS26 Week 1">
                                <small class="text-muted">Leave blank to auto-generate</small>
                            </div>

                            {{-- Customer Selection --}}
                            <div class="mb-3">
                                <label for="customer" class="form-label">Customer <span class="text-danger">*</span></label>
                                <select class="form-select @error('selectedCustomer') is-invalid @enderror" 
                                        id="customer" 
                                        wire:model="selectedCustomer">
                                    <option value="">-- Select Customer --</option>
                                    @foreach($this->availableCustomers as $customer)
                                        <option value="{{ $customer }}">{{ $customer }}</option>
                                    @endforeach
                                </select>
                                @error('selectedCustomer')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            {{-- File Upload --}}
                            <div class="mb-3">
                                <label for="files" class="form-label">Upload Files <span class="text-danger">*</span></label>
                                <input type="file" 
                                       class="form-control @error('files') is-invalid @enderror" 
                                       id="files" 
                                       wire:model="files"
                                       multiple
                                       accept=".pdf,.xlsx,.xls">
                                <small class="text-muted">You can select multiple PO files (PDF, Excel)</small>
                                @error('files')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            {{-- Upload Progress --}}
                            @if($isUploading)
                                <div class="alert alert-info">
                                    <i class="fas fa-spinner fa-spin"></i> Uploading files and creating batch...
                                </div>
                            @endif

                            {{-- Selected Files Preview --}}
                            @if(!empty($files))
                                <div class="mb-3">
                                    <h6>Selected Files ({{ count($files) }}):</h6>
                                    <ul class="list-group">
                                        @foreach($files as $file)
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>
                                                    <i class="fas fa-file-alt me-2"></i>
                                                    {{ $file->getClientOriginalName() }}
                                                </span>
                                                <span class="badge bg-secondary">
                                                    {{ number_format($file->getSize() / 1024, 2) }} KB
                                                </span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            {{-- Submit Button --}}
                            <div class="d-flex gap-2">
                                <button type="submit" 
                                        class="btn btn-primary btn-lg"
                                        @if($isUploading || empty($selectedCustomer) || empty($files)) disabled @endif>
                                    @if($isUploading)
                                        <i class="fas fa-spinner fa-spin"></i> Uploading...
                                    @else
                                        <i class="fas fa-upload"></i> Upload Batch & Start Processing
                                    @endif
                                </button>
                                <a href="{{ route('commission.batch.list') }}" class="btn btn-outline-secondary btn-lg">
                                    <i class="fas fa-list"></i> View Batches
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                {{-- Info Box --}}
                <div class="alert alert-info mt-4">
                    <h5><i class="fas fa-info-circle"></i> How It Works</h5>
                    <ol class="mb-0">
                        <li>Select a customer and upload multiple PO files</li>
                        <li>Files will be processed in the background using AI</li>
                        <li>Go to "Review Batches" to see progress</li>
                        <li>Once extracted, review and import each file</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>
