<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Import AI Orders - KWA
        </x-slot:title>
        <x-slot:end>
        </x-slot:end>
    </x-title-bar>
    {{-- Main Content --}}
    <div id="page-content-container" class="container-fluid">
        {{-- Alert Messages --}}
        <div class="row">
            <div class="col">
                @if(session('messages'))
                    @if(!empty(session('messages.errors')))
                        <div class="alert alert-danger">
                            <ul>
                                @foreach(session('messages.errors') as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if(!empty(session('messages.saved')))
                        <div class="alert alert-success">
                            <p>Saved Orders:</p>
                            <ul>
                                @foreach(session('messages.saved') as $saved)
                                    <li>{{ $saved }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                @endif
                @if($errors->all())
                    <div class="alert alert-dark" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        <div class="row p-3">
            <div class="col">
                <div class="input-group">
                    <select class="form-select" wire:model="customer">
                        <option value="">Select Customer...</option>
                        @foreach($this->customers as $customer)
                            <option value="{{$customer->id}}">{{$customer->name}}</option>
                        @endforeach
                    </select>
                    <select class="form-select" wire:model="season"  wire:loading.attr="disabled" @if($this->files) disabled @endif>
                        <option value="">Select Season...</option>
                        @foreach($this->seasons as $season)
                            <option value="{{$season['id']}}">{{$season['description']}}</option>
                        @endforeach
                    </select>
                    <input type="file" wire:model="orderFiles" multiple class="form-control" accept=".xls, .xlsx, .pdf, .csv" id="fileUpload"  wire:loading.attr="disabled" @if($this->files) disabled @endif>
                    <button class="btn btn-primary" wire:click="uploadOrders" id="uploadButton" wire:loading.attr="disabled" @if($this->files) disabled @endif>
                        <span wire:loading.remove>Upload Orders</span>
                        <span wire:loading>Processing...</span>
                    </button>
                </div>
            </div>
        </div>

        @if($this->files)
            <div class="row p-3">
                <div class="col">
                    <table class="table">
                        <thead>
                            <tr>
                                <th style="min-width: 160px;">PO Number</th>
                                <th style="min-width: 100px;">Date</th>
                                <th style="min-width: 100px;">Phase</th>
                                <th style="min-width: 100px;">Incoterms</th>
                                <th style="min-width: 100px;">Delivery Address</th>
                                <th style="min-width: 100px;">Customer Ref</th>
                                {{-- <th style="min-width: 100px;">RT No.</th> --}}
                                <th style="min-width: 100px;">Description</th>
                                <th style="min-width: 150px;">Colourway</th>
                                <th style="min-width: 100px;">Customer Exfty</th>
                                <th style="min-width: 100px;">Customer Into W/H</th>
                                <th style="min-width: 100px;">Size</th>
                                <th style="min-width: 100px;">Qty</th>
                                <th style="min-width: 100px;">Price</th>
                                <th style="min-width: 100px;">Cost</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($this->files as $f => $file)
                                @foreach($file['purchase_orders'] as $o => $order)
                                    @foreach($order['styles'] as $s => $style)
                                        @foreach($style['colorways'] as $c => $colorway)
                                            @foreach($colorway['size_quantities'] as $si => $size)
                                                <tr>
                                                    @if ($loop->parent->parent->first && $loop->parent->first && $loop->first)
                                                        <td rowspan="{{ $loop->count * $loop->parent->count * $loop->parent->parent->count }}">
                                                            <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.po_number">
                                                        </td>
                                                        <td rowspan="{{ $loop->count * $loop->parent->count * $loop->parent->parent->count }}">
                                                            <input type="date" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.date">
                                                        </td>
                                                        <td rowspan="{{ $loop->count * $loop->parent->count * $loop->parent->parent->count }}">
                                                            <select class="form-select" wire:model="files.{{$f}}.purchase_orders.{{$o}}.phase_id">
                                                                <option value=""></option>
                                                                <option value="1">High Season</option>
                                                                <option value="2">Downtime</option>
                                                            </select>
                                                        </td>
                                                        <td rowspan="{{ $loop->count * $loop->parent->count * $loop->parent->parent->count }}">
                                                            <select class="form-select" wire:model="files.{{$f}}.purchase_orders.{{$o}}.incoterms">
                                                                <option value=""></option>
                                                                <option value="EXW">EXW</option>
                                                                <option value="FCA">FCA</option>
                                                                <option value="CPT">CPT</option>
                                                                <option value="CIP">CIP</option>
                                                                <option value="DAP">DAP</option>
                                                                <option value="DPU">DPU</option>
                                                                <option value="DDP">DDP</option>
                                                                <option value="FAS">FAS</option>
                                                                <option value="FOB">FOB</option>
                                                                <option value="CFR">CFR</option>
                                                                <option value="CIF">CIF</option>
                                                            </select>
                                                        </td>
                                                        <td rowspan="{{ $loop->count * $loop->parent->count * $loop->parent->parent->count }}" class="@if($order['delivery_address_id']) bg-good @else bg-red @endif">
                                                            <select style="width: auto;" class="form-select" wire:model.live="files.{{$f}}.purchase_orders.{{$o}}.delivery_address_id">
                                                                <option value="">Select...</option>
                                                                @foreach($this->addresses as $address)
                                                                    <option value="{{$address['id']}}">{{$address['name']}}</option>
                                                                @endforeach
                                                            </select>
                                                            {{-- {{$order['delivery_address_id']}} --}}
                                                            @php
                                                                $address = collect($this->addresses)->firstWhere('id', $order['delivery_address_id']);
                                                            @endphp
                                                            @if(!is_null($address))
                                                                @if($address['line1']) {{ $address['line1']}}<br> @endif
                                                                @if($address['line2']) {{ $address['line2']}}<br> @endif
                                                                @if($address['line3']) {{ $address['line3']}}<br> @endif
                                                                @if($address['city']) {{ $address['city']}}<br> @endif
                                                                @if($address['region']) {{ $address['region']}}<br> @endif
                                                                {{ $address['postcode']}}
                                                            @endif
                                                        </td>
                                                    @endif
                                                    @if($loop->parent->first && $loop->first)
                                                        <td rowspan="{{ $loop->count * $loop->parent->count }}" class="@if($colorway['colorway_id']) bg-good @else bg-red @endif">
                                                            <select style="width: auto;" class="form-select" wire:model.live="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.style_version_id">
                                                                @foreach($this->styleVersions as $styleV)
                                                                    <option value="{{$styleV->id}}">{{$styleV->styles->designs_id}}: {{$styleV->styles->customer_ref}} ({{$styleV->name}})</option>
                                                                @endforeach
                                                            </select>
                                                            {{-- {{$style['model']->styles->customer_ref ?? ''}} --}}
                                                        </td>
                                                        {{-- <td rowspan="{{ $loop->count * $loop->parent->count }}" class="@if($colorway['colorway_id']) bg-good @else bg-red @endif">
                                                            {{$style['model']->styles->designs_id ?? ''}}
                                                        </td> --}}
                                                        <td rowspan="{{ $loop->count * $loop->parent->count }}" class="@if($colorway['colorway_id']) bg-good @else bg-red @endif">
                                                            {{$style['model']->styles->designs->description ?? ''}}
                                                        </td>
                                                    @endif
                                                    @if ($loop->first)
                                                        <td rowspan="{{ $loop->count }}" class="@if($colorway['colorway_id']) bg-good @else bg-red @endif">
                                                            <select style="width: auto;" class="form-select" wire:model.live="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.colorway_id">
                                                                <option value="">Select...</option>
                                                                @foreach($this->colourways($style['style_version_id']) as $cw)
                                                                    <option value="{{$cw['id']}}">{{$cw['name']}}</option>
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td rowspan="{{ $loop->count }}">
                                                            <input type="date" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.customer_exfty">
                                                        </td>
                                                        <td rowspan="{{ $loop->count }}">
                                                            <input type="date" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.customer_into_wh">
                                                        </td>
                                                    @endif
                                                    <td>
                                                        <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.size_quantities.{{$si}}.size">
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.size_quantities.{{$si}}.quantity">
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.size_quantities.{{$si}}.quote">
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" wire:model="files.{{$f}}.purchase_orders.{{$o}}.styles.{{$s}}.colorways.{{$c}}.size_quantities.{{$si}}.cmt">
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    @endforeach
                                @endforeach
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row pb-3">
                <div class="col text-end">
                    <button class="btn btn-primary" x-on:click="window.scrollTo({top: 0, behavior: 'smooth'})" wire:click="createOrders">Create Orders?</button>
                </div>
            </div>
            {{-- {{json_encode($this->files)}} --}}
        @endif
    </div>

    {{-- <x-footer>
        <x-slot:end>
            <button class="btn btn-primary mt-3" x-on:click="window.scrollTo({top: 0, behavior: 'smooth'})" wire:click="createOrders">Create Orders?</button>
        </x-slot:end>
    </x-footer> --}}

    @script
    <script>
        document.addEventListener('livewire:load', function () {
            const fileInput = document.getElementById("fileUpload");

            fileInput.addEventListener("change", function () {
                const fileCount = fileInput.files.length;

                if (fileCount > 10) {
                    alert("You are only allowed to upload a maximum of 10 files.");
                    $wire.dispatch('toggleuploadbutton', true);
                } else {
                    $wire.dispatch('toggleuploadbutton', false);
                }
            });
        });
    </script>
    @endscript
</div>
