<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Samples for Invoicing
        </x-slot:title>
        <x-slot:end>
            @can('design:create')
                <button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'bulk'})">Bulk</button>
                <button class="btn btn-light" wire:click="test">test</button>
            @endcan
            @can('finance:create')
                <button class="btn btn-outline-primary" wire:click="selectAll" wire:loading.attr="disabled">
                    <i class="fas fa-check-square"></i> Select All
                </button>
                <button class="btn btn-outline-secondary" wire:click="deselectAll" wire:loading.attr="disabled">
                    <i class="fas fa-square"></i> Deselect All
                </button>
                <button class="btn btn-primary" x-data x-on:click="$dispatch('open-modal', {name:'invoice-generator'})" 
                        wire:loading.attr="disabled"
                        @if(empty($selected) || count(array_filter($selected)) == 0) disabled @endif>
                    <i class="fas fa-file-invoice"></i> Generate Invoice
                </button>
            @endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="season">
                                <option value="">All</option>
								@foreach($this->seasons as $s=>$season)
									<option value="{{$season->id}}">{{$season->description}}</option>
								@endforeach
							</select>
							<label>Season</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="from">
							<label>From</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<input type="date" style="height: calc(3.5rem + 2px);" class="form-control" wire:model.live.lazy="to">
							<label>To</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="customer">
                                <option value="">All</option>
								@foreach($this->customers as $s=>$customer)
									<option value="{{$customer->id}}">{{$customer->name}}</option>
								@endforeach
							</select>
							<label>Customer</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="factory">
								<option value="">All</option>
								@foreach($this->factories as $s=>$factory)
									<option value="{{$factory->id}}">{{$factory->name}}</option>
								@endforeach
							</select>
							<label>Factory</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="coo">
								<option value="">All</option>
								@foreach($this->factories->unique('countries_id') as $s=>$factory)
									<option value="{{$factory->countries->id}}">{{$factory->countries->country}}</option>
								@endforeach
							</select>
							<label>COO</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="department">
								<option value="">All</option>
								@foreach($this->departments as $s=>$department)
									<option value="{{$department->id}}">{{$department->description}}</option>
								@endforeach
							</select>
							<label>Department</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" style="height: calc(3.5rem + 2px);" wire:model.live="category">
								<option value="">All</option>
								<option value="mens">Mens</option>
								<option value="ladies">Ladies</option>
								<option value="childrens">Chidrens</option>
								<option value="accessories">Accessories</option>
							</select>
							<label>Category</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="fn_complete">
								<option selected value="1">Yes</option>
								<option selected value="0">No</option>
							</select>
							<label class="form-label">Show Complete:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="paginate">
								<option selected value="10">10</option>
								<option selected value="50">50</option>
								<option selected value="100">100</option>
								<option selected value="200">200</option>
								<option selected value="500">500</option>
								<option selected value="2000">2000</option>
							</select>
							<label class="form-label">Per Page:</label>
						</div>
					</div>
                    {{-- <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" /> --}}
                </div>
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.1000ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
						<tr class="text-center">
							<th>
                                Sample<br>
                                <input type="checkbox" class="form-check-input" wire:model.live="selectAllCheckbox" wire:click="toggleSelectAll">
                            </th>
							<th>Season</th>
							<th>Customer</th>
							<th>Style</th>
							<th style="min-width: 200px">Description</th>
							<th style="min-width: 150px">Colourway</th>
							<th>Size</th>
							<th>PO</th>
							<th>Type</th>
							<th style="min-width: 150px">Factory</th>
							<th>Carryover</th>
							<th>Qty</th>
							<th style="min-width: 110px">Sent</th>
							<th>Dev Notes</th>
							<th>Orders</th>
							<th>Quote</th>
							<th>Discount</th>
							<th>Surcharge</th>
							<th>Charge Dev</th>
							<th>Charge Freight</th>
							<th style="min-width: 100px">RT Invoice</th>
							<th style="min-width: 150px">FTY Invoice</th>
							<th style="min-width: 250px">Comments</th>
							<th>Complete</th>
						</tr>
					</thead>
					<tbody>
						@foreach($samples as $s=>$sample)
							<tr class="@if($sample['s_cancelled']) bg-red @endif text-center">
								<td>
                                    {{$sample->id}}<br>
                                    <input type="checkbox" class="form-check-input" wire:model.live="selected.{{$sample->id}}">
                                </td>
								<td>{{$sample->season}}</td>
								<td>{{$sample->customer}}</td>
								<td>RTD{{$sample->rt_no}}<br>{{$sample->customer_ref}} {{$sample->style_version}}</td>
								<td>{{$sample->description}}</td>
								<td>{{$sample->colourway}}</td>
								<td>{{$sample->size}}</td>
								<td>{{$sample->po}}</td>
								<td>{{$sample->sample_type}}</td>
								<td>{{$sample->factory}}</td>
								<td>{{$sample->carryover}}</td>
								<td>{{$sample->qty}}</td>
								<td>{{$sample->date_sent?->format('d-M-Y')}}</td>
								<td>{{$sample->fn_notes}}</td>
								<td style="white-space: nowrap;">
									@foreach(json_decode($sample->orders) ?? [] as $order)
										{{$order->po}}<br>
									@endforeach
								</td>
								@if($sample->do_not_charge)
									<td colspan="5">DO NOT CHARGE</td>
								@else
									<td style="white-space: nowrap;" class="@if($sample->quote_status == 'confirmed') bg-good @endif">
                                        <a href="/pricing?goTo={{$sample->styles_id}}">{{number_format($sample->quote, 2)}}</a>
									</td>
									<td>{{$sample->sample_settings->discount ?? 0}}%</td>
									<td>{{$sample->sample_settings->surcharge ?? 0}}%</td>
									<td>{{$sample->cust_currency}}{{number_format($sample->sample_settings?->development ?? 0, 2)}}</td>
									<td>{{$sample->sample_settings->freight ?? 0 ? "Yes" : "No"}}</td>
								@endif

								<td><input type="text" class="form-control" wire:model.live.debounce.500ms="form.samples.{{$s}}.rt_invoice"></td>
								<td><input type="text" class="form-control" wire:model.live.debounce.500ms="form.samples.{{$s}}.fty_invoice"></td>
								<td><textarea class="form-control" style="resize: none;" wire:model.live.debounce.500ms="form.samples.{{$s}}.finance_comments"></textarea></td>
								<div></div>
								<td>
									<input type="checkbox" class="form-check-input" wire:model.live.debounce.500ms="form.samples.{{$s}}.fn_complete">
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>

    <x-modal name="bulk" title="Bulk Update" size="modal-sm">
        <x-slot:body>
            <livewire:finance.samples-invoicing-bulk model:model="selected" wire:key="bulk-invoicing" />
        </x-slot:body>
    </x-modal>

    <x-modal name="invoice-generator" title="Generate Invoices" size="modal-lg">
        <x-slot:body>
            <livewire:finance.samples-invoice-generator wire:key="invoice-generator" />
        </x-slot:body>
    </x-modal>

	<x-footer>
		<x-slot:start>
			<b>TOTALS FOR THIS PAGE ONLY</b><br>
			Qty: {{$samples->sum('qty')}}<br>
			Sale: £{{number_format($samples->sum('quote_total'),2)}}<br>
        </x-slot:start>
        <x-slot:center>
            {{ $samples->links() }}
        </x-slot:center>
    </x-footer>
</div>
