<div class="container-fluid p-4">
    <!-- Messages -->
    @if (Session::get('message'))
        <div class="alert {{ Session::get('alert-class') }} alert-dismissible fade show mb-4" role="alert">
            {{ Session::get('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($errors->all())
        <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
            @foreach ($errors->all() as $error)
                {{ $error }}<br>
            @endforeach
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        <!-- Invoice Numbers Section -->
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-header bg-primary text-white">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-file-invoice me-2"></i>Invoice Numbers
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-semibold">RT Invoice</label>
                        <div class="input-group">
                            <input type="text" class="form-control" wire:model="bulk.rt_invoice" 
                                   @if($nullify['rt_invoice']) disabled @endif
                                   placeholder="Enter RT invoice number">
                            <button class="btn btn-outline-secondary" type="button" 
                                    wire:click="$toggle('nullify.rt_invoice')"
                                    :class="{ 'active': $wire.nullify.rt_invoice }">
                                <i class="fas fa-times"></i> Clear
                            </button>
                        </div>
                    </div>
                    
                    <div class="mb-0">
                        <label class="form-label fw-semibold">Factory Invoice</label>
                        <div class="input-group">
                            <input type="text" class="form-control" wire:model="bulk.fty_invoice"
                                   @if($nullify['fty_invoice']) disabled @endif
                                   placeholder="Enter factory invoice number">
                            <button class="btn btn-outline-secondary" type="button" 
                                    wire:click="$toggle('nullify.fty_invoice')"
                                    :class="{ 'active': $wire.nullify.fty_invoice }">
                                <i class="fas fa-times"></i> Clear
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Comments Section -->
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-header bg-primary text-white">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-comment me-2"></i>Comments
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-0">
                        <label class="form-label fw-semibold">Finance Comments</label>
                        <div class="input-group">
                            <textarea class="form-control" rows="3" wire:model="bulk.comments"
                                      @if($nullify['comments']) disabled @endif
                                      placeholder="Enter comments..."></textarea>
                            <button class="btn btn-outline-secondary" type="button" 
                                    wire:click="$toggle('nullify.comments')"
                                    :class="{ 'active': $wire.nullify.comments }">
                                <i class="fas fa-times"></i> Clear
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Status Section -->
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-check-circle me-2"></i>Completion Status
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="completion_status" 
                                       id="complete" value="complete" wire:model="completionStatus">
                                <label class="form-check-label fw-semibold" for="complete">
                                    <i class="fas fa-check text-success me-2"></i>Complete
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="completion_status" 
                                       id="not_complete" value="not_complete" wire:model="completionStatus">
                                <label class="form-check-label fw-semibold" for="not_complete">
                                    <i class="fas fa-times text-danger me-2"></i>Not Complete
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex justify-content-end gap-2 mt-4">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
            <i class="fas fa-times me-1"></i>Cancel
        </button>
        <button class="btn btn-primary" wire:click="bulkSave" wire:loading.attr="disabled">
            <span wire:loading.remove wire:target="bulkSave">
                <i class="fas fa-save me-1"></i>Save Changes
            </span>
            <span wire:loading wire:target="bulkSave">
                <i class="fas fa-spinner fa-spin me-1"></i>Saving...
            </span>
        </button>
    </div>
</div>

@script
<script>
    // Handle interactions between form elements
    $wire.on('updated', (property, value) => {
        // Clear input fields when clear buttons are clicked
        if (property.startsWith('nullify.')) {
            const field = property.split('.')[1];
            if (value === true) {
                $wire.set(`bulk.${field}`, '');
            }
        }
        
        // Clear nullify when input fields have values
        if (property.startsWith('bulk.')) {
            const field = property.split('.')[1];
            if (value && value !== '') {
                $wire.set(`nullify.${field}`, false);
            }
        }
    });
</script>
@endscript
