<div>
    @if(!$zohoConnected)
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i>
            Zoho is not connected. Please connect to Zoho to generate invoices.
            <button class="btn btn-sm btn-outline-warning ms-2" wire:click="initiateZohoOAuth">
                Connect Zoho
            </button>
        </div>
    @else
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-file-invoice"></i>
                    Generate Invoices for Selected Samples
                </h5>
            </div>
            <div class="card-body">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if(empty($invoiceData) || count($invoiceData) == 0)
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        @if(empty($selectedSamples) || count(array_filter($selectedSamples)) == 0)
                            No samples selected. Please select samples from the table above.
                        @else
                            No valid samples to invoice. Selected samples may already be complete, invoiced, or marked as DO NOT CHARGE.
                        @endif
                    </div>
                @else
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Customer</label>
                            <select class="form-select" wire:model.live="customer" wire:loading.class="opacity-50">
                                <option value="">Select Customer</option>
                                @foreach($customers as $cust)
                                    <option value="{{ $cust->id }}">{{ $cust->name }}</option>
                                @endforeach
                            </select>
                            @error('customer') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Invoice Date</label>
                            <input type="date" class="form-control" wire:model.live="date" wire:loading.class="opacity-50">
                            @error('date') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Account</label>
                            <select class="form-select" wire:model.live="accountCode" wire:loading.class="opacity-50">
                                @if(empty($accountOptions))
                                    <option value="40500">40500 - Sales</option>
                                @else
                                    @foreach($accountOptions as $acc)
                                        <option value="{{ $acc['code'] ?: $acc['id'] }}">{{ $acc['label'] }}</option>
                                    @endforeach
                                @endif
                            </select>
                            <small class="text-muted">Default 40500 - Sales</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Department</label>
                            <select class="form-select" wire:model.live="reportingTagDepartment" wire:loading.class="opacity-50">
                                @foreach($departmentOptions as $id => $name)
                                    <option value="{{ $name }}">{{ $name }}</option>
                                @endforeach
                            </select>
                            <small class="text-muted">Default: Knitted Wholesale Tom</small>
                        </div>
                    </div>

                    @if(!empty($invoiceData))
                        <div class="mb-3">
                            <h6>Selected Samples ({{ collect($invoiceData)->sum(fn($group) => count($group['samples'])) }})</h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Shipment Date</th>
                                            <th>Ref</th>
                                            <th>Description</th>
                                            <th>Colourway</th>
                                            <th>Size</th>
                                            <th>Qty</th>
                                            <th>Price</th>
                                            <th>Discount</th>
                                            <th>Surcharge</th>
                                            <th>Dev Fee</th>
                                            <th>VAT</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($invoiceData as $group)
                                            @foreach($group['samples'] as $index => $sample)
                                                <tr class="@if($sample['do_not_charge']) text-muted @endif">
                                                    @if($index === 0)
                                                        <td rowspan="{{ count($group['samples']) }}" class="align-middle">
                                                            <strong>{{ \Carbon\Carbon::parse($group['shipment_date'])->format('d/m/Y') }}</strong>
                                                        </td>
                                                    @endif
                                                    <td>{{ $sample['customer_ref'] }}</td>
                                                    <td>{{ $sample['description'] }}</td>
                                                    <td>{{ $sample['colourway'] }}</td>
                                                    <td>{{ $sample['size'] }}</td>
                                                    <td>
                                                        <input type="number" 
                                                               class="form-control form-control-sm" 
                                                               wire:model.live="selectedSamples.{{ $sample['id'] }}.qty"
                                                               min="1" 
                                                               step="1"
                                                               style="width: 80px;">
                                                    </td>
                                                    <td>
                                                        @if($sample['do_not_charge'])
                                                            <span class="text-muted">DO NOT CHARGE</span>
                                                        @else
                                                            @php
                                                                $currentQty = $selectedSamples[$sample['id']]['qty'] ?? $sample['qty'];
                                                                $currentPrice = $sample['price'] * $currentQty;
                                                            @endphp
                                                            {{ $sample['currency'] }}{{ number_format($currentPrice, 2) }}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($sample['do_not_charge'])
                                                            <span class="text-muted">-</span>
                                                        @else
                                                            @php
                                                                $currentQty = $selectedSamples[$sample['id']]['qty'] ?? $sample['qty'];
                                                                $basePrice = $sample['price'] * $currentQty;
                                                                $discount = $sample['discount'] ?? 0;
                                                                $discountAmount = $discount > 0 ? $basePrice * ($discount / 100) : 0;
                                                            @endphp
                                                            @if($discount > 0)
                                                                {{ $discount }}%<br>
                                                                <small>-{{ $sample['currency'] }}{{ number_format($discountAmount, 2) }}</small>
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($sample['do_not_charge'])
                                                            <span class="text-muted">-</span>
                                                        @else
                                                            @php
                                                                $currentQty = $selectedSamples[$sample['id']]['qty'] ?? $sample['qty'];
                                                                $basePrice = $sample['price'] * $currentQty;
                                                                $surcharge = $sample['surcharge'] ?? 0;
                                                                $surchargeAmount = $surcharge > 0 ? $basePrice * ($surcharge / 100) : 0;
                                                            @endphp
                                                            @if($surcharge > 0)
                                                                {{ $surcharge }}%<br>
                                                                <small>+{{ $sample['currency'] }}{{ number_format($surchargeAmount, 2) }}</small>
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($sample['do_not_charge'])
                                                            <span class="text-muted">-</span>
                                                        @else
                                                            @php
                                                                $development = $sample['development'] ?? 0;
                                                            @endphp
                                                            @if($development > 0)
                                                                {{ $sample['currency'] }}{{ number_format($development, 2) }}
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($sample['do_not_charge'])
                                                            <span class="text-muted">-</span>
                                                        @else
                                                            @php
                                                                $category = $sample['category'] ?? '';
                                                                // For samples, only check category
                                                                // All samples are sent to UK, so VAT applies regardless of currency
                                                                $isChildrens = strtolower(trim($category)) === 'childrens';
                                                                $tax = !$isChildrens;
                                                            @endphp
                                                            @if($tax)
                                                                <span class="badge bg-success">20%</span>
                                                            @else
                                                                <span class="badge bg-secondary">No VAT</span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($sample['do_not_charge'])
                                                            <span class="text-muted">{{ $sample['currency'] }}0.00</span>
                                                        @else
                                                            @php
                                                                $currentQty = $selectedSamples[$sample['id']]['qty'] ?? $sample['qty'];
                                                                $basePrice = $sample['price'] * $currentQty;
                                                                $discount = $sample['discount'] ?? 0;
                                                                $surcharge = $sample['surcharge'] ?? 0;
                                                                $development = $sample['development'] ?? 0;
                                                                
                                                                $discountAmount = $discount > 0 ? $basePrice * ($discount / 100) : 0;
                                                                $surchargeAmount = $surcharge > 0 ? $basePrice * ($surcharge / 100) : 0;
                                                                $currentTotal = $basePrice - $discountAmount + $surchargeAmount + $development;
                                                            @endphp
                                                            {{ $sample['currency'] }}{{ number_format($currentTotal, 2) }}
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr class="table-primary">
                                            <th colspan="11">Total</th>
                                            <th>
                                                @if(!empty($invoiceData))
                                                    @php
                                                        $totalAmount = 0;
                                                        $currency = '£';
                                                        foreach($invoiceData as $group) {
                                                            foreach($group['samples'] as $sample) {
                                                                if(!$sample['do_not_charge']) {
                                                                    $currentQty = $selectedSamples[$sample['id']]['qty'] ?? $sample['qty'];
                                                                    $basePrice = $sample['price'] * $currentQty;
                                                                    $discount = $sample['discount'] ?? 0;
                                                                    $surcharge = $sample['surcharge'] ?? 0;
                                                                    $development = $sample['development'] ?? 0;
                                                                    
                                                                    $discountAmount = $discount > 0 ? $basePrice * ($discount / 100) : 0;
                                                                    $surchargeAmount = $surcharge > 0 ? $basePrice * ($surcharge / 100) : 0;
                                                                    $currentTotal = $basePrice - $discountAmount + $surchargeAmount + $development;
                                                                    
                                                                    $totalAmount += $currentTotal;
                                                                    $currency = $sample['currency'] ?? '£';
                                                                }
                                                            }
                                                        }
                                                    @endphp
                                                    {{ $currency }}{{ number_format($totalAmount, 2) }}
                                                @else
                                                    £0.00
                                                @endif
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button class="btn btn-primary" wire:click="generateInvoices" 
                                    wire:loading.attr="disabled" 
                                    wire:loading.class="opacity-50"
                                    @if(empty($customer)) disabled @endif>
                                <span wire:loading.remove>
                                    <i class="fas fa-file-invoice"></i>
                                    Generate Invoice{{ count($invoiceData) > 1 ? 's' : '' }}
                                </span>
                                <span wire:loading>
                                    <i class="fas fa-spinner fa-spin"></i>
                                    Generating...
                                </span>
                            </button>
                            
                            <button class="btn btn-outline-secondary" wire:click="refresh">
                                <i class="fas fa-refresh"></i>
                                Refresh
                            </button>
                        </div>
                    @endif
                @endif
            </div>
        </div>
    @endif

    <!-- Completion Modal -->
    @if($showCompletionModal)
        <div class="modal fade show d-block" 
             tabindex="-1" 
             style="background-color: rgba(0,0,0,0.5);"
             x-data="{ show: @entangle('showCompletionModal') }"
             x-show="show"
             x-init="if (show) { window.scrollTo({ top: 0, behavior: 'smooth' }); }">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            <i class="fas fa-check-circle text-success"></i>
                            Invoice Generation Complete
                        </h5>
                        <button type="button" class="btn-close" wire:click="$set('showCompletionModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ $completionMessage }}</p>
                        <div class="alert alert-success">
                            <strong>Invoice Numbers:</strong><br>
                            @foreach($createdInvoices as $invoice)
                                <span class="badge bg-success me-1">{{ $invoice }}</span>
                            @endforeach
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" wire:click="closeAndRefresh">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>


@script
    <script>
        $wire.on('open-zoho-oauth-popup', (params) => {
            const url = params.url || params[0]?.url;
            if (!url) {
                console.error('No URL provided for Zoho OAuth popup');
                return;
            }
            
            const popup = window.open(url, 'Zoho OAuth', 'width=600,height=600');

            const checkPopupClosed = setInterval(() => {
                if (popup && popup.closed) {
                    clearInterval(checkPopupClosed);
                    $wire.refresh();
                }
            }, 500);
        });
    </script>
@endscript
