<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Drop Lookup
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
        <x-slot:sub>
            <div class="row">
                <div class="col">
                    <div class="input-group">
                        <span class="input-group-text">PROD</span>
                        <input type="text" class="form-control" wire:model.live.debounce.300ms="prod">
                    </div>
                </div>
                <div class="col">
                    <div class="input-group">
                        <span class="input-group-text">Style</span>
                        <input type="text" class="form-control" wire:model.live.debounce.300ms="style">
                    </div>
                </div>
                <div class="col">
                    <div class="input-group">
                        <span class="input-group-text">RT Invoice No.</span>
                        <input type="text" class="form-control" wire:model.live.debounce.300ms="rt">
                    </div>
                </div>
            </div>
        </x-slot:sub>
    </x-title-bar>
    <div class="row mb-4">

    </div>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table table-bordered align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <th>PROD</th>
                        <th>Order</th>
                        <th>RTD</th>
                        <th>Customer Ref</th>
                        <th>Colourway</th>
                        <th>Truck No.</th>
                        <th>ExFty</th>
                        <th>RT Invoice No.</th>
                    </thead>
                    <tbody>
                        @foreach($shipmentLines as $sl=>$shipmentLine)
                            <tr @if($shipmentLine->complete) class="shipped" @endif>
                                <td>
                                    @foreach($shipmentLine->customer_order_lines->yarn_order_line_styles->unique('yarn_order_lines.yarn_order_id') ?? [] as $yoLine)
                                        <div x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-prod', {order: {{$yoLine->yarn_order_lines?->yarn_order_id}}})">
                                            {{$yoLine->yarn_order_lines?->yarn_order_id ?? ""}}
                                        </div>
                                    @endforeach
                                </td>
                                {{-- <td ">{{$shipmentLine->customer_order_lines->yarn_order_line_styles[0]->yarn_order_lines?->yarn_order_id ?? ""}}</td> --}}
                                <td>{{$shipmentLine->customer_order_lines->customer_orders->customer_po}}</td>
                                <td>{{$shipmentLine->customer_order_lines->colourways->style_versions->styles->designs_id}}</td>
                                <td>{{$shipmentLine->customer_order_lines->colourways->style_versions->styles->customer_ref}}</td>
                                <td>{{$shipmentLine->customer_order_lines->colourways->name}}</td>
                                <td>{{$shipmentLine->shipments?->id}}</td>
                                <td>{{$shipmentLine->exfty?->format('d-M-Y')}}</td>
                                <td>
                                    @foreach($shipmentLine->customer_order_lines->shipment_lines ?? [] as $line)
                                        {{$line->rt_invoice}} @if(!$loop->last) | @endif
                                    @endforeach
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <x-modal name="edit" title="Edit Order" size="modal-fullscreen">
		<x-slot:body>
				<livewire:production.yarn.yarn-orders-edit wire:key="edit-yarn-order">
		</x-slot:body>
	</x-modal>
</div>
