<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Wholesale Cashflow: {{$cashflow->name}}
        </x-slot:title>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        <h4>{{ Session::get('message') }}</h3>
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
                <div class="content mt-3">
                    <div class="row py-3">
                        <div class="col">
                            <ul class="list-group">
                                <li class="list-group-item"><b>Created At:</b> {{$cashflow->created_at->format('d-M-Y')}}</li>
                                <li class="list-group-item"><b>Locked:</b> {{$cashflow->locked == 1 ? 'Yes' : 'No'}}</li>
                            </ul>
                        </div>
                        <div class="col">
                            <ul class="list-group">
                                <li class="list-group-item"><b>Up To:</b> {{\Carbon\Carbon::parse($cashflow->data->exfty_date_to)->format('d-M-Y')}}</li>
                                <li class="list-group-item"><b>COO:</b> {{$cashflow->data->country}}</li>
                                <li class="list-group-item"><b>Factory:</b> {{$cashflow->data->factory}}</li>
                                <li class="list-group-item"><b>Category:</b> {{$cashflow->data->category}}</li>
                                <li class="list-group-item"><b>Customer:</b> {{$cashflow->data->customer}}</li>
                                <li class="list-group-item"><b>Department:</b> {{$cashflow->data->department}}</li>
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col">
                            <div id="wdr-component"></div>
                            <link href="https://cdn.webdatarocks.com/latest/webdatarocks.min.css" rel="stylesheet"/>
                            <script src="https://cdn.webdatarocks.com/latest/webdatarocks.toolbar.min.js"></script>
                            <script src="https://cdn.webdatarocks.com/latest/webdatarocks.js"></script>

                            <script>

                                var pivot = new WebDataRocks({
                                    container: "#wdr-component",
                                    height: 900,
                                    customizeCell: customizeCellFunction,
                                    toolbar: true,
                                    report: {!! json_encode($pivot) !!}
                                });

                                function customizeCellFunction(cellBuilder, cellData) {
                                    if (cellData.type == "value") {
                                        if (cellData.rowIndex % 2 == 0) {
                                            cellBuilder.addClass("bg-light");
                                        } else {
                                            cellBuilder.addClass("pivot-alternating-2");
                                        }
                                    }
                                }
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
