<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Wholesale Cashflow: {{$cashflow->name}}
        </x-slot:title>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        <h4>{{ Session::get('message') }}</h3>
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
                <div class="content mt-3">
                    <div class="row py-3">
                        <div class="col">
                            <ul class="list-group">
                                <li class="list-group-item"><b>Created At:</b> {{$cashflow->created_at->format('d-M-Y')}}</li>
                                <li class="list-group-item"><b>Locked:</b> {{$cashflow->locked == 1 ? 'Yes' : 'No'}}</li>
                                <li class="list-group-item"><b>Total Drops:</b> {{$cashflow->total_drops ?? 0}}</li>
                                <li class="list-group-item"><b>Total VAT:</b> £{{number_format($cashflow->total_vat ?? 0,2)}}</li>
                                <li class="list-group-item"><b>Total exVAT:</b> £{{number_format($cashflow->total_exvat ?? 0,2)}}</li>
                                <li class="list-group-item"><b>Total incVAT:</b> £{{number_format($cashflow->total_incvat ?? 0,2)}}</li>
                            </ul>
                        </div>
                        <div class="col">
                            <ul class="list-group">
                                <li class="list-group-item"><b>Up To:</b> {{\Carbon\Carbon::parse($cashflow->data['exfty_date_to'] ?? 0)->format('d-M-Y')}}</li>
                                <li class="list-group-item"><b>COO:</b> {{$cashflow->data['country'] ?? ""}}</li>
                                <li class="list-group-item"><b>Factory:</b> {{$cashflow->data['factory'] ?? ""}}</li>
                                <li class="list-group-item"><b>Category:</b> {{$cashflow->data['category'] ?? ""}}</li>
                                <li class="list-group-item"><b>Customer:</b> {{$cashflow->data['customer'] ?? ""}}</li>
                                <li class="list-group-item"><b>Department:</b> {{$cashflow->data['department'] ?? ""}}</li>
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col">
                            @php
                                // Build simple component inputs from existing $pivot
                                $pivotData = $pivot['dataSource']['data'] ?? [];
                                $pivotRows = array_map(function($r){ return $r['uniqueName']; }, $pivot['slice']['rows'] ?? []);
                                $pivotMeasures = $pivot['slice']['measures'] ?? [];
                                $pivotFormats = $pivot['formats'] ?? [];
                            @endphp
                            <x-pivot.simple-pivot :data="$pivotData" :rows="$pivotRows" :measures="$pivotMeasures" :formats="$pivotFormats" height="auto" :export-url="route('cashflow.exportPivot')" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
