<div>
	<div class="modal-body">
        @if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif
        <div class="content mt-3">
            <div class="row mb-3">
                <div class="col">
                    <div class="col-md">
                        <label for="cashflow_name">Cashflow Name</label>
                        <input type="text" class="form-control" wire:model="name">
                    </div>
                </div>
            </div>
            <hr>
            <div class="row pb-3">
                <div class="col">
                    <h3>Filters</h3>
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <label for="exfty_date_to">Exfty Date To</label>
                            <input type="date" class="form-control" wire:model="exfty_date_to">
                        </div>
                        <div class="col-md-3">
                            <label for="customer">Customer</label>
                            <select class="form-select" wire:model="customer_id">
                                <option value="">All Customers</option>
                                @foreach ($this->customers as $customer)
                                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="factory">Factory</label>
                            <select class="form-select" wire:model="factory_id">
                                <option value="">All Factories</option>
                                @foreach ($this->factories as $factory)
                                    <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <label for="country_of_origin">Country Of Origin</label>
                            <select class="form-select" wire:model="country_id">
                                <option value="">All Countries</option>
                                @foreach ($this->countries as $country)
                                    <option value="{{ $country->id }}">{{ $country->country }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="department">Department</label>
                            <select class="form-select" wire:model="department_id">
                                <option value="">All Departments</option>
                                @foreach ($this->departments as $department)
                                    <option value="{{ $department->id }}">{{ $department->description }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="category">Category</label>
                            <select class="form-select" wire:model="category_id">
                                <option value="">All Categories</option>
                                <option value="ladies">Ladies</option>
                                <option value="mens">Mens</option>
                                <option value="childrens">Childrens</option>
                                <option value="accessories">Accessories</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            {{-- @if($currentStep > 1)
                <button wire:click="previousStep()" class="btn btn-secondary">Previous</button>
            @endif
            @if($currentStep < 3 && $currentStep > 1)
                <button wire:click="nextStep()" class="btn btn-primary">Next</button>
            @endif
            @if($currentStep == 1)
                <button wire:click="nextStep()" class="btn btn-primary">Skip Data Refresh & Reset Filters</button>
            @endif --}}
            <button wire:click="refreshData()" class="btn btn-primary">Snapshot Data & Create</button>
        </div>
    </div>
</div>
