<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Wholesale Cashflow
        </x-slot:title>
        <x-slot:end>
            <button class="btn btn-primary" x-data x-on:click="$dispatch('open-modal', {name:'new'})">Create</button>
        </x-slot:end>
    </x-title-bar>

    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <th>Created</th>
                        <th>Name</th>
                        <th style="width: 160px"></th>
                    </thead>
                    <tbody>
                        @foreach ($cashflows as $cashflow)
                            <tr>
                                <th>{{$cashflow->created_at->format('d-M-y')}}</th>
                                <th>{{$cashflow->name}}</th>
                                <th>
                                    <div class="btn-group">
                                        <a class="btn btn-primary" href="cashflowpivot/{{$cashflow->id}}">Pivot</a>
                                        <button class="btn btn-danger"x-data x-on:click="$dispatch('open-modal', {name:'editdata'})" wire:click="$dispatch('edit-data', { cashflow: {{$cashflow->id}}})">Edit Data</button>
                                    </div>
                                </th>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <x-modal name="new" title="New Cashflow">
		<x-slot:body>
			<livewire:finance.cashflow.wh-cashflow-new>
		</x-slot:body>
	</x-modal>

    <x-modal name="editdata" title="Edit Data" size="modal-fullscreen">
		<x-slot:body>
			<livewire:finance.cashflow.wh-cashflow-edit-data>
		</x-slot:body>
	</x-modal>

    <x-footer>
        <x-slot:center>
            {{ $cashflows->links() }}
        </x-slot:center>
    </x-footer>
</div>
