<div>
    {{-- LIST FILTERS --}}

    <div style="overflow: scroll; height: calc(100vh - 62px)">
        {{-- LIST FILTERS --}}

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center">
                        <th>Shipment Line</th>
                        <th>Shipped?</th>
                        <th style="min-width: 150px">Season</th>
                        <th style="min-width: 150px">Customer</th>
                        <th style="min-width: 150px">Customer PO</th>
                        <th style="min-width: 150px">Customer Ref</th>
                        <th style="min-width: 150px">Factory</th>
                        <th>Colour</th>
                        <th>Incoterms</th>
                        <th style="min-width: 120px">Exfty</th>
                        <th>Qty</th>
                        <th>FF?</th>
                        <th style="min-width: 170px">CMT</th>
                        <th style="min-width: 60px">CMT Terms</th>
                        <th style="min-width: 170px">Yarn</th>
                        <th style="min-width: 60px">Yarn Terms</th>
                        <th style="min-width: 170px">Sale</th>
                        {{-- <th style="min-width: 60px">Sale Terms</th> --}}
                        <th style="min-width: 100px">VAT</th>
                        <th style="min-width: 80px">Factored</th>
                        <th style="min-width: 120px">CMT Base</th>
                        <th style="min-width: 120px">Yarn Base</th>
                        <th style="min-width: 120px">Sale Base</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $i => $item)
                        <tr @if($item['is_complete']) class="bg-light" @endif>
                            <td>{{ $item['shipment_lines_id'] }}</td>
                            <td>{{ $item['is_complete'] == 1 ? 'Y' : 'N' }}</td>
                            <td>{{ $this->seasons->where('id', $item['seasons_id'])->first()->description }}</td>
                            <td>{{ $this->customers->where('id', $item['customers_id'])->first()->name }}</td>
                            <td>{{ $item['customer_po'] }}</td>
                            <td><b>{{ $item['designs_id'] }}</b><br>{{ $item['customer_ref'] }}</td>
                            <td>{{ $this->factories->where('id', $item['suppliers_id'])->first()->name }}</td>
                            <td>{{ $item['colour'] }}</td>
                            <td>{{ $item['incoterms'] }}</td>
                            <td>
                                {{-- <input type="date" wire:model.blur="data.{{ $i }}.exfty" class="form-control"> --}}
                                {{ \Carbon\Carbon::parse($item['exfty'])->format('d-M-Y') }}
                            </td>
                            <td>{{ $item['qty'] ?? "" }}</td>
                            <td>{{ $item['is_full_factored'] == TRUE ? 'Y' : 'N' }}</td>
                            <td>
                                <div class="input-group">
                                    <select wire:model.blur="data.{{ $i }}.cmt_currency" class="form-select" style="max-width:60px">
                                        <option value="£">£</option>
                                        <option value="$">$</option>
                                        <option value="€">€</option>
                                    </select>
                                    <input type="number" wire:model.blur="data.{{ $i }}.cmt" class="form-control">
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="number" wire:model.blur="data.{{ $i }}.cmt_terms" class="form-control">
                                </div>
                            </td>
                            <td>
                                @if(!$item['is_full_factored'])
                                    <div class="input-group">
                                        <select wire:model.blur="data.{{ $i }}.yarn_currency" class="form-select" style="max-width:60px">
                                            <option value="£">£</option>
                                            <option value="$">$</option>
                                            <option value="€">€</option>
                                        </select>
                                        <input type="number" wire:model.blur="data.{{ $i }}.yarn" class="form-control">
                                    </div>
                                @endif
                            </td>
                            <td>
                                @if(!$item['is_full_factored'])
                                    <div class="input-group">
                                        <input type="number" wire:model.blur="data.{{ $i }}.yarn_terms" class="form-control">
                                    </div>
                                @endif
                            </td>
                            <td>
                                <div class="input-group">
                                    <select wire:model.blur="data.{{ $i }}.sale_currency" class="form-select" style="max-width:60px">
                                        <option value="£">£</option>
                                        <option value="$">$</option>
                                        <option value="€">€</option>
                                    </select>
                                    <input type="number" wire:model.blur="data.{{ $i }}.sale" class="form-control">
                                </div>
                            </td>
                            {{-- <td>
                                <div class="input-group">
                                    <input type="number" wire:model.blur="data.{{ $i }}.sale_terms" class="form-control">
                                </div>
                            </td> --}}
                            <td>
                                <input type="number" class="form-control" wire:model.blur="data.{{ $i }}.vat">
                            </td>
                            <td>
                                {{ $item['factored'] == 1 ? 'Y' : 'N' }}
                            </td>
                            <td>
                                £{{ number_format(Conversions::convertCurrency($item['cmt_currency'], "£", $item['cmt'], $this->seasons->where('id', $item['seasons_id'])->first()), 2) }}
                            </td>
                            <td>
                                @if(!$item['is_full_factored'])
                                    £{{ number_format(Conversions::convertCurrency($item['yarn_currency'], "£", $item['yarn'], $this->seasons->where('id', $item['seasons_id'])->first()), 2) }}
                                @endif
                            </td>
                            <td>
                                £{{ number_format(Conversions::convertCurrency($item['sale_currency'], "£", $item['sale'], $this->seasons->where('id', $item['seasons_id'])->first()), 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>




    </div>





</div>
