<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            NatWest Bank File Generator
        </x-slot:title>
        <x-slot:sub>
            Generate bank payment files for vendor payments from Zoho Books
        </x-slot:sub>
    </x-title-bar>

    <div class="container-fluid mt-4">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-file-export me-2"></i>Generate Bank File
                        </h5>
                    </div>
                    <div class="card-body">
                        @if(!$zohoConnected)
                            <div class="alert alert-warning d-flex align-items-center" role="alert">
                                <i class="fas fa-exclamation-triangle me-3 fs-4"></i>
                                <div>
                                    <strong>Not Connected to Zoho Books</strong>
                                    <p class="mb-0">You need to connect to Zoho Books to generate bank files.</p>
                                </div>
                            </div>
                            <div class="text-center">
                                <button wire:click="initiateZohoOAuth" class="btn btn-primary btn-lg">
                                    <i class="fas fa-link me-2"></i>Connect to Zoho Books
                                </button>
                            </div>
                        @else
                            @if($errorMessage)
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <i class="fas fa-exclamation-circle me-2"></i>
                                    {{ $errorMessage }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @endif

                            @if($successMessage)
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <i class="fas fa-check-circle me-2"></i>
                                    {{ $successMessage }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @endif

                            <form wire:submit.prevent="generateBankFile">
                                <div class="alert alert-warning mb-4">
                                    <strong><i class="fas fa-info-circle me-2"></i>Company Bank Details Required</strong>
                                    <p class="mb-0 small">Enter your company's bank account details below (these can be saved in .env for future use)</p>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-6 mb-3">
                                        <label for="debitSortCode" class="form-label fw-bold">
                                            <i class="fas fa-building me-2"></i>Your Company Sort Code
                                        </label>
                                        <input 
                                            type="text" 
                                            id="debitSortCode"
                                            class="form-control @error('debitSortCode') is-invalid @enderror" 
                                            wire:model="debitSortCode"
                                            placeholder="12-34-56"
                                            required
                                        >
                                        <div class="form-text">Format: XX-XX-XX (e.g., 60-10-00)</div>
                                        @error('debitSortCode')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="debitAccount" class="form-label fw-bold">
                                            <i class="fas fa-credit-card me-2"></i>Your Company Account Number
                                        </label>
                                        <input 
                                            type="text" 
                                            id="debitAccount"
                                            class="form-control @error('debitAccount') is-invalid @enderror" 
                                            wire:model="debitAccount"
                                            placeholder="12345678"
                                            required
                                        >
                                        <div class="form-text">8-digit account number</div>
                                        @error('debitAccount')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <div class="col-md-6 mb-3">
                                        <label for="fromDate" class="form-label fw-bold">
                                            <i class="fas fa-calendar-alt me-2"></i>From Date
                                        </label>
                                        <input 
                                            type="date" 
                                            id="fromDate"
                                            class="form-control @error('fromDate') is-invalid @enderror" 
                                            wire:model="fromDate"
                                            required
                                        >
                                        @error('fromDate')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="toDate" class="form-label fw-bold">
                                            <i class="fas fa-calendar-alt me-2"></i>To Date
                                        </label>
                                        <input 
                                            type="date" 
                                            id="toDate"
                                            class="form-control @error('toDate') is-invalid @enderror" 
                                            wire:model="toDate"
                                            required
                                        >
                                        @error('toDate')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Note:</strong> This will fetch vendor payments from Zoho Books for the selected date range and generate a CSV file with payment details.
                                </div>

                                <div class="d-grid gap-2">
                                    <button 
                                        type="submit" 
                                        class="btn btn-primary btn-lg"
                                        wire:loading.attr="disabled"
                                        wire:target="generateBankFile"
                                    >
                                        <span wire:loading.remove wire:target="generateBankFile">
                                            <i class="fas fa-download me-2"></i>Generate & Download File
                                        </span>
                                        <span wire:loading wire:target="generateBankFile">
                                            <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                            Processing...
                                        </span>
                                    </button>
                                </div>
                            </form>

                            <div class="mt-4 pt-4 border-top">
                                <h6 class="fw-bold mb-3">
                                    <i class="fas fa-question-circle me-2"></i>How it works:
                                </h6>
                                <ol class="mb-0">
                                    <li>Select the date range for vendor payments</li>
                                    <li>Click "Generate & Download File"</li>
                                    <li>The system will fetch vendor payments from Zoho Books</li>
                                    <li>Vendor details including Sort Code and Account Number will be retrieved</li>
                                    <li>A CSV file with payment details will be generated and downloaded</li>
                                </ol>
                                <div class="alert alert-light mt-3 mb-0">
                                    <strong>CSV Format - NatWest Standard Domestic Payment:</strong>
                                    <ul class="mb-0 small">
                                        <li><strong>T001:</strong> Record type (01 = standard domestic payment)</li>
                                        <li><strong>T010:</strong> Debit account (your company account)</li>
                                        <li><strong>T014:</strong> Payment amount (decimal format, e.g., 166.42)</li>
                                        <li><strong>T016:</strong> Date payment to arrive (DDMMYYYY)</li>
                                        <li><strong>T022:</strong> Beneficiary sort code</li>
                                        <li><strong>T028:</strong> Beneficiary account number</li>
                                        <li><strong>T030:</strong> Beneficiary name</li>
                                        <li><strong>T034:</strong> Payment reference</li>
                                    </ul>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                @if($zohoConnected)
                    <div class="card shadow-sm mt-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0">
                                <i class="fas fa-cog me-2"></i>Configuration
                            </h6>
                        </div>
                        <div class="card-body">
                            <dl class="row mb-0">
                                <dt class="col-sm-4">Organization ID:</dt>
                                <dd class="col-sm-8"><code>{{ $organizationId }}</code></dd>
                                
                                <dt class="col-sm-4">Zoho Connection:</dt>
                                <dd class="col-sm-8">
                                    <span class="badge bg-success">
                                        <i class="fas fa-check-circle me-1"></i>Connected
                                    </span>
                                </dd>

                                <dt class="col-sm-4">Debit Account:</dt>
                                <dd class="col-sm-8">
                                    @if($debitSortCode && $debitAccount)
                                        <code>{{ $debitSortCode }} - {{ $debitAccount }}</code>
                                    @else
                                        <span class="text-muted">Not configured</span>
                                    @endif
                                </dd>
                            </dl>
                            
                            <div class="alert alert-info mt-3 mb-0 small">
                                <strong>Tip:</strong> To avoid entering these details each time, add to your <code>.env</code> file:
                                <pre class="mb-0 mt-2">NATWEST_DEBIT_SORT_CODE=12-34-56
NATWEST_DEBIT_ACCOUNT=12345678</pre>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@script
    <script>
        window.addEventListener('open-zoho-oauth-popup', event => {
            const popup = window.open(event.detail.url, 'Zoho OAuth', 'width=600,height=600');

            const checkPopupClosed = setInterval(() => {
                if (popup && popup.closed) {
                    clearInterval(checkPopupClosed);
                    @this.refresh();
                }
            }, 500);
        });
    </script>
@endscript

