<div id="page-content">
	<x-title-bar>
        <x-slot:title>
            Styles
        </x-slot:title>
        <x-slot:end>
			@can('style:update')
				<button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'new'})" wire:click="$dispatch('new-style')">New</button>
				<button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'quickadd'})">Quick Add</button>
			@endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
				<div class="row mt-2 mx-1">
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="filters.season">
								<option selected value="">All</option>
								@foreach($this->seasons as $season)
									<option value="{{ $season->id }}">{{ $season->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Season:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="filters.department">
								<option selected value="">All</option>
								@foreach($this->departments as $department)
									<option value="{{ $department->id }}">{{ $department->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Department:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="filters.category">
								<option selected value="">All</option>
								<option selected value="ladies">Ladies</option>
								<option selected value="mens">Mens</option>
								<option selected value="childrens">Childrens</option>
								<option selected value="accessories">Accessories</option>

							</select>
							<label class="form-label">Category:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="filters.gauge">
								<option selected value="">All</option>
								@foreach($this->gauges as $gauge)
									<option value="{{ $gauge->id }}">{{ $gauge->gauge }}</option>
								@endforeach
							</select>
							<label class="form-label">Gauge:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="filters.customer">
								<option selected value="">All</option>
								@foreach($this->customers as $customer)
									<option value="{{ $customer->id }}">{{ $customer->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Customer:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="filters.factory">
								<option selected value="">All</option>
								@foreach($this->factories as $factory)
									<option value="{{ $factory->id }}">{{ $factory->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Factory:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="filters.paginate">
								<option selected value="10">10</option>
								<option selected value="50">50</option>
								<option selected value="100">100</option>
								<option selected value="200">200</option>
							</select>
							<label class="form-label">Per Page:</label>
						</div>
					</div>
				</div>
				<div class="row mx-1">
					<div class="col-12 mb-2 px-1">
						<div class="form-floating form-outline">
							<input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="filters.search">
							<label>Search</label>
							<div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
						</div>
					</div>
				</div>
            @endif
        </x-slot:sub>
    </x-title-bar>


    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
						<tr>
							<th>Image</th>
							<th>Season</th>
							<th>Customer</th>
							<th>Reference</th>
							<th>RT</th>
							<th>Description</th>
							<th>Colourways</th>
							<th style="width: 0" class="dont-print"></th>
						</tr>
					</thead>
					<tbody>
                        @foreach($styles as $style)
                            <tr>
                                <td>
                                    @if($style->firstImageColourway && !empty($style->firstImageColourway->img_thumb))
                                        <img src="{{ asset('storage/' . $style->firstImageColourway->img_thumb) }}" style="max-width: 100px;">
                                    @endif
                                </td>
                                <td>{{ $style->seasons->description }}</td>
                                <td>{{ $style->customers->name }}</td>
                                <td>{{ $style->customer_ref }}</td>
                                <td>{{ $style->designs->id }}</td>
                                <td>{{ $style->designs->description }}</td>
                                <td style="white-space: nowrap;">
                                    @foreach ($styleSummaries[$style->id]['visible'] as $cw)
                                        {{ sprintf('%05d', $cw['id']) }} |
                                        <b>{{ $cw['version'] }} - {{ $cw['name'] }}</b><br>
                                    @endforeach

                                    @if ($styleSummaries[$style->id]['remaining'] > 0)
                                        <em>
                                            + {{ $styleSummaries[$style->id]['remaining'] }} more colourway{{ $styleSummaries[$style->id]['remaining'] > 1 ? 's' : '' }}...
                                        </em>
                                    @endif
                                </td>
                                <td class="dont-print">
                                    <div class="btn-group">
                                        <button class="btn btn-secondary text-nowrap" 
                                                x-data 
                                                x-on:click="$dispatch('open-modal', {name:'edit-new'})" 
                                                wire:click="$dispatch('edit-style', {style: {{$style->id}}})">
                                            Edit
                                        </button>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                More
                                            </button>
                                            <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="#" x-data x-on:click="$dispatch('open-modal', {name:'clone'})" wire:click="$dispatch('clone-style', {style: {{$style->id}}})">Clone Style</a></li>
                                            <li><a class="dropdown-item" href="#" x-data x-on:click="$dispatch('open-modal', {name:'clone-colourways'})" wire:click="$dispatch('clone-colourways', {style: {{$style->id}}})">Clone Colours</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
					</tbody>
				</table>
			</div>
		</div>

	</div>
	<x-modal name="edit" title="Edit Style">
		<x-slot:body>
				<livewire:development.styles.style-edit wire:key="edit">
		</x-slot:body>
	</x-modal>
    <x-modal name="edit-new" title="Edit Style" size="modal-xl modal-style-edit">
        <x-slot:body>
                <livewire:development.styles.style-edit-new wire:key="edit-new">
        </x-slot:body>
    </x-modal>
	<x-modal name="clone" title="Clone Style">
		<x-slot:body>
				<livewire:development.styles.clone-style wire:key="clone">
		</x-slot:body>
	</x-modal>
	<x-modal name="clone-colourways" title="Clone Colourways">
		<x-slot:body>
				<livewire:development.styles.clone-colourways wire:key="clone-colourways">
		</x-slot:body>
	</x-modal>
	<x-modal name="new" title="New Style">
		<x-slot:body>
				<livewire:development.styles.style-edit wire:key="new">
		</x-slot:body>
	</x-modal>
    <x-modal name="quickadd" title="Quick Add Styles" size="modal-fullscreen">
		<x-slot:body>
            <livewire:development.styles.quick-add wire:key="quickadd">
		</x-slot:body>
	</x-modal>

	<x-footer>
        <x-slot:center>
            {{ $styles->links() }}
        </x-slot:center>
    </x-footer>

</div>
