<div>
    <div class="modal-body">
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h3>
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
            </div>
        @endif
        @if($style)
            <div>
                <hr>
                <h5>Style Information</h5>
                <hr>
                <div class="ms-5">
                    <form wire:submit="save">
                        <div class="row">
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Department</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                            <select class="form-select" wire:model="form.styleEdit.departments_id">
                                                <option value=""></option>
                                                @foreach($this->departments as $department)
                                                    <option value="{{$department->id}}">{{$department->description}}</option>
                                                @endforeach
                                            </select>
                                        @else
                                            {{$form->styleEdit['departments']['description'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                    <div class="row align-items-center" @if(Gate::check('style:update') &&  !$viewOnly) style="height: 37px" @endif>
                                        <div class="col-5">
                                            <h6 class="mb-0 fw-bold">Season</h6>
                                        </div>
                                        <div class="col-7">
                                            @if($new || (Gate::check('style:update') && !$this->form->styleOrigional->hasOrders))
                                                <select class="form-select" wire:model="form.styleEdit.seasons_id">
                                                    <option value=""></option>
                                                    @foreach($this->seasons as $season)
                                                        <option value="{{$season->id}}">{{$season->description}}</option>
                                                    @endforeach
                                                </select>
                                            @else
                                                {{$form->styleEdit['seasons']['description'] ?? ""}}
                                            @endif
                                        </div>
                                    </div>
                                    <hr>
                                <div class="row align-items-center" @if(Gate::check('style:update') &&  !$viewOnly) style="height: 37px" @endif>
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Todds #</h6>
                                    </div>
                                    <div class="col-7">
                                        @if($new || (Gate::check('style:update') && !$this->form->styleOrigional->hasOrders))
                                            <button class="btn btn-secondary" type="button" wire:click="$toggle('designsPicker')">
                                                {{$form->styleEdit['designs_id'] ?? ""}}
                                            </button>
                                            <ul class="dropdown-menu @if($designsPicker == 1) show @endif" style="
                                                position: absolute;
                                                inset: 0px auto auto 0px;
                                                transform: translate(0px, 0px) !important;
                                                background: #e9e9e9;
                                                width: calc(100% - 40px);
                                                padding: 20px;
                                                margin: 20px;">
                                                    <input type="text" class="form-control" wire:model.live="designs_search">
                                                    @foreach($this->designs() as $design)
                                                        <li class="py-2" style="cursor: pointer;" wire:click="setDesigns({{$design->id}})">
                                                            <b>{{$design->id}}</b> {{$design->description}}
                                                        </li>
                                                    @endforeach
                                                    <div class="col text-end">
                                                        <button class="btn btn-secondary" type="button" wire:click="$toggle('designsPicker')">Close</button>
                                                    </div>
                                            </ul>
                                        @else
                                            {{$form->styleEdit['designs_id'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center" @if(Gate::check('style:update') &&  !$viewOnly) style="height: 37px" @endif>
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Customer</h6>
                                    </div>
                                    <div class="col-7">
                                        @if($new || (Gate::check('style:update') && !$this->form->styleOrigional->hasOrders))
                                            <select class="form-select" wire:model="form.styleEdit.customers_id">
                                                <option value=""></option>
                                                @foreach($this->customers as $customer)
                                                    <option value="{{$customer->id}}">{{$customer->name}}</option>
                                                @endforeach
                                            </select>
                                        @else
                                            {{$form->styleEdit['customers']['name'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Category</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                        <select class="form-select" wire:model="form.styleEdit.category">
                                            <option value=""></option>
                                            <option value="ladies">Ladies</option>
                                            <option value="mens">Mens</option>
                                            <option value="childrens">Childrens</option>
                                            <option value="accessories">Accessories</option>
                                        </select>
                                        @else
                                            {{$form->styleEdit['category'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Intake</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') && !$viewOnly)
                                        <select class="form-select" wire:model="form.styleEdit.intake_id">
                                            <option value=""></option>
                                            @foreach($this->intakes ?? [] as $intake)
                                                <option value="{{$intake->id}}">{{$intake->description}}</option>
                                            @endforeach
                                        </select>
                                        @else
                                            {{$form->styleEdit['intake_id'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Customer #</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                            <input class="form-control" type="text" wire:model="form.styleEdit.customer_ref">
                                        @else
                                            {{$form->styleEdit['design']['description'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Description</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                            <input class="form-control" type="text" wire:model="form.styleEdit.designs.description">
                                        @else
                                            {{$form->styleEdit['design']['description'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Commodity</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                            <button class="btn btn-secondary" type="button" wire:click="$toggle('commodityPicker')">
                                                {{$form->styleEdit['commodity_codes_id'] ?? ""}}
                                            </button>
                                            <ul class="dropdown-menu @if($commodityPicker == 1) show @endif" style="
                                                position: absolute;
                                                inset: 0px auto auto 0px;
                                                transform: translate(0px, 0px) !important;
                                                background: #e9e9e9;
                                                width: calc(100% - 40px);
                                                padding: 20px;
                                                margin: 20px;">
                                                    <input type="text" class="form-control" wire:model.live="commodity_codes_search">
                                                    <div class="my-3" style="max-height: 550px; overflow: auto;">
                                                        @foreach($this->commodityCodes() as $commodityCode)
                                                            <li class="py-2" style="cursor: pointer;" wire:click="setCommodityCode({{$commodityCode->id}})">
                                                                <b>{{$commodityCode->id}}</b> {{$commodityCode->description}}
                                                            </li>
                                                        @endforeach
                                                    </div>
                                                    <div class="col text-end">
                                                        <button class="btn btn-secondary" type="button" wire:click="$toggle('commodityPicker')">Close</button>
                                                    </div>
                                            </ul>
                                        @else
                                            {{$form->styleEdit['commodity_codes_id'] ?? ""}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Cancelled</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                            <input type="checkbox" class="form-check-input" wire:model="form.styleEdit.cancelled">
                                        @else
                                            {{($form->styleEdit['cancelled']) ? "Yes" : "No"}}
                                        @endif
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h6 class="mb-0 fw-bold">Carryover</h6>
                                    </div>
                                    <div class="col-7">
                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                            <input type="checkbox" class="form-check-input" wire:model="form.styleEdit.carryover">
                                        @else
                                            {{($form->styleEdit['carryover']) ? "Yes" : "No"}}
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @if($image)
                                <div class="col-lg">
                                    <img class="img-fluid mx-auto d-block" style="max-height: 300px;"
                                        src="{{ url(asset('storage/' . $image ?? ""))}}">
                                </div>
                            @endif
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col">
                                @if(Gate::check('style:update') &&  !$viewOnly)
                                    <h6 class = "mb-0 fw-bold">Notes</h6>
                                    <textarea class = "form-control" wire:model = "form.styleEdit.notes"></textarea>
                                @else
                                    {{$form->styleEdit['notes']}}
                                @endif
                            </div>
                        </div>
                    </form>
                </div>
                <hr>
            </div>
            <div>
                <div class="row align-items-center">
                    <div class="col">
                        <h5 style="display: inline">Versions</h5>
                    </div>
                </div>
                <hr>
                <div class="accordion mb-3 ms-5" id="accodrionVersions">
                    @foreach($form->styleEdit['style_versions'] ?? [] as $v=>$version)
                        <div wire:key="version{{$v}}" wire:ignore.self="" class="accordion-item">
                            <h2 class="accordion-header" id="heading{{$v}}">
                                <button wire:ignore.self=""
                                    class="accordion-button @if(!$loop->first) collapsed @endif" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapseVersion{{$v}}" aria-expanded="false"
                                    aria-controls="collapseVersion{{$v}}">
                                    {{$version['name'] ?? ""}} @can('admin') ({{$version['id'] ?? ""}}) @endcan
                                </button>
                            </h2>
                            <div wire:ignore.self="" id="collapseVersion{{$v}}"
                                class="accordion-collapse collapse @if($loop->first) show @endif" aria-labelledby="headingTwo"
                                data-bs-parent="#accodrionVersions" style="">
                                <div class="accordion-body bg-white p-3">
                                    <div class="col">
                                        <div class="row">
                                            <div class="col-lg-4">
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Version Name</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <input class="form-control" type="text" wire:model="form.styleEdit.style_versions.{{$v}}.name">
                                                        @else
                                                            {{$version['name']}}
                                                        @endif
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">No. Yarn Ends</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <input class="form-control" type="text" wire:model="form.styleEdit.style_versions.{{$v}}.yarn_ends">
                                                        @else
                                                            {{$version['yarn_ends']}}
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Factory</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <select class="form-select" wire:model="form.styleEdit.style_versions.{{$v}}.factory_id">
                                                                <option value=""></option>
                                                                @foreach($this->factories as $factory)
                                                                    <option value="{{$factory->id}}">{{$factory->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        @else
                                                            {{$version['factories']['name']}}
                                                        @endif
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Issued</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <input class="form-control" type="date" wire:model="form.styleEdit.style_versions.{{$v}}.issued">
                                                        @else
                                                            {{$version['issued']}}
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Gauge</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                        <select class="form-select" wire:model="form.styleEdit.style_versions.{{$v}}.gauge_id">
                                                            <option value=""></option>
                                                            @foreach($this->gauges as $gauge)
                                                                <option value="{{$gauge->id}}">{{$gauge->gauge}}</option>
                                                            @endforeach
                                                        </select>
                                                        @else
                                                            {{$version['gauges']['gauge']}}
                                                        @endif
                                                    </div>
                                                </div>
                                                <hr>
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <button class="btn btn-primary float-end" wire:click="cloneVersion({{$v}})">Clone</button>
                                                            <button class="btn btn-danger float-end me-2" wire:click="removeStyleVersion({{$v}})" onclick="confirm('Are you sure you want to delete this version?') || event.stopImmediatePropagation()">Delete</button>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Sample Yarn</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <select class="form-select" wire:model="form.styleEdit.style_versions.{{$v}}.sample_yarn">
                                                                <option value="Not Ordered">Not Ordered</option>
                                                                <option value="Expected">Expected</option>
                                                                <option value="Arrived">Arrived</option>
                                                            </select>
                                                        @else
                                                            {{$version['sample_yarn']}}
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Expected:</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <input class="form-control" type="date" wire:model="form.styleEdit.style_versions.{{$v}}.sample_yarn_date">
                                                        @else
                                                            {{$version['sample_yarn_date']}}
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Sample Yarn</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <select class="form-select" wire:model="form.styleEdit.style_versions.{{$v}}.sample_accessories">
                                                                <option value="Not Ordered">Not Ordered</option>
                                                                <option value="Expected">Expected</option>
                                                                <option value="Arrived">Arrived</option>
                                                            </select>
                                                        @else
                                                            {{$version['sample_accessories']}}
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="col-5">
                                                        <h6 class="mb-0 fw-bold">Expected:</h6>
                                                    </div>
                                                    <div class="col-7">
                                                        @if(Gate::check('style:update') &&  !$viewOnly)
                                                            <input class="form-control" type="date" wire:model="form.styleEdit.style_versions.{{$v}}.sample_accessories_date">
                                                        @else
                                                            {{$version['sample_accessories_date']}}
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div>
                                                <h5>Colourways</h5>
                                                <hr>
                                                <div class="accordion mb-3 ms-0" id="accodrionColourways{{$v}}">
                                                    @foreach($version['colourways'] ?? [] as $c=>$colourway)
                                                        <div wire:key="colourwayV{{$v}}C{{$c}}" wire:ignore.self="" class="accordion-item">
                                                            <h2 class="accordion-header" id="heading{{$c}}">
                                                                <button wire:ignore.self=""
                                                                    class="accordion-button collapsed" type="button"
                                                                    data-bs-toggle="collapse" data-bs-target="#collapseV{{$v}}C{{$c}}" aria-expanded="false"
                                                                    aria-controls="collapseV{{$v}}C{{$c}}">
                                                                    {{$colourway['name'] ?? ""}} @can('admin') ({{$colourway['id'] ?? ""}}) @endcan
                                                                </button>
                                                            </h2>
                                                            <div wire:ignore.self="" id="collapseV{{$v}}C{{$c}}"
                                                                class="accordion-collapse collapse" aria-labelledby="headingTwo"
                                                                data-bs-parent="#accodrionColourways{{$v}}" style="">
                                                                <div class="accordion-body bg-white p-3">
                                                                    <div class="row">
                                                                        <div class="col">
                                                                            <div class="row">
                                                                                <div class="col-lg-4">
                                                                                    <div class="row">
                                                                                        <div class="col-5">
                                                                                            <h6 class="mb-0 fw-bold">Name</h6>
                                                                                        </div>
                                                                                        <div class="col-7">
                                                                                            @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                <input class="form-control" type="text" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.name">
                                                                                            @else
                                                                                                {{$colourway['name'] ?? ""}}
                                                                                            @endif
                                                                                        </div>
                                                                                    </div>
                                                                                    <hr>
                                                                                    <div class="row">
                                                                                        <div class="col-5">
                                                                                            <h6 class="mb-0 fw-bold">Customer Desc</h6>
                                                                                        </div>
                                                                                        <div class="col-7">
                                                                                            @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                <input class="form-control" type="text" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.customer_description">
                                                                                            @else
                                                                                                {{$colourway['name'] ?? ""}}
                                                                                            @endif
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-lg-4">
                                                                                    <div class="row">
                                                                                        <div class="col-5">
                                                                                            <h6 class="mb-0 fw-bold">Colour Type</h6>
                                                                                        </div>
                                                                                        <div class="col-7">
                                                                                            @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                <select class="form-select" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colour_type">
                                                                                                    <option value=""></option>
                                                                                                    <option value="solid">Solid</option>
                                                                                                    <option value="melange">Melange</option>
                                                                                                    <option value="mixed">Mixed</option>
                                                                                                </select>
                                                                                            @else
                                                                                                {{$colourway['colour_type'] ?? ""}}
                                                                                            @endif
                                                                                        </div>
                                                                                    </div>
                                                                                    <hr>
                                                                                    <div class="row">
                                                                                        <div class="col-5">
                                                                                            <h6 class="mb-0 fw-bold">Cancelled?</h6>
                                                                                        </div>
                                                                                        <div class="col-7">
                                                                                            @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                <input type="checkbox" class="form-check-input" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.cancelled">
                                                                                            @else
                                                                                                {{($colourway['cancelled']) ? "Yes" : "No"}}
                                                                                            @endif
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-lg-4">

                                                                                    <div class="row">
                                                                                        <div class="col-5">
                                                                                            <h6 class="mb-0 fw-bold">New Image</h6>
                                                                                        </div>
                                                                                        <div class="col-7">
                                                                                            <div class="row">
                                                                                                <div class="col">
                                                                                                    @if(Gate::check('style:update') && !$viewOnly)
                                                                                                        <input class="form-control" type="file" wire:model.live="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.new_image">
                                                                                                    @endif
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <hr>
                                                                                    <div class="row">
                                                                                        <div class="col-5">
                                                                                            <h6 class="mb-0 fw-bold">Thumbnail</h6>
                                                                                        </div>
                                                                                        <div class="col-7">
                                                                                            @if (!empty($colourway['new_image']))
                                                                                                <img class="img-thumbnail float-end" style="max-width: 100px" src="{{ $colourway['new_image']->temporaryUrl() }}">
                                                                                            @else
                                                                                                <img class="img-thumbnail float-end" style="max-width: 100px" src="@if(!empty($colourway['image'])){{ url(asset('storage/' . $colourway['image']))}}@endif">
                                                                                            @endif
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <hr>
                                                                            <div class="row">
                                                                                <div class="col">
                                                                                    <div class="row">
                                                                                        <div class="col">
                                                                                            <h6 class="mb-0 fw-bold">Notes</h6>
                                                                                            @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                            <textarea class="form-control" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.comments"></textarea>
                                                                                                {{-- <input class="form-control" type="text" wire:model="form.colourways.{{$c}}.comments"> --}}
                                                                                            @else
                                                                                                {{$colourway['comments'] ?? ""}}
                                                                                            @endif
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col">
                                                                                    <div class="row">
                                                                                        <div class="col">
                                                                                            <h6 class="mb-0 fw-bold">Accessories</h6>
                                                                                            @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                            <textarea class="form-control" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.accessories"></textarea>
                                                                                            @else
                                                                                                {{$colourway['accessories'] ?? ""}}
                                                                                            @endif
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <hr>
                                                                    <div class="row">
                                                                        <div class="col-12">
                                                                            <div class="table-responsive">
                                                                                <table class="table text-center">
                                                                                    <thead>
                                                                                        <tr>
                                                                                            <th style="min-width: 100px;">Spinner</th>
                                                                                            <th style="min-width: 100px;">Yarn</th>
                                                                                            <th style="min-width: 100px;">Colour</th>
                                                                                            <th>Customer #</th>
                                                                                            <th>Price</th>
                                                                                            <th>%</th>
                                                                                            <th style="width: 80px">Inc FFP</th>
                                                                                            <th style="width: 120px"></th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        @foreach($colourway['colourway_yarns'] ?? [] as $y=>$colourway_yarn)
                                                                                            <tr wire:key="yarn{{$c}}-{{ $y }}">
                                                                                                <td>
                                                                                                    {{-- {{$colourway_yarn['id'] ?? ""}} --}}
                                                                                                    @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                        <select class="form-select" wire:model.live="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.suppliers_id">
                                                                                                            <option value=""></option>
                                                                                                            @foreach($this->spinners as $spinner)
                                                                                                                <option value="{{$spinner->id}}">{{$spinner->name}}</option>
                                                                                                            @endforeach
                                                                                                        </select>
                                                                                                        {{-- {{$colourway_yarn['yarn_colours']['yarn']['suppliers_id']}} --}}
                                                                                                    @else
                                                                                                        {{$colourway_yarn['yarn_colours']['yarn']['suppliers']['name'] ?? ""}}
                                                                                                    @endif
                                                                                                </td>
                                                                                                <td>
                                                                                                    @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                        <select class="form-select" wire:model.live="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.yarn_id">
                                                                                                            <option value=""></option>
                                                                                                            @foreach($this->yarns->where('suppliers_id', $colourway_yarn['suppliers_id'] ?? "") as $yarn)
                                                                                                                <option value="{{$yarn->id}}">{{$yarn->description}} {{$yarn->count}}</option>
                                                                                                            @endforeach
                                                                                                        </select>
                                                                                                        {{-- <select
                                                                                                            class="js-example-basic-single"
                                                                                                            wire:ignore
                                                                                                            data-property="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.yarn_id"
                                                                                                        >
                                                                                                            <option value=""></option>
                                                                                                            @foreach($this->yarns->where('suppliers_id', $colourway_yarn['suppliers_id'] ?? "") as $yarn)
                                                                                                                <option
                                                                                                                    value="{{$yarn->id}}"
                                                                                                                    @if(($colourway_yarn['yarn_id'] ?? '') == $yarn->id) selected @endif
                                                                                                                >
                                                                                                                    {{$yarn->reference}} {{$yarn->description}} {{$yarn->count}}
                                                                                                                </option>
                                                                                                            @endforeach
                                                                                                        </select> --}}
                                                                                                        @else
                                                                                                        {{$colourway_yarn['yarn_colours']['yarn']['description'] ?? ""}}
                                                                                                    @endif
                                                                                                </td>
                                                                                                <td>
                                                                                                    @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                        @can('admin')
                                                                                                            <select
                                                                                                                id="blabla"
                                                                                                                class="js-example-basic-single w-100"
                                                                                                                data-property="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.yarn_colours_id"
                                                                                                                wire:model.live="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.yarn_colours_id"
                                                                                                            >
                                                                                                                <option value=""></option>
                                                                                                                @foreach($this->colours->where('yarn_id', $colourway_yarn['yarn_id'] ?? "") as $colour)
                                                                                                                    <option
                                                                                                                        value="{{$colour->id}}"
                                                                                                                        @if(($colourway_yarn['yarn_colours_id'] ?? '') == $colour->id) selected @endif
                                                                                                                    >
                                                                                                                        {{$colour->reference}} {{$colour->description}}
                                                                                                                    </option>
                                                                                                                @endforeach
                                                                                                            </select>
                                                                                                        @endcan
                                                                                                        <select class="form-select" wire:model.live="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.yarn_colours_id">
                                                                                                            <option value=""></option>
                                                                                                            @foreach($this->colours->where('yarn_id', $colourway_yarn['yarn_id'] ?? "") as $colour)
                                                                                                                <option value="{{$colour->id}}">{{$colour->reference}} {{$colour->description}}</option>
                                                                                                            @endforeach
                                                                                                        </select>
                                                                                                   @else
                                                                                                        {{$colourway_yarn['yarn_colours']['reference'] ?? ""}} |
                                                                                                        {{$colourway_yarn['yarn_colours']['description'] ?? ""}}
                                                                                                    @endif
                                                                                                </td>
                                                                                                <td>
                                                                                                    @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                                        <input class="form-control" type="text" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.cust_ref">
                                                                                                    @else
                                                                                                        {{$colourway_yarn['cust_ref'] ?? ""}}
                                                                                                    @endif
                                                                                                </td>
                                                                                                <td>
                                                                                                    @if(Gate::check('price:update') &&  !$viewOnly)
                                                                                                        <input class="form-control" type="text" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.price">
                                                                                                    @else
                                                                                                        {{$colourway_yarn['price'] ?? ""}}
                                                                                                    @endif
                                                                                                </td>
                                                                                                <td>
                                                                                                    @if(Gate::check('price:update') &&  !$viewOnly)
                                                                                                        <input class="form-control" type="text" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.percentage">
                                                                                                    @else
                                                                                                        {{$colourway_yarn['percentage'] ?? ""}}
                                                                                                    @endif
                                                                                                </td>
                                                                                                <td>
                                                                                                    @if(Gate::check('price:update') &&  !$viewOnly)
                                                                                                        <select class="form-select" wire:model="form.styleEdit.style_versions.{{$v}}.colourways.{{$c}}.colourway_yarns.{{$y}}.not_full_factored">
                                                                                                            <option value="1">Y</option>
                                                                                                            <option value="0">N</option>
                                                                                                        </select>
                                                                                                    @else
                                                                                                        {{$colourway_yarn['not_full_factored'] ?? 0 ? "Y" : "N"}}
                                                                                                    @endif
                                                                                                </td>
                                                                                                <td>
                                                                                                    <button class="btn btn-primary" wire:click="cloneYarn({{$v}}, {{$c}}, {{$y}})">Clone</button>
                                                                                                    <button class="btn btn-danger" wire:click="removeYarn({{$v}}, {{$c}}, {{$y}})" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">X</button>
                                                                                                </td>
                                                                                            </tr>
                                                                                        @endforeach
                                                                                    </tbody>
                                                                                </table>
                                                                                @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                    <button class="btn btn-primary float-end" wire:click="addYarn({{$v}},{{$c}})">Add Yarn</button>
                                                                                @endif
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col mt-3">
                                                                            @if(Gate::check('style:update') &&  !$viewOnly)
                                                                                <button class="btn btn-primary float-end" wire:click="cloneColourway({{$v}}, {{$c}}, {{$colourway['id'] ?? ""}})">Clone Colourway</button>
                                                                                <button class="btn btn-danger float-end" wire:click="removeColourway({{$v}}, {{$c}}, {{$colourway['id'] ?? ""}})" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Delete Colourway</button>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                    @if(Gate::check('style:update') &&  !$viewOnly)
                                                        <button class="btn btn-primary float-end m-2" wire:click="addColourway({{$v}})">Add Colourway</button>
                                                    @endif
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

    </div>
    <div class="modal-footer" wire:loading.class="opacity-25">
        @if(Gate::check('style:update') &&  !$viewOnly)
            <button class="btn btn-primary"  wire:click="addVersion">Add Version</button>
            <button class="btn btn-primary"  wire:click="save">Save</button>
            <button class="btn btn-danger"  wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
        @else
            <button class="btn btn-primary"  wire:click="$dispatch('close-modal')">Close</button>
        @endif
    </div>
</div>
@push('script-head')
{{-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" /> --}}
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    {{-- <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> --}}
@endpush
@once
<script>
    document.addEventListener('livewire:load', function () {
        initializeSelect2();
    });

    // After each Livewire update, re-initialize Select2
    Livewire.hook('message.processed', (message, component) => {
        // Only re-initialize if not already initialized
        if (!$('.js-example-basic-single').data('select2')) {
            initializeSelect2();
        }
    });

    document.addEventListener('livewire:load', function () {
        initializeSelect2();
    });

    function initializeSelect2() {
        $('.js-example-basic-single').select2({
            theme: 'bootstrap-5'
        });
    }
    $('.js-example-basic-single').on('change', function (e) {
        @this.call('updateProperty', $(this).val());
    });

</script>
@endonce
