<div class="style-edit-container">
    <div class="container-fluid p-0 h-100">


        @if ($form)
        <div x-data="unsavedChanges()" x-init="init()" @saved.window="dirty = false" class="container-fluid d-flex flex-column h-100 overflow-hidden">
            <div class="row flex-grow-1 overflow-hidden">
                <div class="col-auto bg-light p-3 overflow-auto style-sidebar" style="width: 280px; min-width: 280px;">
                    {{-- Style Info Section --}}
                    <div class="sidebar-section">
                        <div class="sidebar-section-title">Style Information</div>
                        <div class="form-floating">
                            <select class="form-select" id="departmentSelect" wire:model="form.departments_id"
                                @if($viewOnly) disabled @endif>
                                <option value=""></option>
                                @foreach($this->departments as $department)
                                    <option value="{{$department->id}}">{{$department->description}}</option>
                                @endforeach
                            </select>
                            <label for="departmentSelect">Department</label>
                        </div>
                        <div class="form-floating mt-2">
                            <select class="form-select" id="seasonsSelect" wire:model="form.seasons_id"
                                @if($viewOnly) disabled @endif>
                                <option value=""></option>
                                @foreach($this->seasons as $season)
                                    <option value="{{$season->id}}">{{$season->description}}</option>
                                @endforeach
                            </select>
                            <label for="seasonsSelect">Season</label>
                        </div>
                        <div class="form-floating mt-2">
                            @if($new || (!$viewOnly && 1)) {{-- MUST ADD !$this->form->styleOrigional->hasOrders --}}
                                <input type="text" class="form-control" id="rtNo"
                                    value="{{$form->designs_id ?? ''}}"
                                    readonly
                                    style="cursor: pointer; background: #fff;"
                                    wire:click="$toggle('designsPicker')">
                                <label for="rtNo">RT No.</label>
                                
                                {{-- RT No. Picker --}}
                                @if($designsPicker)
                                <div class="commodity-picker-overlay" wire:click.self="$toggle('designsPicker')">
                                    <div class="commodity-picker-modal" style="max-width: 500px;">
                                        <div class="commodity-picker-header">
                                            <h5 class="mb-0">Select Design</h5>
                                            <button type="button" class="btn-close" wire:click="$toggle('designsPicker')"></button>
                                        </div>
                                        <div class="commodity-picker-search">
                                            <input type="text" class="form-control form-control-lg" 
                                                wire:model.live.debounce.150ms="designs_search" 
                                                placeholder="Search designs..."
                                                autofocus>
                                        </div>
                                        <div class="commodity-picker-body" style="max-height: 400px;">
                                            @foreach($this->designs as $design)
                                                <div class="design-row p-2 border-bottom" 
                                                    style="cursor: pointer;" 
                                                    wire:click="setDesigns({{$design->id}})">
                                                    <strong class="text-primary">{{$design->id}}</strong>
                                                    <span class="ms-2">{{$design->description}}</span>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div class="commodity-picker-footer">
                                            <span class="text-muted small">{{count($this->designs)}} designs</span>
                                            <button type="button" class="btn btn-outline-secondary" wire:click="$toggle('designsPicker')">Cancel</button>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            @else
                                <input type="text" class="form-control" id="rtNo"
                                    value="{{$form->designs_id ?? ""}}"
                                    disabled>
                                <label for="rtNo">RT No.</label>
                            @endif
                        </div>
                    </div>
                    
                    {{-- Customer Section --}}
                    <div class="sidebar-section">
                        <div class="sidebar-section-title">Customer Details</div>
                        <div class="form-floating">
                            <select class="form-select" id="customersSelect" wire:model="form.customers_id"
                                @if($new || ($viewOnly && 1)) disabled @endif>
                                <option value=""></option>
                                @foreach($this->customers as $customer)
                                    <option value="{{$customer->id}}">{{$customer->name}}</option>
                                @endforeach
                            </select>
                            <label for="customersSelect">Customer</label>
                        </div>
                        <div class="form-floating mt-2">
                            <input class="form-control" type="text" id="customerRef" wire:model="form.customer_ref"
                                @if($viewOnly) disabled @endif>
                            <label for="customerRef">Customer #</label>
                        </div>
                        <div class="form-floating mt-2">
                            <select class="form-select" id="categorySelect" wire:model="form.category"
                                @if($viewOnly) disabled @endif>
                                <option value=""></option>
                                <option value="ladies">Ladies</option>
                                <option value="mens">Mens</option>
                                <option value="childrens">Childrens</option>
                                <option value="accessories">Accessories</option>
                            </select>
                            <label for="categorySelect">Category</label>
                        </div>
                        <div class="form-floating mt-2">
                            <input class="form-control" type="text" id="designDescription" wire:model="form.description"
                                @if($viewOnly) disabled @endif>
                            <label for="designDescription">Description</label>
                        </div>
                    </div>
                    {{-- Classification Section --}}
                    <div class="sidebar-section">
                        <div class="sidebar-section-title">Classification</div>
                        @if(!$viewOnly)
                            <div class="form-floating">
                                <input type="text" class="form-control" id="commodityCodeDisplay"
                                    value="{{$form->commodity_codes_id ?? ''}}"
                                    readonly
                                    style="cursor: pointer; background: #fff;"
                                    wire:click="$toggle('commodityPicker')">
                                <label for="commodityCodeDisplay">Commodity Code</label>
                            </div>
                            
                            {{-- Commodity Code Picker Modal --}}
                            @if($commodityPicker)
                                    <div class="commodity-picker-overlay" wire:click.self="$toggle('commodityPicker')">
                                        <div class="commodity-picker-modal">
                                            <div class="commodity-picker-header">
                                                <h5 class="mb-0">Select Commodity Code</h5>
                                                <button type="button" class="btn-close" wire:click="$toggle('commodityPicker')"></button>
                                            </div>
                                            <div class="commodity-picker-search">
                                                <input type="text" 
                                                    class="form-control form-control-lg" 
                                                    wire:model.live.debounce.150ms="commodity_search" 
                                                    placeholder="Search by code, type, gender, composition..."
                                                    autofocus>
                                            </div>
                                            <div class="commodity-picker-body">
                                                <table class="table table-hover mb-0">
                                                    <thead class="sticky-top bg-white">
                                                        <tr>
                                                            <th style="width: 120px;">Code</th>
                                                            <th style="width: 130px;">Gender</th>
                                                            <th style="width: 180px;">Type</th>
                                                            <th style="width: 150px;">Composition</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($form->commodity_codes_id && $selectedCommodityCode = $this->commodityCodes->firstWhere('id', $form->commodity_codes_id))
                                                            <tr class="commodity-row selected-row" 
                                                                wire:click="setCommodityCode({{$selectedCommodityCode->id}})"
                                                                style="cursor: pointer;">
                                                                <td class="fw-bold text-primary">
                                                                    <i class="bi bi-check-circle-fill text-success me-1"></i>
                                                                    {{$selectedCommodityCode->id}}
                                                                </td>
                                                                <td>{{$selectedCommodityCode->Gender ?? '-'}}</td>
                                                                <td>{{$selectedCommodityCode->Type ?? '-'}}</td>
                                                                <td>{{$selectedCommodityCode->Composition ?? '-'}}</td>
                                                            </tr>
                                                            <tr class="divider-row"><td colspan="4"></td></tr>
                                                        @endif
                                                        @forelse($this->commodityCodes->reject(fn($c) => $c->id == $form->commodity_codes_id) as $commodityCode)
                                                            <tr class="commodity-row" 
                                                                wire:click="setCommodityCode({{$commodityCode->id}})"
                                                                style="cursor: pointer;">
                                                                <td class="fw-bold text-primary">{{$commodityCode->id}}</td>
                                                                <td>{{$commodityCode->Gender ?? '-'}}</td>
                                                                <td>{{$commodityCode->Type ?? '-'}}</td>
                                                                <td>{{$commodityCode->Composition ?? '-'}}</td>
                                                            </tr>
                                                        @empty
                                                            <tr>
                                                                <td colspan="4" class="text-center text-muted py-4">No commodity codes found</td>
                                                            </tr>
                                                        @endforelse
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="commodity-picker-footer">
                                                <span class="text-muted small">{{count($this->commodityCodes)}} results</span>
                                                <button type="button" class="btn btn-outline-secondary" wire:click="$toggle('commodityPicker')">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                        @else
                            <div class="form-floating">
                                <input type="text" class="form-control" id="commodityNo"
                                    value="{{$form->commodity_codes_id ?? ""}}"
                                    disabled>
                                <label for="commodityNo">Commodity Code</label>
                            </div>
                        @endif
                        <div class="form-floating mt-2">
                            <select class="form-select" id="intakeSelect" wire:model="form.intake_id"
                                @if($viewOnly) disabled @endif>
                                <option value=""></option>
                                @foreach($this->intakes ?? [] as $intake)
                                    <option value="{{$intake->id}}">{{$intake->description}}</option>
                                @endforeach
                            </select>
                            <label for="intakeSelect">Intake</label>
                        </div>
                    </div>
                    
                    {{-- Status Section --}}
                    <div class="sidebar-section">
                        <div class="sidebar-section-title">Status</div>
                        <div class="d-flex gap-3">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="cancelledCheck" wire:model="form.cancelled"
                                    @if($viewOnly) disabled @endif>
                                <label class="form-check-label" for="cancelledCheck">Cancelled</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="carryoverCheck" wire:model="form.carryover"
                                    @if($viewOnly) disabled @endif>
                                <label class="form-check-label" for="carryoverCheck">Carryover</label>
                            </div>
                        </div>
                    </div>
                    
                    {{-- Notes Section --}}
                    <div class="sidebar-section">
                        <div class="sidebar-section-title">Notes</div>
                        <textarea style="height: 80px" class="form-control" id="notesArea" wire:model="form.notes"
                            placeholder="Add notes..."
                            @if($viewOnly) disabled @endif></textarea>
                    </div>
                </div>
                @if($commissionView)
                    <div class="col p-0 border-start overflow-auto">
                        <div class="card border-0">
                            <div class="p-3">
                                @foreach($form->style_versions ?? [] as $v => $version)
                                    <table class="table table-sm align-middle mb-0">
                                        <thead class="table-secondary">
                                            <tr>
                                                <th class="w-100 p-2">
                                                    <div class="input-group">
                                                        <input type="text"
                                                            class="form-control"
                                                            style="background-color: transparent; color: #fff;"
                                                            wire:model="form.style_versions.{{ $selectedVersion }}.name">
                                                        <button class="btn btn-danger border-white border-start-0"
                                                            wire:click="removeVersion({{ $v }})"
                                                            onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </th>
                                                <th class="text-center p-2" style="width: 100px;">Cancelled</th>
                                                <th class="text-end p-2" style="width: 80px;">
                                                    <button class="btn btn-primary" wire:click="addColourway({{ $selectedVersion }})">
                                                        <i class="fas fa-add"></i>
                                                    </button>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($version['colourways'] ?? [] as $c => $colourway)
                                                <tr wire:key="cw-row-{{ $c }}">
                                                    <td class="px-2">
                                                        <input type="text"
                                                            class="form-control"
                                                            wire:model="form.style_versions.{{ $v }}.colourways.{{ $c }}.name">
                                                    </td>
                                                    <td class="text-center px-2">
                                                        <input type="checkbox"
                                                            class="form-check-input"
                                                            wire:model="form.style_versions.{{ $v }}.colourways.{{ $c }}.cancelled">
                                                    </td>
                                                    <td class="text-end px-2">
                                                        <button class="btn btn-danger"
                                                            wire:click="removeColourway({{ $v }}, {{ $c }}, {{ $colourway['id'] ?? 'null' }})"
                                                            onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                @endforeach
                                <button class="btn btn-primary mt-3" wire:click="addVersion">
                                    <i class="fas fa-plus"></i> Add Version
                                </button>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="col p-0 border-start overflow-auto">
                        <div class="card border-0 h-100 d-flex flex-column">
                            <!-- Version Tabs -->
                            <div class="version-tabs-container border-bottom bg-light">
                                <ul class="nav nav-tabs border-0">
                                    @foreach($form->style_versions ?? [] as $v=>$version)
                                        @if(!empty($version) && is_array($version))
                                        <li class="nav-item">
                                            <a role="button" class="nav-link @if($v == $selectedVersion) active bg-white @endif" 
                                               wire:click="$set('selectedVersion', {{$v}})">
                                                {{$version['name'] ?? 'Version '.($v+1)}}
                                            </a>
                                        </li>
                                        @endif
                                    @endforeach
                                    @if(!$viewOnly)
                                    <li class="nav-item">
                                        <a role="button" class="nav-link text-primary" wire:click="addVersion" title="Add Version">
                                            <i class="fas fa-plus"></i>
                                        </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                            
                            {{-- Empty State: No Versions --}}
                            @if(empty($form->style_versions) || count(array_filter($form->style_versions ?? [])) === 0)
                                <div class="d-flex flex-column align-items-center justify-content-center flex-grow-1 p-5 text-center">
                                    <div class="empty-state-icon mb-3">
                                        <i class="fas fa-layer-group fa-3x text-muted"></i>
                                    </div>
                                    <h5 class="text-muted mb-2">No Versions</h5>
                                    <p class="text-muted mb-4">This style doesn't have any versions yet.<br>Create a version to add factory details and colourways.</p>
                                    @if(!$viewOnly)
                                        <button class="btn btn-primary btn-lg" wire:click="addVersion">
                                            <i class="fas fa-plus me-2"></i> Create Version
                                        </button>
                                    @endif
                                </div>
                            @else
                            <!-- Content Box -->
                            <div class="p-4" wire:key="version.{{$selectedVersion}}">
                                <div class="row g-3 mb-4">
                                    <div class="col-auto">
                                        <div class="input-group mt-2" style="width: 200px;">
                                            <div class="form-floating flex-grow-1">
                                                <input class="form-control" type="text" id="versionName"
                                                    wire:model="form.style_versions.{{$selectedVersion}}.name"
                                                    @if($viewOnly) disabled @endif>
                                                <label for="versionName">Version</label>
                                            </div>
                                            @if(Gate::check('style:update') && !$viewOnly)
                                            <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end">
                                                <li>
                                                    <a class="dropdown-item" href="#" wire:click.prevent="cloneVersion({{$selectedVersion}})">
                                                        <i class="fas fa-clone me-2 text-primary"></i> Clone Version
                                                    </a>
                                                </li>
                                                <li><hr class="dropdown-divider"></li>
                                                <li>
                                                    <a class="dropdown-item text-danger" href="#" 
                                                       wire:click.prevent="removeVersion({{$selectedVersion}})"
                                                       onclick="confirm('Are you sure you want to delete this version?') || event.stopImmediatePropagation()">
                                                        <i class="fas fa-trash me-2"></i> Delete Version
                                                    </a>
                                                </li>
                                            </ul>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-floating mt-2">
                                            <input class="form-control" type="text" id="yarnEnds"
                                                wire:model="form.style_versions.{{$selectedVersion}}.yarn_ends"
                                                @if($viewOnly) disabled @endif>
                                            <label for="yarnEnds">No. Yarn Ends</label>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-floating mt-2">
                                            <select class="form-select" id="factorySelect"
                                                wire:model="form.style_versions.{{$selectedVersion}}.factory_id"
                                                @if($viewOnly) disabled @endif>
                                                <option value=""></option>
                                                @foreach($this->factories as $factory)
                                                    <option value="{{$factory->id}}">{{$factory->name}}</option>
                                                @endforeach
                                            </select>
                                            <label for="factorySelect">Factory</label>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-floating mt-2">
                                            <input class="form-control" type="date" id="issuedDate"
                                                wire:model="form.style_versions.{{$selectedVersion}}.issued"
                                                @if($viewOnly) disabled @endif>
                                            <label for="issuedDate">Issued</label>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-floating mt-2">
                                            <select class="form-select" id="gaugeSelect"
                                                wire:model="form.style_versions.{{$selectedVersion}}.gauge_id"
                                                @if($viewOnly) disabled @endif>
                                                <option value=""></option>
                                                @foreach($this->gauges as $gauge)
                                                    <option value="{{$gauge->id}}">{{$gauge->gauge}}</option>
                                                @endforeach
                                            </select>
                                            <label for="gaugeSelect">Gauge</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-3 mb-4">
                                    <div class="col">
                                        <div class="form-floating">
                                            <select class="form-select" id="sampleYarnSelect"
                                                wire:model="form.style_versions.{{$selectedVersion}}.sample_yarn"
                                                @if($viewOnly) disabled @endif>
                                                <option value="Not Ordered">Not Ordered</option>
                                                <option value="Expected">Expected</option>
                                                <option value="Arrived">Arrived</option>
                                            </select>
                                            <label for="sampleYarnSelect">Sample Yarn</label>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-floating">
                                            <input class="form-control" type="date" id="sampleYarnDate"
                                                wire:model="form.style_versions.{{$selectedVersion}}.sample_yarn_date"
                                                @if($viewOnly) disabled @endif>
                                            <label for="sampleYarnDate">Expected (Sample Yarn)</label>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-floating">
                                            <select class="form-select" id="sampleAccessoriesSelect"
                                                wire:model="form.style_versions.{{$selectedVersion}}.sample_accessories"
                                                @if($viewOnly) disabled @endif>
                                                <option value="Not Ordered">Not Ordered</option>
                                                <option value="Expected">Expected</option>
                                                <option value="Arrived">Arrived</option>
                                            </select>
                                            <label for="sampleAccessoriesSelect">Sample Accessories</label>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-floating">
                                            <input class="form-control" type="date" id="sampleAccessoriesDate"
                                                wire:model="form.style_versions.{{$selectedVersion}}.sample_accessories_date"
                                                @if($viewOnly) disabled @endif>
                                            <label for="sampleAccessoriesDate">Expected (Sample Accessories)</label>
                                        </div>
                                    </div>
                                </div>
                                {{-- Colourways Section --}}
                                <div class="colourways-container">
                                    @if(empty($form->style_versions[$selectedVersion]['colourways']) || count(array_filter($form->style_versions[$selectedVersion]['colourways'] ?? [])) === 0)
                                        {{-- Empty State: No Colourways --}}
                                        <div class="border rounded p-5 text-center bg-light">
                                            <div class="empty-state-icon mb-3">
                                                <i class="fas fa-palette fa-3x text-muted"></i>
                                            </div>
                                            <h5 class="text-muted mb-2">No Colourways</h5>
                                            <p class="text-muted mb-4">This version doesn't have any colourways yet.<br>Add a colourway to define colours and yarns.</p>
                                            @if(Gate::check('style:update') && !$viewOnly)
                                                <button class="btn btn-primary" wire:click="addColourway({{$selectedVersion}})">
                                                    <i class="fas fa-plus me-2"></i> Add Colourway
                                                </button>
                                            @endif
                                        </div>
                                    @else
                                    <div class="row g-0 border rounded overflow-hidden">
                                        {{-- Colourway List --}}
                                        <div class="col-auto colourway-list-panel d-flex flex-column">
                                            <div class="colourway-list flex-grow-1">
                                                @foreach($form->style_versions[$selectedVersion]['colourways'] ?? [] as $c => $colourway)
                                                    <div class="colourway-item d-flex @if($c == $selectedColourway) active @endif">
                                                        <a role="button"
                                                           class="colourway-name flex-grow-1 px-3 py-2"
                                                           wire:click="$set('selectedColourway', {{$c}})">
                                                            {{$colourway['name'] ?? 'Unnamed'}}
                                                        </a>
                                                        @if(Gate::check('style:update') && !$viewOnly)
                                                            <div class="colourway-actions">
                                                                <button class="btn btn-sm btn-link text-primary p-1"
                                                                        wire:click="cloneColourway({{$selectedVersion}}, {{$c}}, {{$colourway['id'] ?? ''}})"
                                                                        title="Clone">
                                                                    <i class="fas fa-clone"></i>
                                                                </button>
                                                                <button class="btn btn-sm btn-link text-danger p-1"
                                                                        wire:click="removeColourway({{$selectedVersion}}, {{$c}}, {{$colourway['id'] ?? ''}})"
                                                                        onclick="confirm('Are you sure?') || event.stopImmediatePropagation()"
                                                                        title="Delete">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                            @if(Gate::check('style:update') && !$viewOnly)
                                                <div class="colourway-add border-top">
                                                    <button class="btn btn-primary btn-sm w-100 rounded-0" wire:click="addColourway({{$selectedVersion}})">
                                                        <i class="fas fa-plus me-1"></i> Add Colourway
                                                    </button>
                                                </div>
                                            @endif
                                        </div>

                                        {{-- Colourway Detail --}}
                                        <div class="col p-4" wire:key="version.{{$selectedColourway}}">
                                                <div class="row g-3">
                                                    <div class="col">
                                                        <div class="row g-3">
                                                            <div class="col">
                                                                <div class="form-floating">
                                                                    <input class="form-control" type="text" id="colourwayName"
                                                                        wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.name"
                                                                        @if($viewOnly) disabled @endif>
                                                                    <label for="colourwayName">Colourway</label>
                                                                </div>
                                                            </div>
                                                            <div class="col">
                                                                <div class="form-floating">
                                                                    <input class="form-control" type="text" id="colourwayCustRef"
                                                                        wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.customer_description"
                                                                        @if($viewOnly) disabled @endif>
                                                                    <label for="colourwayCustRef">Customer Desc</label>
                                                                </div>
                                                            </div>
                                                            <div class="col">
                                                                <div class="form-floating">
                                                                    <select class="form-select" id="colourTypeSelect"
                                                                        wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colour_type"
                                                                        @if($viewOnly) disabled @endif>
                                                                        <option value=""></option>
                                                                        <option value="solid">Solid</option>
                                                                        <option value="melange">Melange</option>
                                                                        <option value="mixed">Mixed</option>
                                                                    </select>
                                                                    <label for="colourTypeSelect">Colour Type</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row g-3 mt-2">
                                                            <div class="col">
                                                                <div class="form-floating">
                                                                    <textarea style="height: 90px" class="form-control" id="notesArea" wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.comments"
                                                                        @if($viewOnly) disabled @endif></textarea>
                                                                    <label for="notesArea">Comments</label>
                                                                </div>
                                                            </div>
                                                            <div class="col">
                                                                <div class="form-floating">
                                                                    <textarea style="height: 90px" class="form-control" id="notesArea" wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.accessories"
                                                                        @if($viewOnly) disabled @endif></textarea>
                                                                    <label for="notesArea">Accessories</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row mt-2">
                                                            <div class="col">
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input" id="cancelledCheck"
                                                                        wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.cancelled"
                                                                        @if($viewOnly) disabled @endif>
                                                                    <label class="form-check-label" for="cancelledCheck">Cancelled?</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <div class="col">
                                                            <div class="">
                                                                @if (!empty($form->style_versions[$selectedVersion]['colourways']['new_image']))
                                                                    <img class="img-thumbnail" style="max-width: 120px"
                                                                        src="{{ $form->style_versions[$selectedVersion]['colourways'][$selectedColourway]['new_image']->temporaryUrl() }}">
                                                                @elseif($form->style_versions[$selectedVersion]['colourways'][$selectedColourway]['image_url'] ?? "")
                                                                    <img class="img-thumbnail" style="max-width: 120px"
                                                                        src="{{ $form->style_versions[$selectedVersion]['colourways'][$selectedColourway]['image_url'] }}">
                                                                @endif
                                                            </div>

                                                            <input style="display: none;" class="form-control" type="file" id="newImageUpload"
                                                                wire:model.live="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.new_image"
                                                                @if($viewOnly) disabled @endif>
                                                            <label class="btn btn-primary" for="newImageUpload">Change Image</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                {{-- Yarn Table --}}
                                                <div class="row mt-4">
                                                    <div class="col-12">
                                                        <div class="table-responsive">
                                                            <table class="table table-sm text-center mb-0">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="min-width: 100px;">Spinner</th>
                                                                        <th style="min-width: 100px;">Yarn</th>
                                                                        <th style="min-width: 100px;">Colour</th>
                                                                        <th>Customer #</th>
                                                                        {{-- <th>Price</th> --}}
                                                                        <th class="@if($this->getYarnPercentageTotal($form->style_versions[$selectedVersion]['colourways'][$selectedColourway] ?? []) != 100) bg-danger text-white @endif">%</th>
                                                                        {{-- <th style="width: 80px">Inc FFP</th> --}}
                                                                        <th class="pe-0" style="width: 91px">
                                                                            @if(!$viewOnly)
                                                                                <button class="btn btn-primary float-end" wire:click="addYarn({{$selectedVersion}},{{$selectedColourway}})"><i class="fas fa-add"></i></button>
                                                                            @endif
                                                                        </th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    @foreach($form->style_versions[$selectedVersion]['colourways'][$selectedColourway]['colourway_yarns'] ?? [] as $y=>$colourway_yarn)
                                                                        <tr wire:key="yarn{{$selectedColourway}}-{{ $y }}">
                                                                            <td class="ps-0">
                                                                                @if(!$viewOnly)
                                                                                    <select class="form-select" wire:model.live="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colourway_yarns.{{$y}}.suppliers_id">
                                                                                        <option value=""></option>
                                                                                        @foreach($this->spinners as $spinner)
                                                                                            <option value="{{$spinner->id}}">{{$spinner->name}}</option>
                                                                                        @endforeach
                                                                                    </select>
                                                                                @else
                                                                                    {{$colourway_yarn['yarn_colours']['yarn']['suppliers']['name'] ?? ""}}
                                                                                @endif
                                                                            </td>
                                                                            <td>
                                                                                @if(!$viewOnly)
                                                                                    <select class="form-select" wire:model.live="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colourway_yarns.{{$y}}.yarn_id">
                                                                                        <option value=""></option>
                                                                                        @foreach($this->yarns->where('suppliers_id', $colourway_yarn['suppliers_id'] ?? "") as $yarn)
                                                                                            <option value="{{$yarn->id}}">{{$yarn->description}} {{$yarn->count}}</option>
                                                                                        @endforeach
                                                                                    </select>
                                                                                @else
                                                                                    {{$colourway_yarn['yarn_colours']['yarn']['description'] ?? ""}}
                                                                                @endif
                                                                            </td>
                                                                            <td>
                                                                                @if(!$viewOnly)
                                                                                    <select class="form-select" wire:model.live="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colourway_yarns.{{$y}}.yarn_colours_id">
                                                                                        <option value=""></option>
                                                                                        @foreach($this->colours->where('yarn_id', $colourway_yarn['yarn_id'] ?? "") as $colour)
                                                                                            <option value="{{$colour->id}}">{{$colour->reference}} {{$colour->description}}</option>
                                                                                        @endforeach
                                                                                    </select>
                                                                                @else
                                                                                    {{$colourway_yarn['yarn_colours']['reference'] ?? ""}} |
                                                                                    {{$colourway_yarn['yarn_colours']['description'] ?? ""}}
                                                                                @endif
                                                                            </td>
                                                                            <td>
                                                                                @if(!$viewOnly)
                                                                                    <input class="form-control" type="text" wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colourway_yarns.{{$y}}.cust_ref">
                                                                                @else
                                                                                    {{$colourway_yarn['cust_ref'] ?? ""}}
                                                                                @endif
                                                                            </td>
                                                                            {{-- <td>
                                                                                @if(!$viewOnly)
                                                                                    <input class="form-control" type="text" wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colourway_yarns.{{$y}}.price">
                                                                                @else
                                                                                    {{$colourway_yarn['price'] ?? ""}}
                                                                                @endif
                                                                            </td> --}}
                                                                            <td class="@if($this->getYarnPercentageTotal($form->style_versions[$selectedVersion]['colourways'][$selectedColourway] ?? []) != 100) bg-danger text-white @endif">
                                                                                @if(!$viewOnly)
                                                                                    <input class="form-control" type="text" wire:model.live.debounce.500ms="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colourway_yarns.{{$y}}.percentage">
                                                                                @else
                                                                                    {{$colourway_yarn['percentage'] ?? ""}}
                                                                                @endif
                                                                            </td>
                                                                            {{-- <td>
                                                                                @if(!$viewOnly)
                                                                                    <select class="form-select" wire:model="form.style_versions.{{$selectedVersion}}.colourways.{{$selectedColourway}}.colourway_yarns.{{$y}}.not_full_factored">
                                                                                        <option value="1">Y</option>
                                                                                        <option value="0">N</option>
                                                                                    </select>
                                                                                @else
                                                                                    {{$colourway_yarn['not_full_factored'] ?? 0 ? "Y" : "N"}}
                                                                                @endif
                                                                            </td> --}}
                                                                            <td class="pe-0 text-end">
                                                                                <button class="btn btn-primary" wire:click="cloneYarn({{$selectedVersion}}, {{$selectedColourway}}, {{$y}})"><i class="fas fa-clone"></i></button>
                                                                                <button class="btn btn-danger" wire:click="removeYarn({{$selectedVersion}}, {{$selectedColourway}}, {{$y}})" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()"><i class="fas fa-trash"></i></button>
                                                                            </td>
                                                                        </tr>
                                                                    @endforeach
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                    @endif {{-- End: Has Colourways --}}
                                </div>
                            </div>
                            @endif {{-- End: Has Versions --}}
                        </div>
                    </div>
                @endif
            </div>
            {{-- Footer --}}
            <div class="style-edit-footer border-top bg-light">
                <div class="d-flex align-items-center justify-content-between p-2 px-3">
                    <div class="text-danger fw-bold">
                        @if (session()->has('message'))
                            <div class="alert alert-sm py-1 px-2 mb-0 {{ session('alert-class') }}">
                                {{ $this->humanisedSessionMessage }}
                            </div>
                        @endif
                    </div>
                    <div class="d-flex gap-2">
                        @if (!$viewOnly)
                            <button class="btn btn-success" wire:click="save">
                                <i class="fas fa-save me-1"></i> Save
                            </button>
                            <button class="btn btn-outline-secondary" wire:click="$toggle('commissionView')">
                                <i class="fas fa-list me-1"></i> Commission View
                            </button>
                        @endif
                        <button class="btn btn-outline-danger" x-on:click="closeWindow()">
                            <i class="fas fa-times me-1"></i> Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
        @endif

    </div>
</div>

<script>
    window.unsavedChanges = function() {
        return {
            dirty: false,
            init() {
                // Attach event listeners to track changes on all inputs, selects, and textareas
                this.$el.querySelectorAll('input, select, textarea').forEach(el => {
                    el.addEventListener('input', () => this.dirty = true);
                    el.addEventListener('change', () => this.dirty = true);
                });
            },
            closeWindow() {
                if (this.dirty && !confirm('You have unsaved changes. Are you sure you want to close?')) {
                    return;
                }
                // Check if we're in a modal or standalone window
                if (window.opener) {
                    // Standalone popup window
                    window.close();
                } else {
                    // Modal - dispatch close event
                    this.$dispatch('close-modal');
                }
            }
        }
    }
</script>
