<div>
    <div class="modal-body" style="min-height: calc(100vh - 62px)">
        <div class="container">
            <div class="row">
                <div class="col">
                    @if (Session::get('message'))
                        <div class="alert {{ Session::get('alert-class') }}" role="alert">
                            {{ Session::get('message') }}
                        </div>
                    @endif
                    @if($errors->all())
                        <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                            @foreach ($errors->all() as $error)
                                {{ $error }}<br>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <table class="table table-bordered">
                <thead>
                    <tr> {{-- Header row for labels --}}
                        <th>RT Code <span class="text-danger">*</span></th>
                        <th>Department <span class="text-danger">*</span></th>
                        <th>Season <span class="text-danger">*</span></th>
                        <th>Customer <span class="text-danger">*</span></th>
                        <th>Category <span class="text-danger">*</span></th>
                        <th>Customer Ref</th>
                        <th>Description <span class="text-danger">*</span></th>
                        <th>Gauge <span class="text-danger">*</span></th>
                        <th>Carryover</th>
                        <th>Factory <span class="text-danger">*</span></th>
                        <th>Colourway Names <span class="text-danger">*</span></th>
                        <th></th> {{-- For the remove button --}}
                    </tr>
                </thead>
                <tbody>
                    @foreach ($rows as $index => $row)
                        <tr wire:key="{{ $index }}"> {{-- Dynamically added rows --}}
                            <td>
                                <div class="btn-group">
                                    @if((!($row['new_design'] ?? 0)))
                                        <button class="btn btn-secondary" type="button" wire:click="openRTPicker({{$index}})">
                                            {{$row['rt_code'] ?? "Set"}}
                                        </button>
                                        @if(!($row['rt_code'] ?? ""))
                                            @can('design:create')
                                                <button class="btn btn-light" wire:click="newRtCode({{$index}})">New</button>
                                            @endcan
                                        @endif
                                    @else
                                        New
                                    @endif
                                </div>
                            </td>
                            <td>
                                <select class="form-select" wire:model="rows.{{ $index }}.department">
                                    <option value=""></option>
                                    @foreach ($this->departments as $department)
                                        <option value="{{ $department->id }}">{{ $department->description }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select class="form-select" wire:model="rows.{{ $index }}.season">
                                    <option value=""></option>
                                    @foreach ($this->seasons as $season)
                                        <option value="{{ $season->id }}">{{ $season->description }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select class="form-select" wire:model="rows.{{ $index }}.customer">
                                    <option value=""></option>
                                    @foreach ($this->customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select class="form-select" wire:model="rows.{{ $index }}.category">
                                    <option value=""></option>
                                    <option value="ladies">Ladies</option>
                                    <option value="mens">Mens</option>
                                    <option value="childrens">Childrens</option>
                                    <option value="accessories">Accessories</option>
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control" wire:model="rows.{{ $index }}.customer_ref">
                            </td>
                            <td>
                                <input type="text" class="form-control" wire:model="rows.{{ $index }}.description">
                            </td>
                            <td>
                                <select class="form-select" wire:model="rows.{{ $index }}.gauge">
                                    <option value=""></option>
                                    @foreach ($this->gauges as $gauge)
                                        <option value="{{ $gauge->id }}">{{ $gauge->gauge }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <input type="checkbox" class="form-check-input" wire:model="rows.{{ $index }}.carryover">
                            </td>
                            <td>
                                <select class="form-select" wire:model="rows.{{ $index }}.factory">
                                    <option value=""></option>
                                    @foreach ($this->factories as $factory)
                                        <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control" wire:model="rows.{{ $index }}.colourway_names">
                            </td>
                            <td>
                                <button class="btn btn-danger" wire:click="removeRow({{ $index }})">X</button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="container">
            <div class="row">
                <div class="col">
                    <ul class="dropdown-menu @if($rtPicker >= 0) show @endif" style="
                    position: absolute;
                    inset: 0px auto auto 0px;
                    transform: translate(0px, 0px) !important;
                    background: #e9e9e9;
                    width: calc(100% - 40px);
                    padding: 20px;
                    margin: 20px;">
                        <input type="text" class="form-control" wire:model.live="designs_search">
                        @foreach($this->designs() as $design)
                            <li class="py-2" style="cursor: pointer;" wire:click="setRTCode({{$design->id}})">
                                <b>{{$design->id}}</b> {{$design->description}}
                            </li>
                        @endforeach
                        <div class="col text-end">
                            <button class="btn btn-secondary" type="button" wire:click="$set('rtPicker', -1)">Close</button>
                        </div>
                    </ul>
                </div>
            </div>
        </div>

        <div class="modal-footer">
            <button class="btn btn-secondary" wire:click="addRow">Add Row</button>
            <button class="btn btn-secondary" wire:click="saveData">Save</button>
        </div>
    </div>
</div>
