<div>
    <div class="modal-body">
        <div class="row">
            <div class="col-6 py-3">
                <div class="input-group">
                    <input type="number" class="form-control" wire:model="form.yarnPriceAll">
                    <select class="form-select" wire:model="form.yarnPriceAllType">
                        <option value=""></option>
                        <option value="solid">Solid</option>
                        <option value="melange">Melange</option>
                        <option value="mixed">Mixed</option>
                    </select>
                    <button class="btn btn-primary" wire:click="changeAllYarnPrices">Change All Prices</button>
                </div>
            </div>
        </div>
        @if($edit)
            <div class="accordion mb-3 ms-0" id="accodrionColourways">
                @foreach($form->svEdit['colourways'] ?? [] as $c=>$colourway)
                    @php
                        $cwTotalPercentage = collect($colourway['colourway_yarns'] ?? [])->sum('percentage');
                        $cwHasAllPrices = collect($colourway['colourway_yarns'] ?? [])->every(fn($cy) => isset($cy['price']) && $cy['price'] > 0);
                        $cwPercentageValid = abs($cwTotalPercentage - 100) < 0.5;
                        $cwHasYarns = count($colourway['colourway_yarns'] ?? []) > 0;
                        $cwHasIssues = $cwHasYarns && (!$cwPercentageValid || !$cwHasAllPrices);
                    @endphp
                    <div wire:key="colourwayC{{$c}}" wire:ignore.self="" class="accordion-item">
                        <h2 class="accordion-header" id="heading{{$c}}">
                            <button wire:ignore.self=""
                                class="accordion-button collapsed" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapseC{{$c}}" aria-expanded="false"
                                aria-controls="collapseC{{$c}}">
                                {{$colourway['name'] ?? ""}} ({{$colourway['colour_type'] ?? ""}})
                                @if($cwHasIssues)
                                    <span class="badge bg-warning text-dark ms-2" title="Yarn percentages: {{ number_format($cwTotalPercentage, 1) }}%">
                                        <i class="bi bi-exclamation-triangle-fill"></i> {{ number_format($cwTotalPercentage, 1) }}%
                                    </span>
                                @endif
                            </button>
                        </h2>
                        <div wire:ignore.self="" id="collapseC{{$c}}"
                            class="accordion-collapse @if(!$loop->first) collapse @endif" aria-labelledby="headingTwo"
                            data-bs-parent="#accodrionColourways" style="">
                            <div class="accordion-body bg-white p-3">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table class="table text-center">
                                                <thead>
                                                    <tr>
                                                        <th style="min-width: 100px;">Spinner</th>
                                                        <th style="min-width: 100px;">Yarn</th>
                                                        <th style="min-width: 100px;">Colour</th>
                                                        <th>Customer #</th>
                                                        <th>Price</th>
                                                        <th>%</th>
                                                        <th style="width: 80px">Inc FFP</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($colourway['colourway_yarns'] ?? [] as $y=>$colourway_yarn)
                                                        <tr wire:key="yarn{{$c}}-{{ $y }}">
                                                            <td>
                                                                    {{$colourway_yarn['yarn_colours']['yarn']['suppliers']['name'] ?? ""}}
                                                            </td>
                                                            <td>
                                                                    {{$colourway_yarn['yarn_colours']['yarn']['description'] ?? ""}}
                                                            </td>
                                                            <td>
                                                                    {{$colourway_yarn['yarn_colours']['reference'] ?? ""}} |
                                                                    {{$colourway_yarn['yarn_colours']['description'] ?? ""}}
                                                            </td>
                                                            <td>
                                                                    {{$colourway_yarn['cust_ref'] ?? ""}}
                                                            </td>
                                                            <td>
                                                                @if(Gate::check('price:update'))
                                                                <div class="input-group">
                                                                    <span class="input-group-text">{{$form->svOrigional->colourways[$c]->colourway_yarns[$y]->yarn_colours->yarn->suppliers->currency}}</span>
                                                                    <input class="form-control" type="text" wire:model="form.svEdit.colourways.{{$c}}.colourway_yarns.{{$y}}.price">
                                                                </div>
                                                                @else
                                                                    {{$colourway_yarn['price'] ?? ""}}
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if(Gate::check('price:update'))
                                                                    <input class="form-control" type="text" wire:model="form.svEdit.colourways.{{$c}}.colourway_yarns.{{$y}}.percentage">
                                                                @else
                                                                    {{$colourway_yarn['percentage'] ?? ""}}
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if(Gate::check('price:update'))
                                                                    <select class="form-select" wire:model="form.svEdit.colourways.{{$c}}.colourway_yarns.{{$y}}.not_full_factored">
                                                                        <option value="1">Y</option>
                                                                        <option value="0">N</option>
                                                                    </select>
                                                                @else
                                                                    {{$colourway_yarn['not_full_factored'] ?? 0 ? "Y" : "N"}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                                @php
                                                    $totalPercentage = collect($colourway['colourway_yarns'] ?? [])->sum('percentage');
                                                    $hasAllPrices = collect($colourway['colourway_yarns'] ?? [])->every(fn($cy) => isset($cy['price']) && $cy['price'] > 0);
                                                    $percentageValid = abs($totalPercentage - 100) < 0.5;
                                                @endphp
                                                <tfoot>
                                                    <tr>
                                                        <td colspan="5" class="text-end fw-bold">Total:</td>
                                                        <td class="fw-bold {{ $percentageValid ? 'text-success' : 'text-danger' }}">
                                                            {{ number_format($totalPercentage, 1) }}%
                                                        </td>
                                                        <td></td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                            @if(!$percentageValid || !$hasAllPrices)
                                                <div class="alert alert-warning d-flex align-items-center mb-0" role="alert">
                                                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                                    <div>
                                                        <strong>Warning:</strong>
                                                        @if(!$percentageValid)
                                                            Yarn percentages must add up to 100% (currently {{ number_format($totalPercentage, 1) }}%).
                                                        @endif
                                                        @if(!$hasAllPrices)
                                                            Some yarns are missing prices.
                                                        @endif
                                                        <span class="text-muted">Yarn/kg price will show as 0 on the pricing sheet until corrected.</span>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
    <div class="modal-footer">
        @if(Gate::check('style:update'))
            <button class="btn btn-primary"  wire:click="save">Save</button>
            <button class="btn btn-danger"  wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>
        @else
            <button class="btn btn-primary"  wire:click="$dispatch('close-modal')">Close</button>
        @endif
    </div>
</div>
