<div>
    <div class="modal-body">
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }} d-flex align-items-start" role="alert">
                <div>
                    <i class="bi {{ Session::get('alert-class') == 'alert-success' ? 'bi-check-circle' : (Session::get('alert-class') == 'alert-warning' ? 'bi-exclamation-triangle' : 'bi-x-circle') }} me-2"></i>
                </div>
                <div>
                    {{ Session::get('message') }}
                    @if($errors->any())
                        <ul class="mb-0 mt-2">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    @endif
                </div>
            </div>
        @endif
        
        @if(!empty($style))
            <div class="mb-3 p-2 bg-light rounded">
                <small class="text-muted">Cloning style:</small>
                <div class="fw-bold">{{ $style->designs_id }} - {{ $style->customer_ref }}</div>
            </div>
            
            <div class="row">
                <div class="col">
                    <div class="row align-items-center">
                        {{-- Dept, Season, Customer --}}
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Department</h6>
                        </div>
                        <div class="col-7">
                            <select class="form-select @error('clone.departments_id') is-invalid @enderror" wire:model="clone.departments_id">
                                <option value=""></option>
                                @foreach($this->departments as $department)
                                    <option value="{{$department->id}}">{{$department->description}}</option>
                                @endforeach
                            </select>
                            @error('clone.departments_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center" style="height: 37px">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Season</h6>
                        </div>
                        <div class="col-7">
                            <select class="form-select @error('clone.seasons_id') is-invalid @enderror" wire:model="clone.seasons_id">
                                <option value="">-- Select Season --</option>
                                @foreach($this->seasons as $season)
                                    <option value="{{$season->id}}">{{$season->description}}</option>
                                @endforeach
                            </select>
                            @error('clone.seasons_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center" style="height: 37px">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Customer</h6>
                        </div>
                        <div class="col-7">
                            <select class="form-select @error('clone.customers_id') is-invalid @enderror" wire:model="clone.customers_id">
                                <option value=""></option>
                                @foreach($this->customers as $customer)
                                    <option value="{{$customer->id}}">{{$customer->name}}</option>
                                @endforeach
                            </select>
                            @error('clone.customers_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        @endif

    </div>
    <div class="modal-footer">
        @can('style:update')
            <button class="btn btn-primary" wire:click="save" wire:loading.attr="disabled">
                <span wire:loading.remove wire:target="save">Clone Style</span>
                <span wire:loading wire:target="save">
                    <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
                    Cloning...
                </span>
            </button>
            <button class="btn btn-secondary" wire:click="$dispatch('close-modal')">Cancel</button>
        @else
            <button class="btn btn-primary" wire:click="$dispatch('close-modal')">Close</button>
        @endcan
    </div>
</div>
