<div>
    <div class="modal-body">
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h3>
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
            </div>
        @endif
        @if(!empty($style))
            <div class="row">
                <div class="col">
                    <div class="row align-items-center" style="height: 37px">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Version From</h6>
                        </div>
                        <div class="col-7">
                            <select class="form-select" wire:model="clone.version_from">
                                <option value=""></option>
                                @foreach($style->style_versions as $version)
                                    <option value="{{$version->id}}">{{$version->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>

                    <div class="row align-items-center" style="height: 37px">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Season</h6>
                        </div>
                        <div class="col-7">
                            <select class="form-select" wire:model="clone.seasons_id">
                                <option value=""></option>
                                @foreach($this->seasons as $season)
                                    <option value="{{$season->id}}">{{$season->description}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center" style="height: 37px">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Style</h6>
                        </div>
                        <div class="col-7">
                            <button class="btn btn-secondary" type="button" wire:click="$toggle('colourwayPicker')">
                                {{ $clone['style']->customer_ref ?? ""}}
                            </button>
                            <ul class="dropdown-menu @if($colourwayPicker == 1) show @endif" style="
                                position: absolute;
                                inset: 0px auto auto 0px;
                                transform: translate(0px, 0px) !important;
                                background: #e9e9e9;
                                width: calc(100% - 40px);
                                padding: 20px;
                                margin: 20px;">
                                    <input type="text" class="form-control" wire:model.live="styleSearch">
                                    <div class="my-3" style="max-height: 550px; overflow: auto;">
                                        @forelse($this->styles ?? [] as $style)
                                            <li class="py-2" style="cursor: pointer;" wire:click="setStyleTo({{$style->id}})">
                                                <b>{{$style->designs_id}}</b> ({{$style->seasons?->description}}) {{$style->customer_ref}}
                                            </li>
                                        @empty

                                        @endforelse
                                    </div>
                                    <div class="col text-end">
                                        <button class="btn btn-secondary" type="button" wire:click="$toggle('colourwayPicker')">Close</button>
                                    </div>
                            </ul>
                        </div>
                    </div>
                    <hr>
                    <div class="row align-items-center" style="height: 37px">
                        <div class="col-5">
                            <h6 class="mb-0 fw-bold">Version To</h6>
                        </div>
                        <div class="col-7">
                            <select class="form-select" wire:model="clone.version_to">
                                <option value=""></option>
                                @if(!empty($clone['style']))
                                    @foreach($clone['style']->style_versions ?? [] as $version)
                                        <option value="{{$version->id}}">{{$version->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        @endif

    </div>
    <div class="modal-footer">
        @can('style:update')
            <button class="btn btn-primary"  wire:click="save">Save</button>
            <button class="btn btn-danger"  wire:click="$dispatch('close-modal')">Close</button>
        @else
            <button class="btn btn-primary"  wire:click="$dispatch('close-modal')">Close</button>
        @endcan
    </div>
</div>
