<div id="page-content">
	<x-title-bar>
        <x-slot:title>
            Samples
        </x-slot:title>
        <x-slot:end>
			<button class="btn btn-light" wire:click="selectAll({{json_encode($samples->pluck('id')->toArray())}})">Select All</button>
			@can('style:update')
				<button class="btn btn-light" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="editSamples">Edit</button>
			@endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="season">
								<option selected value="">All</option>
								@foreach($this->seasons as $season)
									<option value="{{ $season->id }}">{{ $season->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Season:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="customer">
								<option selected value="">All</option>
								@foreach($this->customers as $customer)
									<option value="{{ $customer->id }}">{{ $customer->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Customer:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="factory">
								<option selected value="">All</option>
								@foreach($this->factories as $factory)
									<option value="{{ $factory->id }}">{{ $factory->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Factory:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="category">
								<option selected value="">All</option>
								<option selected value="ladies">Ladies</option>
								<option selected value="mens">Mens</option>
								<option selected value="childrens">Childrens</option>
								<option selected value="accessories">Accessories</option>

							</select>
							<label class="form-label">Category:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="department">
								<option selected value="">All</option>
								@foreach($this->departments as $department)
									<option value="{{ $department->id }}">{{ $department->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Department:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="status">
								<option selected value="">All</option>
								<option selected value="pending">Pending</option>
								<option selected value="approved">Approved</option>
								<option selected value="rejected">Rejected</option>
							</select>
							<label class="form-label">Status:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="paginate">
								<option selected value="10">10</option>
								<option selected value="50">50</option>
								<option selected value="100">100</option>
								<option selected value="200">200</option>
								<option selected value="500">500</option>
							</select>
							<label class="form-label">Per Page:</label>
						</div>
					</div>
					<livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
				<div class="row mx-1">
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
							<label>Search</label>
							<div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
						</div>
					</div>
				</div>
            @endif
        </x-slot:sub>
    </x-title-bar>


    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
						<tr>
							@if($columns['Style'])				<th>Style</th>									@endif
							@if($columns['Version'])			<th>Version</th>								@endif
							@if($columns['Colourway'])			<th>Colourway</th>								@endif
							@if($columns['Type'])				<th>Type</th>									@endif
							@if($columns['Expected'])			<th style="min-width: 80px">Expected</th>		@endif
							@if($columns['Sent'])				<th style="min-width: 80px">Sent</th>			@endif
							@if($columns['Tracking'])			<th>Tracking</th>								@endif
							@if($columns['Weight'])				<th>Weight</th>									@endif
							@if($columns['Size'])				<th>Size</th>									@endif
							@if($columns['Qty'])				<th>Qty</th>									@endif
							@if($columns['Status'])				<th>Status</th>									@endif
							@if($columns['Comments'])			<th>Comments</th>								@endif
							@if($columns['Dont Charge'])		<th>Don't Charge?</th>							@endif
							@if($columns['Dont Charge Dev'])	<th>Don't Charge Dev?</th>						@endif
							@if($columns['Notes for Finance'])	<th>Notes for Finance</th>						@endif
							@if($columns['PO'])					<th>PO</th>										@endif
							<th style="width: 0"></th>
						</tr>
					</thead>
					<tbody>
						@foreach($samples->groupBy('style_id') as $s=>$style)
								@foreach($style as $sample)

									<tr>
										@if($columns['Style'])		<td x-data="" x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$sample->style_id}}})">{{$sample->customer_ref}}</td> 	@endif
										@if($columns['Version'])	<td>{{$sample->style_version}}</td>															@endif
										@if($columns['Colourway'])
											<td class="text-center">
												{{Str::title($sample->colourway)}} <br>
												@if(!empty($sample->image))
													<img style="max-width: 100px; max-height: 100px;" class="img-fluid pb-3 rounded"
													src="{{ url(asset('storage/' . $sample->image)) }}">
												@endif
												<br>
											</td>
										@endif
										@if($columns['Type'])				<td>{{$sample->sample_type}}</td>										@endif
										@if($columns['Expected'])			<td>{{date_format(date_create($sample->date_sent), "d-M")}}</td>		@endif
										@if($columns['Sent'])				<td>{{date_format(date_create($sample->date_expected), "d-M")}}</td>	@endif
										@if($columns['Tracking'])			<td>{{$sample->tracking}}</td>											@endif
										@if($columns['Weight'])				<td>{{$sample->weight}}</td>											@endif
										@if($columns['Size'])				<td>{{$sample->size}}</td>												@endif
										@if($columns['Qty'])				<td>{{$sample->qty}}</td>												@endif
										@if($columns['Status'])				<td>{{$sample->status}}</td>											@endif
										@if($columns['Comments'])			<td>{{$sample->comments}}</td>											@endif
										@if($columns['Dont Charge'])		<td>@if($sample->do_not_charge) Y @else N @endif</td>					@endif
										@if($columns['Dont Charge Dev'])	<td>@if($sample->do_not_charge_dev) Y @else N @endif</td>				@endif
										@if($columns['Notes for Finance'])	<td>{{$sample->fn_notes}}</td>											@endif
										@if($columns['PO'])					<td>{{$sample->po}}</td>												@endif

										<td>
											@if(Gate::check('style:update') && !$sample->season_locked)
												<input type="checkbox" class="form-check-input" wire:model="edit.{{$sample->id}}">
											@endif
										</td>
									</tr>

								@endforeach
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<x-modal name="edit" title="Bulk Edit">
		<x-slot:body>
			<livewire:development.samples.samples-edit :samples="$edit" wire:key="edit">
		</x-slot:body>
	</x-modal>
	<x-modal name="edit-style" title="Edit Style">
		<x-slot:body>
			<livewire:development.styles.style-edit :style="$styleEditID" wire:key="styleEdit">
		</x-slot:body>
	</x-modal>

	<x-footer>
        <x-slot:center>
			{{ $samples->links() }}
        </x-slot:center>
    </x-footer>

	@script
		<script>
			// Run on initial load
			window.addEventListener('load', adjustContentAreaHeight);

			// Run on window resize
			window.addEventListener('resize', adjustContentAreaHeight);

			//Run on livewire events
			Livewire.hook('component.init', ({ el, component }) => {
				adjustContentAreaHeight();
			})
		</script>
	@endscript

</div>
