<div id="page-content">
	<x-title-bar>
        <x-slot:title>
            Bulk Samples
        </x-slot:title>
        <x-slot:end>
            @if($this->colourway)
			    <button class="btn btn-primary my-3" wire:click="save">Save</button>
			    <button class="btn btn-primary my-3" wire:click="addSample">Add</button>
            @endif
        </x-slot:end>
        <x-slot:sub>
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="season">
								<option selected value="">All</option>
								@foreach($this->seasons as $season)
									<option value="{{ $season->id }}">{{ $season->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Season:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="customer">
								<option selected value="">All</option>
								@foreach($this->customers as $customer)
									<option value="{{ $customer->id }}">{{ $customer->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Customer:</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="style">
								<option selected value="">All</option>
								@foreach($this->styles() as $styleItem)
									<option value="{{ $styleItem->id }}">{{ $styleItem->customer_ref }}</option>
								@endforeach
							</select>
							<label class="form-label">Style:</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="styleVersion">
								<option selected value="">All</option>
								@foreach($this->styleVersions() as $versionItem)
									<option value="{{ $versionItem->id }}">{{ $versionItem->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Version:</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="colourway">
								<option selected value="">All</option>
								@foreach($this->colourways() as $colourwayItem)
									<option value="{{ $colourwayItem->id }}">{{ $colourwayItem->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Colourway:</label>
						</div>
					</div>
				</div>
        </x-slot:sub>
    </x-title-bar>


    <div class="container-fluid mt-3">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table class="table align-middle rounded table-bordered table-striped">
                    <thead style="position: sticky; top:0; z-index:100">
						<tr>
                            <th>Sample</th>
                            <th>Expected in Office</th>
                            <th>Sent to Customer</th>
                            <th>Tracking</th>
                            <th>Weight</th>
                            <th>Size</th>
                            <th>Qty</th>
                            <th>Status</th>
                            <th>Comments</th>
                            <th>DNC</th>
                            <th>DNC Dev</th>
                            <th>Actions</th> <!-- New column for delete action -->
						</tr>
					</thead>
                    <tbody>
                        @if($this->colourway && empty($samples))
                            <tr>
                                <td colspan="12" class="text-center text-muted py-4">
                                    No samples found for this colourway. Click "Add" to create a new sample.
                                </td>
                            </tr>
                        @elseif(!$this->colourway)
                            <tr>
                                <td colspan="12" class="text-center text-muted py-4">
                                    Please select a colourway to view or add samples.
                                </td>
                            </tr>
                        @endif
                        @foreach($samples as $i => $sample)
                            <tr>
                                <td>
                                    <select class="form-select" wire:model="samples.{{ $i }}.sample_types_id">
                                        <option value="" selected>Select Sample Type</option>
                                        @foreach($this->sampleTypes as $type)
                                            <option value="{{ $type->id }}">{{ $type->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <input type="date" class="form-control" wire:model="samples.{{ $i }}.date_expected">
                                </td>
                                <td>
                                    <input type="date" class="form-control" wire:model="samples.{{ $i }}.date_sent">
                                </td>
                                <td>
                                    <input type="text" class="form-control" wire:model="samples.{{ $i }}.tracking">
                                </td>
                                <td>
                                    <input type="number" class="form-control" wire:model="samples.{{ $i }}.weight">
                                </td>
                                <td>
                                    <input type="text" class="form-control" wire:model="samples.{{ $i }}.size">
                                </td>
                                <td>
                                    <input type="number" class="form-control" wire:model="samples.{{ $i }}.qty">
                                </td>
                                <td>
                                    <select class="form-select" wire:model="samples.{{ $i }}.status">
                                        <option value="pending">Pending</option>
                                        <option value="approved">Approved</option>
                                        <option value="rejected">Rejected</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="text" class="form-control" wire:model="samples.{{ $i }}.comments">
                                </td>
                                <td>
                                    <input type="checkbox" class="form-check-input" wire:model="samples.{{ $i }}.do_not_charge">
                                </td>
                                <td>
                                    <input type="checkbox" class="form-check-input" wire:model="samples.{{ $i }}.do_not_charge_dev">
                                </td>
                                <td>
                                    <button class="btn btn-danger btn-sm" wire:click="deleteSample({{ $i }})">Delete</button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
				</table>
			</div>
		</div>
	</div>


</div>
