<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Style Progress
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="season">
								<option selected value="">All</option>
								@foreach($this->seasons as $season)
									<option value="{{ $season->id }}">{{ $season->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Season:</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showCustomerDropdown') }">
                            <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click.prevent="open = !open" @keydown.escape.window="open = false">Customers @if(empty($customer)) (All) @else() ({{ is_array($customer) ? (array_keys($customer) === range(0, count($customer) - 1) ? count($customer) : count(array_keys($customer))) : 0 }} Selected) @endif</button>

                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin; display:none;" x-show="open" x-on:click.outside="open = false" x-cloak>
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('customer')">All</button>
                                </li>
                                @foreach($this->customers as $i=>$c)
                                    <li class="px-3 py-1 @if(($customer[$c->id] ?? 0) || (is_array($customer) && array_keys($customer) === range(0, count($customer) - 1) && in_array($c->id, $customer))) bg-good @endif">
                                        <span style="cursor: pointer;" wire:click="select('customer', {{$c->id}})">{{ $c->name }}</span><br>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="factory">
								<option selected value="">All</option>
								@foreach($this->factories as $factory)
									<option value="{{ $factory->id }}">{{ $factory->name }}</option>
								@endforeach
							</select>
							<label class="form-label">Factory:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="category">
								<option value="">All</option>
								<option value="ladies">Ladies</option>
								<option value="mens">Mens</option>
								<option value="childrens">Childrens</option>
								<option value="accessories">Accessories</option>

							</select>
							<label class="form-label">Category:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="department">
								<option selected value="">All</option>
								@foreach($this->departments as $department)
									<option value="{{ $department->id }}">{{ $department->description }}</option>
								@endforeach
							</select>
							<label class="form-label">Department:</label>
						</div>
					</div>
					<div class="col-xl col-6 mb-2 px-1">
						<div class="form-floating form-outline">
							<select class="form-select" wire:model.live="paginate">
								<option value="10">10</option>
								<option value="50">50</option>
								<option value="100">100</option>
								<option value="200">200</option>
								<option value="500">500</option>
							</select>
							<label class="form-label">Per Page:</label>
						</div>
					</div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="orderBy">
                                <option value="">Default</option>
                                <option value="rt">RT Ref</option>
                                <option value="proto">Proto</option>
                            </select>
                            <label class="form-label">Sort By:</label>
                        </div>
                    </div>
					<livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
                <div class="row mx-1">
                    <div class="col-12 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.change="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>
    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded text-center">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
						<tr>
                            @if($columns['Customer'])                <th role="button" wire:click="sortBy('customer')">Customer @if($sortField==='customer'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Factory'])                <th role="button" wire:click="sortBy('factory')">Factory @if($sortField==='factory'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Category'])                <th role="button" wire:click="sortBy('category')">Category @if($sortField==='category'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Image'])                    <th role="button" wire:click="sortBy('image')">Image @if($sortField==='image'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['RT Style No'])            <th role="button" wire:click="sortBy('rt')">RT Style No @if($sortField==='rt'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Customer Style No'])        <th role="button" wire:click="sortBy('customer_ref')">Customer Style No @if($sortField==='customer_ref'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Description'])            <th role="button" wire:click="sortBy('description')">Description @if($sortField==='description'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Version'])                <th role="button" wire:click="sortBy('version')">Version @if($sortField==='version'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Colourway'])                <th role="button" wire:click="sortBy('colourway')">Colourway @if($sortField==='colourway'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Colourway Comments'])        <th role="button" style="min-width: 200px" wire:click="sortBy('colourway_comments')">Colourway Comments @if($sortField==='colourway_comments'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Date of Issue'])            <th role="button" wire:click="sortBy('date_of_issue')">Date of Issue @if($sortField==='date_of_issue'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Carryover'])                <th role="button" wire:click="sortBy('carryover')">Carryover? @if($sortField==='carryover'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Yarn Ends'])                <th role="button" wire:click="sortBy('yarn_ends')">No. Yarn Ends @if($sortField==='yarn_ends'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Sample Yarn'])            <th role="button" wire:click="sortBy('sample_yarn')">Sample Yarn @if($sortField==='sample_yarn'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Sample Accessories'])        <th role="button" wire:click="sortBy('sample_accessories')">Sample Accessories @if($sortField==='sample_accessories'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Proto Approved'])            <th role="button" wire:click="sortBy('proto_approved')">Proto Approved? @if($sortField==='proto_approved'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Fit Approved'])            <th role="button" wire:click="sortBy('fit_approved')">Fit Approved? @if($sortField==='fit_approved'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Sealer Approved'])        <th role="button" wire:click="sortBy('sealer_approved')">Sealer Approved? @if($sortField==='sealer_approved'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['SMS Approved'])            <th role="button" wire:click="sortBy('sms_approved')">SMS Approved? @if($sortField==='sms_approved'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Photo Approved'])            <th role="button" wire:click="sortBy('photo_approved')">Photo Approved? @if($sortField==='photo_approved'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Shipment Approved'])        <th role="button" wire:click="sortBy('shipment_approved')">Shipment Approved? @if($sortField==='shipment_approved'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Composition'])            <th role="button" style="min-width: 150px" wire:click="sortBy('composition')">Composition @if($sortField==='composition'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Yarns'])                    <th role="button" style="min-width: 400px" wire:click="sortBy('yarns')">Yarns @if($sortField==='yarns'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Gauge'])                    <th role="button" wire:click="sortBy('gauge')">Gauge @if($sortField==='gauge'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Weight'])                    <th role="button" wire:click="sortBy('weight')">Weight (kg) @if($sortField==='weight'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
                            @if($columns['Recent Sample Comment'])    <th role="button" wire:click="sortBy('comments')">Recent Sample Comment @if($sortField==='comments'){!! $sortDirection==='asc'?'&uarr;':'&darr;' !!}@endif</th> @endif
						</tr>
					</thead>
					<tbody>
                        @foreach($colourways ?? [] as $c=>$colourway)
                            <tr wire:key="cw-{{$colourway->id}}" class="@if($colourway->cw_cancelled || $colourway->s_cancelled) bg-red text-white @endif" style="height: 130px; page-break-inside: avoid; page-break-before: auto;">
									@if($columns['Customer'])	<td>{{ $colourway->customer }}</td>	@endif
									@if($columns['Factory'])	<td>{{ $colourway->factory }}</td>	@endif
									@if($columns['Category'])	<td>{{ Str::title($colourway->category) }}</td>	@endif
									@if($columns['Image'])
										<td>
											@if($colourway->image != NULL)
												<img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded" src="{{url(asset('storage/' . $colourway->image))}}">
											@endif
										</td>
									@endif
									@if($columns['RT Style No'])		<td role="button" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$colourway->styles_id}}})">RTD{{ $colourway->rt }}</td>			@endif
									@if($columns['Customer Style No'])	<td role="button" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$colourway->styles_id}}})">{{ $colourway->customer_ref }}</td>	@endif
									@if($columns['Description'])		<td>{{ Str::title($colourway->description) }}</td>						@endif
									@if($columns['Version'])			<td>{{ Str::title($colourway->version) }}</td>							@endif
									@if($columns['Colourway'])			<td>{{ Str::title($colourway->colourway) }}</td>						@endif
                                    @if($columns['Colourway Comments'])
                                        <td>
                                            <textarea class="form-control form-textarea-hidden" rows="4" wire:model.live.debounce.250ms="colourwayComments.{{$colourway->id}}" placeholder="Add a comment..." style="min-height: 80px; border: 1px solid #dee2e6; background-color: #f8f9fa;"></textarea>
                                        </td>
                                    @endif
									@if($columns['Date of Issue'])		<td class="text-nowrap">{{ date_format(date_create($colourway->date_of_issue), 'd-M-Y') }}</td>					@endif
									@if($columns['Carryover'])			<td>@if($colourway->carryover) Yes @else No @endif</td>		@endif
									@if($columns['Yarn Ends'])			<td>{{ $colourway->yarn_ends }}</td>						@endif
                                    @if($columns['Sample Yarn'])
                                        <td class="text-nowrap">
                                            {{$colourway->sample_yarn}}<br>
                                            @if($colourway->sample_yarn == "Expected")
                                                {{date_format(date_create($colourway->sample_yarn_date), 'd-M-Y')}}
                                            @endif
                                        </td>
                                    @endif
                                    @if($columns['Sample Accessories'])
                                        <td class="text-nowrap">
                                            {{$colourway->sample_accessories}}<br>
                                            @if($colourway->sample_accessories == "Expected")
                                                {{date_format(date_create($colourway->sample_accessories_date), 'd-M-Y')}}
                                            @endif
                                        </td>
                                    @endif
									@if($columns['Proto Approved'])
										<td class="p-0" style="height: inherit">
											<livewire:sample-status wire:key="proto.{{$colourway->id}}" statusID="proto-{{$colourway->id}}" sample="{!! $colourway->proto !!}" colourwayId="{{$colourway->id}}" sample_required="{{$colourway->proto_required}}" type="1" season_locked="{{$colourway->season_locked}}">
										</td>
									@endif
									@if($columns['Fit Approved'])
										<td class="p-0" style="height: inherit">
											<livewire:sample-status wire:key="fit.{{$colourway->id}}" statusID="fit-{{$colourway->id}}" sample="{!! $colourway->fit !!}" colourwayId="{{$colourway->id}}" sample_required="{{$colourway->fit_required}}" type="2" season_locked="{{$colourway->season_locked}}">
										</td>
									@endif
									@if($columns['Sealer Approved'])
										<td class="p-0" style="height: inherit">
											<livewire:sample-status wire:key="sealer.{{$colourway->id}}" statusID="sealer-{{$colourway->id}}" sample="{!! $colourway->sealer !!}" colourwayId="{{$colourway->id}}" sample_required="{{$colourway->sealer_required}}" type="3" season_locked="{{$colourway->season_locked}}">
										</td>
									@endif
									@if($columns['SMS Approved'])
										<td class="p-0" style="height: inherit">
											<livewire:sample-status wire:key="sms.{{$colourway->id}}" statusID="sms-{{$colourway->id}}" sample="{!! $colourway->sms !!}" colourwayId="{{$colourway->id}}" sample_required="{{$colourway->sms_required}}" type="5" season_locked="{{$colourway->season_locked}}">
										</td>
									@endif
									@if($columns['Photo Approved'])
										<td class="p-0" style="height: inherit">
											<livewire:sample-status wire:key="photo.{{$colourway->id}}" statusID="photo-{{$colourway->id}}" sample="{!! $colourway->photo !!}" colourwayId="{{$colourway->id}}" sample_required="{{$colourway->photo_required}}" type="6" season_locked="{{$colourway->season_locked}}">
										</td>
									@endif
									@if($columns['Shipment Approved'])
										<td class="p-0" style="height: inherit">
											<livewire:sample-status wire:key="ss.{{$colourway->id}}" statusID="ss-{{$colourway->id}}" sample="{!! $colourway->shipment !!}" colourwayId="{{$colourway->id}}" sample_required="{{$colourway->shipment_required}}" type="7" season_locked="{{$colourway->season_locked}}">
										</td>
									@endif
									@if($columns['Composition'])
										<td>
											@foreach($colourway->composition as $material=>$percentage)
												<span><b>{{ $material }}</b> {{ $percentage }}%</span><br>
											@endforeach
										</td>
									@endif
									@if($columns['Yarns'])
										<td>
											@if(!empty($colourway->yarns))
												@foreach($colourway->yarns as $yarn)
													<span><b>{{ $yarn->yarn }}</b> {{ $yarn->count }} | {{ $yarn->colour_ref }} {{ $yarn->colour }} ({{ $yarn->percentage }}%)</span><br>
												@endforeach
											@endif
										</td>
									@endif

									@if($columns['Gauge'])		<td>{{ $colourway->gauge }}</td>		@endif

									@if($columns['Weight'])		<td> {{$colourway->weight }}</td>		@endif

									@if($columns['Recent Sample Comment'])		<td>{{ $colourway->comments }}</td>		@endif


							</tr>
						@endforeach

					</tbody>
				</table>
			</div>
		</div>


		<x-modal name="edit-sample" title="Edit Sample" size="modal-lg">
			<x-slot:body>
					<livewire:development.samples.samples-edit wire:key="sampleEdit">
			</x-slot:body>
		</x-modal>
		<x-modal name="edit-style" title="Edit Style">
			<x-slot:body>
					<livewire:development.styles.style-edit :style="$styleEditID" :wire:key="$styleEditID">
			</x-slot:body>
		</x-modal>
	</div>

	<x-footer>
        <x-slot:center>
            {{ $colourways->links() }}
        </x-slot:center>
    </x-footer>

    {{-- Removed Select2 assets and JS; using Livewire/Alpine dropdown like Shipment Schedule --}}
</div>
