<div>
    <div id="page-content" class="styles-overview-beta">
        <!-- Modern Header with Actions -->
        <div class="bg-white border-bottom sticky-top" style="z-index: 1030;">
            <div class="container-fluid py-3">
                <div class="row align-items-center">
                    <div class="col">
                        <div class="d-flex align-items-center">
                            <h1 class="h3 mb-0 me-3">
                                <i class="fas fa-palette text-primary me-2"></i>
                                Style Progress
                                <span class="badge bg-warning text-dark ms-2">Beta</span>
                            </h1>
                            <div class="d-flex gap-2">
                                <div class="btn-group" role="group" aria-label="View mode">
                                    <button type="button" class="btn btn-outline-primary {{ $viewMode === 'table' ? 'active' : '' }}" wire:click="toggleViewMode" title="Table view">
                                        <i class="fas fa-table"></i>
                                        <span class="d-none d-sm-inline ms-1">Table</span>
                                    </button>
                                    <button type="button" class="btn btn-outline-primary {{ $viewMode === 'cards' ? 'active' : '' }}" wire:click="toggleViewMode" title="Card view">
                                        <i class="fas fa-th-large"></i>
                                        <span class="d-none d-sm-inline ms-1">Cards</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="d-flex gap-2">
                            <button class="btn btn-outline-success" wire:click="exportData" title="Export data">
                                <i class="fas fa-download"></i>
                                <span class="d-none d-sm-inline ms-1">Export</span>
                            </button>
                            <button class="btn btn-outline-secondary" wire:click="resetFilters" title="Reset all filters">
                                <i class="fas fa-undo"></i>
                                <span class="d-none d-sm-inline ms-1">Reset</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <!-- Smart Quick Filters -->
    <div class="bg-light border-bottom">
        <div class="container-fluid py-2">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex flex-wrap gap-2 align-items-center">
                        <span class="text-muted small me-2">Quick Filters:</span>
                        <button class="btn btn-sm btn-outline-warning" wire:click="applyQuickFilter('rejected')">
                            <i class="fas fa-times-circle me-1"></i>Rejected
                        </button>
                        <button class="btn btn-sm btn-outline-info" wire:click="applyQuickFilter('carryover')">
                            <i class="fas fa-sync me-1"></i>Carryover
                        </button>
                        <button class="btn btn-sm btn-outline-success" wire:click="applyQuickFilter('completed')">
                            <i class="fas fa-check-double me-1"></i>Completed
                        </button>
                        <button class="btn btn-sm btn-outline-primary" wire:click="applyQuickFilter('pending')">
                            <i class="fas fa-clock me-1"></i>Pending
                        </button>
                        @if(!empty($quickFilters))
                            <button class="btn btn-sm btn-outline-danger" wire:click="resetFilters">
                                <i class="fas fa-times me-1"></i>Clear Filters
                            </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Filters Panel -->
    <div class="bg-white border-bottom" x-data="{ open: @entangle('showAdvancedFilters') }">
        <div class="container-fluid py-3">
            <div class="row">
                <div class="col-12">
                    <button class="btn btn-link p-0 text-decoration-none" wire:click="toggleAdvancedFilters">
                        <i class="fas fa-filter me-2"></i>
                        Advanced Filters
                        <i class="fas fa-chevron-down ms-1" :class="{ 'fa-chevron-up': open }"></i>
                    </button>
                </div>
            </div>
            
            <div x-show="open" x-transition class="mt-3">
                <div class="row g-3">
                    <div class="col-md-3">
                        <div class="form-floating">
                            <select class="form-select" wire:model.live="season">
                                <option value="">All Seasons</option>
                                @foreach($this->seasons as $season)
                                    <option value="{{ $season->id }}">{{ $season->description }}</option>
                                @endforeach
                            </select>
                            <label><i class="fas fa-calendar me-2"></i>Season</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div x-data="{ open: $wire.entangle('showCustomerDropdown'), q: '' }" class="position-relative">
                            <button class="btn w-100 border form-control text-start" style="height: calc(3.5rem + 2px);" x-on:click.prevent="open = !open" :aria-expanded="open.toString()" aria-controls="customer-menu">
                                <i class="fas fa-users me-2"></i>
                                <span x-text="q === '' ? 'All Customers' : 'Filtered'"></span>
                                <span class="badge bg-primary ms-2" x-show="$wire.customer && Object.keys($wire.customer).length" x-text="Object.keys($wire.customer).length"></span>
                            </button>
                            <ul id="customer-menu" class="dropdown-menu w-100 mt-1" style="max-height: 50vh; overflow-y: auto;" x-show="open" x-on:click.outside="open = false" x-cloak>
                                <li class="px-3 py-2">
                                    <input type="text" class="form-control form-control-sm" placeholder="Search customers..." x-model="q" aria-label="Filter customers">
                                </li>
                                <li class="px-3 pb-2 d-flex gap-2">
                                    <button class="btn btn-sm btn-primary flex-fill" wire:click="select('customer')">All</button>
                                    <button class="btn btn-sm btn-outline-secondary flex-fill" x-on:click="$wire.set('customer', {});">Clear</button>
                                </li>
                                @foreach($this->customers as $c)
                                    <li class="px-3 py-1" x-show="q === '' || '{{ Str::lower($c->name) }}'.includes(q.toLowerCase())">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="cust-{{$c->id}}" 
                                                   @checked(($customer[$c->id] ?? 0) || (is_array($customer) && array_keys($customer) === range(0, count($customer) - 1) && in_array($c->id, $customer))) 
                                                   x-on:change="$wire.select('customer', {{$c->id}})">
                                            <label class="form-check-label" for="cust-{{$c->id}}">{{ $c->name }}</label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-floating">
                            <select class="form-select" wire:model.live="factory">
                                <option value="">All Factories</option>
                                @foreach($this->factories as $factory)
                                    <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                @endforeach
                            </select>
                            <label><i class="fas fa-industry me-2"></i>Factory</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-floating">
                            <select class="form-select" wire:model.live="category">
                                <option value="">All Categories</option>
                                <option value="ladies">Ladies</option>
                                <option value="mens">Mens</option>
                                <option value="childrens">Childrens</option>
                                <option value="accessories">Accessories</option>
                            </select>
                            <label><i class="fas fa-tags me-2"></i>Category</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-floating">
                            <select class="form-select" wire:model.live="department">
                                <option value="">All Departments</option>
                                @foreach($this->departments as $department)
                                    <option value="{{ $department->id }}">{{ $department->description }}</option>
                                @endforeach
                            </select>
                            <label><i class="fas fa-building me-2"></i>Department</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-floating">
                            <select class="form-select" wire:model.live="statusFilter">
                                <option value="">All Statuses</option>
                                <option value="pending">Pending</option>
                                <option value="approved">Approved</option>
                                <option value="rejected">Rejected</option>
                                <option value="sent">Sent</option>
                            </select>
                            <label><i class="fas fa-info-circle me-2"></i>Status</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-floating">
                            <input type="text" class="form-control" wire:model.live.debounce.400ms="search" placeholder="Search...">
                            <label><i class="fas fa-search me-2"></i>Search</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-floating">
                            <select class="form-select" wire:model.live="paginate">
                                <option value="10">10 per page</option>
                                <option value="25">25 per page</option>
                                <option value="50">50 per page</option>
                                <option value="100">100 per page</option>
                            </select>
                            <label><i class="fas fa-list me-2"></i>Per Page</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container-fluid py-4">
        <!-- Loading Overlay -->
        <div wire:loading.flex class="position-fixed top-0 bottom-0 start-0 end-0 bg-white bg-opacity-75 align-items-center justify-content-center" style="z-index: 2000;">
            <div class="text-center">
                <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;"></div>
                <div class="text-muted">Loading your styles...</div>
            </div>
        </div>

        <!-- Alerts -->
        @if (Session::get('message'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                {{ Session::get('message') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        @if($errors->all())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <!-- Results Summary -->
        <div class="row mb-4">
            <div class="col">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center gap-3">
                        <div class="text-muted">
                            <i class="fas fa-list me-1"></i>
                            Showing {{ $colourways->firstItem() ?? 0 }} to {{ $colourways->lastItem() ?? 0 }} of {{ $colourways->total() }} results
                        </div>
                        @if(!empty($selectedItems))
                            <div class="badge bg-primary">
                                <i class="fas fa-check-square me-1"></i>
                                {{ count($selectedItems) }} selected
                            </div>
                        @endif
                    </div>
                    <div class="text-muted small">
                        <i class="fas fa-clock me-1"></i>
                        <span wire:loading.remove>Last updated: {{ now()->format('H:i:s') }}</span>
                        <span wire:loading>Updating...</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bulk Actions Bar -->
        @if($showBulkActions)
            <div class="row mb-3">
                <div class="col">
                    <div class="alert alert-info d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-tasks me-2"></i>
                            <strong>{{ count($selectedItems) }}</strong> items selected
                        </div>
                        <div class="d-flex gap-2">
                            <button class="btn btn-sm btn-outline-primary" wire:click="bulkAction('export')">
                                <i class="fas fa-download me-1"></i>Export Selected
                            </button>
                            <button class="btn btn-sm btn-outline-warning" wire:click="bulkAction('update_status')">
                                <i class="fas fa-edit me-1"></i>Update Status
                            </button>
                            <button class="btn btn-sm btn-outline-danger" wire:click="bulkAction('delete')">
                                <i class="fas fa-trash me-1"></i>Delete
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <!-- Content -->
        <div class="row">
            <div class="col">
                @if($viewMode === 'table')
                    <!-- Modern Table View -->
                    <div class="card shadow-sm">
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            @if($showBulkActions)
                                                <th class="border-0" style="width: 50px;">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" wire:model="selectAll">
                                                    </div>
                                                </th>
                                            @endif
                                            @php($aria = fn($field) => $sortField === $field ? ($sortDirection==='asc' ? 'ascending' : 'descending') : 'none')
                                            @if($columns['Customer'])
                                                <th class="border-0" aria-sort="{{$aria('customer')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('customer')">
                                                        Customer {!! $sortField==='customer' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Factory'])
                                                <th class="border-0" aria-sort="{{$aria('factory')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('factory')">
                                                        Factory {!! $sortField==='factory' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Category'])
                                                <th class="border-0" aria-sort="{{$aria('category')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('category')">
                                                        Category {!! $sortField==='category' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Image'])
                                                <th class="border-0" aria-sort="{{$aria('image')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('image')">
                                                        Image {!! $sortField==='image' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['RT Style No'])
                                                <th class="border-0" aria-sort="{{$aria('rt')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('rt')">
                                                        RT Style No {!! $sortField==='rt' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Customer Style No'])
                                                <th class="border-0" aria-sort="{{$aria('customer_ref')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('customer_ref')">
                                                        Customer Style No {!! $sortField==='customer_ref' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Description'])
                                                <th class="border-0" aria-sort="{{$aria('description')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('description')">
                                                        Description {!! $sortField==='description' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Version'])
                                                <th class="border-0" aria-sort="{{$aria('version')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('version')">
                                                        Version {!! $sortField==='version' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Colourway'])
                                                <th class="border-0" aria-sort="{{$aria('colourway')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('colourway')">
                                                        Colourway {!! $sortField==='colourway' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Colourway Comments'])
                                                <th class="border-0" style="min-width: 200px;" aria-sort="{{$aria('colourway_comments')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('colourway_comments')">
                                                        Comments {!! $sortField==='colourway_comments' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Date of Issue'])
                                                <th class="border-0" aria-sort="{{$aria('date_of_issue')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('date_of_issue')">
                                                        Date of Issue {!! $sortField==='date_of_issue' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Carryover'])
                                                <th class="border-0" aria-sort="{{$aria('carryover')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('carryover')">
                                                        Carryover {!! $sortField==='carryover' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Proto Approved'])
                                                <th class="border-0" aria-sort="{{$aria('proto_approved')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('proto_approved')">
                                                        Proto {!! $sortField==='proto_approved' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                            @if($columns['Fit Approved'])
                                                <th class="border-0" aria-sort="{{$aria('fit_approved')}}">
                                                    <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('fit_approved')">
                                                        Fit {!! $sortField==='fit_approved' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                    </button>
                                                </th>
                                            @endif
                                                                                         @if($columns['Sealer Approved'])
                                                 <th class="border-0" aria-sort="{{$aria('sealer_approved')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('sealer_approved')">
                                                         Sealer {!! $sortField==='sealer_approved' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['SMS Approved'])
                                                 <th class="border-0" aria-sort="{{$aria('sms_approved')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('sms_approved')">
                                                         SMS {!! $sortField==='sms_approved' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['Photo Approved'])
                                                 <th class="border-0" aria-sort="{{$aria('photo_approved')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('photo_approved')">
                                                         Photo {!! $sortField==='photo_approved' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['Shipment Approved'])
                                                 <th class="border-0" aria-sort="{{$aria('shipment_approved')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('shipment_approved')">
                                                         Shipment {!! $sortField==='shipment_approved' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['Composition'])
                                                 <th class="border-0" aria-sort="{{$aria('composition')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('composition')">
                                                         Composition {!! $sortField==='composition' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['Yarns'])
                                                 <th class="border-0" aria-sort="{{$aria('yarns')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('yarns')">
                                                         Yarns {!! $sortField==='yarns' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['Gauge'])
                                                 <th class="border-0" aria-sort="{{$aria('gauge')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('gauge')">
                                                         Gauge {!! $sortField==='gauge' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['Weight'])
                                                 <th class="border-0" aria-sort="{{$aria('weight')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('weight')">
                                                         Weight (kg) {!! $sortField==='weight' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif
                                             @if($columns['Recent Sample Comment'])
                                                 <th class="border-0" style="min-width: 250px;" aria-sort="{{$aria('comments')}}">
                                                     <button class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('comments')">
                                                         Recent Sample Comment {!! $sortField==='comments' ? ($sortDirection==='asc'?'<i class="fas fa-sort-up"></i>':'<i class="fas fa-sort-down"></i>') : '<i class="fas fa-sort text-muted"></i>' !!}
                                                     </button>
                                                 </th>
                                             @endif

                                             <th class="border-0" style="width: 100px;">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($colourways ?? [] as $colourway)
                                            <tr wire:key="cw-{{$colourway->id}}" class="@if($colourway->cw_cancelled || $colourway->s_cancelled) table-danger @endif">
                                                @if($showBulkActions)
                                                    <td>
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" 
                                                                   @checked(in_array($colourway->id, $selectedItems))
                                                                   wire:click="toggleItemSelection({{$colourway->id}})">
                                                        </div>
                                                    </td>
                                                @endif
                                                @if($columns['Customer'])  
                                                    <td class="fw-bold text-primary">{{ $colourway->customer }}</td> 
                                                @endif
                                                @if($columns['Factory'])   
                                                    <td>{{ $colourway->factory }}</td> 
                                                @endif
                                                @if($columns['Category'])  
                                                    <td><span class="badge bg-secondary">{{ Str::title($colourway->category) }}</span></td> 
                                                @endif
                                                @if($columns['Image'])
                                                    <td>
                                                        @if($colourway->image)
                                                            <img class="img-thumbnail" style="width: 60px; height: 60px; object-fit: cover;" 
                                                                 loading="lazy" alt="{{ $colourway->description ?? 'Style image' }}" 
                                                                 src="{{url(asset('storage/' . $colourway->image))}}">
                                                        @else
                                                            <div class="text-muted text-center">
                                                                <i class="fas fa-image fa-lg"></i>
                                                            </div>
                                                        @endif
                                                    </td>
                                                @endif
                                                @if($columns['RT Style No'])        
                                                    <td class="fw-bold text-primary" role="button" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$colourway->styles_id}}})">RTD{{ $colourway->rt }}</td> 
                                                @endif
                                                @if($columns['Customer Style No'])  
                                                    <td class="fw-bold" role="button" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$colourway->styles_id}}})">{{ $colourway->customer_ref }}</td> 
                                                @endif
                                                @if($columns['Description'])        
                                                    <td>{{ Str::title($colourway->description) }}</td> 
                                                @endif
                                                @if($columns['Version'])            
                                                    <td><span class="badge bg-info">{{ Str::title($colourway->version) }}</span></td> 
                                                @endif
                                                                                                 @if($columns['Colourway'])          
                                                     <td><span class="badge bg-warning text-dark">{{ Str::title($colourway->colourway) }}</span></td> 
                                                 @endif
                                                 @if($columns['Colourway Comments'])
                                                     <td>
                                                         <textarea class="form-control form-control-sm" rows="2" wire:model.defer="colourwayComments.{{$colourway->id}}" placeholder="Add a comment..." x-data x-on:blur="$wire.saveColourwayComment({{$colourway->id}})" style="border: none; background: transparent; resize: none; box-shadow: none;"></textarea>
                                                     </td>
                                                 @endif
                                                @if($columns['Date of Issue'])      
                                                    <td class="text-nowrap">{{ $colourway->date_of_issue ? \Carbon\Carbon::parse($colourway->date_of_issue)->format('d-M-Y') : '' }}</td> 
                                                @endif
                                                                                                 @if($columns['Carryover'])          
                                                     <td>@if($colourway->carryover) <span class="badge bg-success">Yes</span> @else <span class="badge bg-secondary">No</span> @endif</td> 
                                                 @endif
                                                                                                  @if($columns['Proto Approved'])
                                                     <td class="text-center">
                                                         <span class="badge {{ $this->getStatusBadgeClass($colourway->proto, $colourway->proto_required) }}">
                                                             {{ $this->getCleanStatusDisplay($colourway->proto, $colourway->proto_required) }}
                                                         </span>
                                                     </td>
                                                 @endif
                                                 @if($columns['Fit Approved'])
                                                     <td class="text-center">
                                                         <span class="badge {{ $this->getStatusBadgeClass($colourway->fit, $colourway->fit_required) }}">
                                                             {{ $this->getCleanStatusDisplay($colourway->fit, $colourway->fit_required) }}
                                                         </span>
                                                     </td>
                                                 @endif
                                                 @if($columns['Sealer Approved'])
                                                     <td class="text-center">
                                                         <span class="badge {{ $this->getStatusBadgeClass($colourway->sealer, $colourway->sealer_required) }}">
                                                             {{ $this->getCleanStatusDisplay($colourway->sealer, $colourway->sealer_required) }}
                                                         </span>
                                                     </td>
                                                 @endif
                                                 @if($columns['SMS Approved'])
                                                     <td class="text-center">
                                                         <span class="badge {{ $this->getStatusBadgeClass($colourway->sms, $colourway->sms_required) }}">
                                                             {{ $this->getCleanStatusDisplay($colourway->sms, $colourway->sms_required) }}
                                                         </span>
                                                     </td>
                                                 @endif
                                                 @if($columns['Photo Approved'])
                                                     <td class="text-center">
                                                         <span class="badge {{ $this->getStatusBadgeClass($colourway->photo, $colourway->photo_required) }}">
                                                             {{ $this->getCleanStatusDisplay($colourway->photo, $colourway->photo_required) }}
                                                         </span>
                                                     </td>
                                                 @endif
                                                 @if($columns['Shipment Approved'])
                                                     <td class="text-center">
                                                         <span class="badge {{ $this->getStatusBadgeClass($colourway->shipment, $colourway->shipment_required) }}">
                                                             {{ $this->getCleanStatusDisplay($colourway->shipment, $colourway->shipment_required) }}
                                                         </span>
                                                     </td>
                                                 @endif
                                                 @if($columns['Composition'])
                                                     <td>
                                                         @if(!empty($colourway->composition) && $colourway->composition->count() > 0)
                                                             @foreach($colourway->composition as $material=>$percentage)
                                                                 <span><b>{{ $material }}</b> {{ $percentage }}%</span><br>
                                                             @endforeach
                                                         @else
                                                             <span class="badge bg-secondary">Not Required</span>
                                                         @endif
                                                     </td>
                                                 @endif
                                                 @if($columns['Yarns'])
                                                     <td>
                                                         @if(!empty($colourway->yarns))
                                                             @foreach($colourway->yarns as $yarn)
                                                                 <div class="mb-1 d-flex">
                                                                     <span class="badge bg-primary me-1">{{ $yarn->yarn }}</span>
                                                                     <span class="badge bg-secondary me-1">{{ $yarn->count }}</span>
                                                                     <span class="badge bg-info me-1">{{ $yarn->colour_ref }} {{ $yarn->colour }}</span>
                                                                     <span class="badge bg-warning text-dark">{{ $yarn->percentage }}%</span>
                                                                 </div>
                                                             @endforeach
                                                         @else
                                                             <span class="badge bg-secondary">Not Required</span>
                                                         @endif
                                                     </td>
                                                 @endif
                                                 @if($columns['Gauge'])
                                                     <td>{{ $colourway->gauge }}</td>
                                                 @endif
                                                 @if($columns['Weight'])
                                                     <td>
                                                         @if(!empty($colourway->weight))
                                                             {{ $colourway->weight }}
                                                         @else
                                                             <span class="text-muted">-</span>
                                                         @endif
                                                     </td>
                                                 @endif
                                                 @if($columns['Recent Sample Comment'])
                                                     <td>
                                                         @if(!empty($colourway->comments))
                                                             {{ $colourway->comments }}
                                                         @else
                                                             <span class="text-muted">-</span>
                                                         @endif
                                                     </td>
                                                 @endif

                                                  <td>
                                                     <div class="btn-group btn-group-sm">
                                                         <button class="btn btn-outline-info" title="View Details">
                                                             <i class="fas fa-eye"></i>
                                                         </button>
                                                         <button class="btn btn-outline-primary" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$colourway->styles_id}}})" title="Edit Style">
                                                             <i class="fas fa-edit"></i>
                                                         </button>
                                                     </div>
                                                 </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @else
                    <!-- Modern Card View -->
                    <div class="row">
                        @foreach($colourways ?? [] as $colourway)
                            <div class="col-12 col-md-6 col-lg-4 mb-4" wire:key="card-{{$colourway->id}}">
                                <div class="card h-100 shadow-sm @if($colourway->cw_cancelled || $colourway->s_cancelled) border-danger @endif">
                                    <div class="card-header d-flex justify-content-between align-items-center bg-light">
                                        <h6 class="mb-0 fw-bold">{{ $colourway->customer }}</h6>
                                        <span class="badge bg-secondary">{{ Str::title($colourway->category) }}</span>
                                    </div>
                                    <div class="card-body">
                                        @if($colourway->image)
                                            <div class="text-center mb-3">
                                                <img class="img-fluid rounded" style="max-height: 200px; object-fit: cover;" 
                                                     loading="lazy" alt="{{ $colourway->description ?? 'Style image' }}" 
                                                     src="{{url(asset('storage/' . $colourway->image))}}">
                                            </div>
                                        @endif
                                        <h5 class="card-title text-primary mb-2">RTD{{ $colourway->rt }}</h5>
                                        <p class="card-text text-muted">{{ $colourway->description }}</p>
                                        
                                        <div class="row g-2 mb-3">
                                            <div class="col-6">
                                                <small class="text-muted d-block">Customer Ref:</small>
                                                <strong>{{ $colourway->customer_ref }}</strong>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted d-block">Version:</small>
                                                <span class="badge bg-info">{{ $colourway->version }}</span>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <small class="text-muted d-block">Colourway:</small>
                                            <span class="badge bg-warning text-dark">{{ $colourway->colourway }}</span>
                                        </div>

                                        @if($columns['Colourway Comments'])
                                            <div class="mb-3">
                                                <small class="text-muted d-block">Comments:</small>
                                                <textarea class="form-control form-control-sm" rows="2" wire:model.defer="colourwayComments.{{$colourway->id}}" placeholder="Add a comment..." x-data x-on:blur="$wire.saveColourwayComment({{$colourway->id}})"></textarea>
                                            </div>
                                        @endif
                                        
                                        @if($columns['Proto Approved'] || $columns['Fit Approved'] || $columns['Sealer Approved'] || $columns['SMS Approved'] || $columns['Photo Approved'] || $columns['Shipment Approved'])
                                            <div class="mb-3">
                                                <small class="text-muted d-block">Sample Approvals:</small>
                                                <div class="row g-2">
                                                    @if($columns['Proto Approved'])
                                                        <div class="col-6">
                                                            <small class="text-muted d-block">Proto:</small>
                                                            <span class="badge {{ $this->getStatusBadgeClass($colourway->proto, $colourway->proto_required) }}">
                                                                {{ $this->getCleanStatusDisplay($colourway->proto, $colourway->proto_required) }}
                                                            </span>
                                                        </div>
                                                    @endif
                                                    @if($columns['Fit Approved'])
                                                        <div class="col-6">
                                                            <small class="text-muted d-block">Fit:</small>
                                                            <span class="badge {{ $this->getStatusBadgeClass($colourway->fit, $colourway->fit_required) }}">
                                                                {{ $this->getCleanStatusDisplay($colourway->fit, $colourway->fit_required) }}
                                                            </span>
                                                        </div>
                                                    @endif
                                                    @if($columns['Sealer Approved'])
                                                        <div class="col-6">
                                                            <small class="text-muted d-block">Sealer:</small>
                                                            <span class="badge {{ $this->getStatusBadgeClass($colourway->sealer, $colourway->sealer_required) }}">
                                                                {{ $this->getCleanStatusDisplay($colourway->sealer, $colourway->sealer_required) }}
                                                            </span>
                                                        </div>
                                                    @endif
                                                    @if($columns['SMS Approved'])
                                                        <div class="col-6">
                                                            <small class="text-muted d-block">SMS:</small>
                                                            <span class="badge {{ $this->getStatusBadgeClass($colourway->sms, $colourway->sms_required) }}">
                                                                {{ $this->getCleanStatusDisplay($colourway->sms, $colourway->sms_required) }}
                                                            </span>
                                                        </div>
                                                    @endif
                                                    @if($columns['Photo Approved'])
                                                        <div class="col-6">
                                                            <small class="text-muted d-block">Photo:</small>
                                                            <span class="badge {{ $this->getStatusBadgeClass($colourway->photo, $colourway->photo_required) }}">
                                                                {{ $this->getCleanStatusDisplay($colourway->photo, $colourway->photo_required) }}
                                                            </span>
                                                        </div>
                                                    @endif
                                                    @if($columns['Shipment Approved'])
                                                        <div class="col-6">
                                                            <small class="text-muted d-block">Shipment:</small>
                                                            <span class="badge {{ $this->getStatusBadgeClass($colourway->shipment, $colourway->shipment_required) }}">
                                                                {{ $this->getCleanStatusDisplay($colourway->shipment, $colourway->shipment_required) }}
                                                            </span>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="card-footer bg-light">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <small class="text-muted">{{ $colourway->factory }}</small>
                                            <div class="btn-group btn-group-sm">
                                                <button class="btn btn-outline-info" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <button class="btn btn-outline-primary" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$colourway->styles_id}}})" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Modals -->
    <x-modal name="edit-sample" title="Edit Sample" size="modal-lg">
        <x-slot:body>
            <livewire:development.samples.samples-edit wire:key="sampleEdit">
        </x-slot:body>
    </x-modal>
    <x-modal name="edit-style" title="Edit Style">
        <x-slot:body>
            <livewire:development.styles.style-edit :style="$styleEditID" :wire:key="$styleEditID">
        </x-slot:body>
    </x-modal>

    <!-- Pagination -->
    <div class="container-fluid py-3 border-top bg-light">
        <div class="row">
            <div class="col">
                <div class="d-flex justify-content-center">
                    {{ $colourways->links() }}
                </div>
            </div>
        </div>
    </div>
          </div>
 </div>



