<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Designs
        </x-slot:title>
        <x-slot:end>
            @can('design:create')
                <button class="btn btn-primary" x-data x-on:click="$dispatch('open-modal', {name:'quick-add'})">New</button>
            @endcan
        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="customer">
                                <option selected value="">All</option>
                                @foreach($this->customers as $customer)
                                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                @endforeach
                            </select>
                            <label class="form-label">Customer:</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="factory">
                                <option selected value="">All</option>
                                @foreach($this->factories as $factory)
                                    <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                @endforeach
                            </select>
                            <label class="form-label">Factory:</label>
                        </div>
                    </div>
                    <div class="col-xl-2 col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="paginate">
                                <option selected value="10">10</option>
                                <option selected value="50">50</option>
                                <option selected value="100">100</option>
                                <option selected value="200">200</option>
                                <option selected value="500">500</option>
                            </select>
                            <label class="form-label">Display:</label>
                        </div>
                    </div>
                    <livewire:column-selector :columns="$columns" columnsVersion="{{$this->columnsVersion()}}" filterKey="{{ $this->getFilterKeyString() }}" />
                </div>
                <div class="row mx-1">
                    <div class="col-12 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="text" placeholder="Quantity" class="form-control" wire:model.live.debounce.500ms="search">
                            <label>Search</label>
                            <div class="invalid-feedback">@error('search') {{ $message }} @enderror</div>
                        </div>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>


    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row">
            <div class="col">
                <table id="tableSort" class="table align-middle rounded">
                    <thead style="position: sticky; top:0; z-index:100" class="bg-white">
                        <tr>
                            @foreach ($columns as $c=>$column)
                                @if ($column)
                                    <th>{{ $c }}</th>
                                @endif
                            @endforeach
                            <th class="dont-print" style="width: 1px"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($this->designs as $design)
                            <tr wire:key="{{ $design->id }}">
                                @if($columns['ID'])
                                    <td>
                                        {{ $design->id }}
                                    </td>
                                @endif
                                @if($columns['Description'])
                                    <td class="fw-bold">
                                        {{ Str::title($design->description) }}
                                    </td>
                                @endif
                                @if($columns['Customer'])
                                    <td>
                                        {{ $design->customers->name }}
                                    </td>
                                @endif
                                @if($columns['Factory'])
                                    <td>
                                        {{ $design->factories->name }}
                                    </td>
                                @endif
                                @if($columns['Gauge'])
                                    <td>
                                        {{ $design->gauges->gauge }}
                                    </td>
                                @endif
                                @if($columns['Yarn'])
                                    <td>
                                        {{ $design->yarn }}
                                    </td>
                                @endif
                                @if($columns['Date of Issue'])
                                    <td>
                                        {{ $design->issued?->format('d-M-Y') }}
                                    </td>
                                @endif
                                <td class="dont-print" style="position: relative;">
                                    <div class="btn-group">
                                        @can('design:update')
                                            <button class="btn btn-secondary" x-data x-on:click="$dispatch('open-modal', {name:'edit'})" wire:click="$dispatch('edit-design', { id: {{$design->id}}})">Edit</button>
                                        @endcan
                                        @can('design:delete')
                                            <button class="btn btn-danger" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()" wire:click="delete({{$design->id}})">X</button>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
			</div>
		</div>
    </div>

    <x-modal name="edit" title="Edit Design" size="modal-md">
        <x-slot:body>
                <livewire:designs.design-edit>
        </x-slot:body>
    </x-modal>
    <x-modal name="quick-add" title="New Design + Style" size="modal-lg">
        <x-slot:body>
            <livewire:designs.design-quick-add>
        </x-slot:body>
    </x-modal>

    <x-footer>
        <x-slot:center>
            {{ $this->designs->links() }}
        </x-slot:center>
    </x-footer>

</div>
