<div>
    <div class="modal-body">
        @if (Session::get('message'))
            <div class="alert {{ Session::get('alert-class') }}" role="alert">
                <h4>{{ Session::get('message') }}</h4>
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
            </div>
        @endif

        <form wire:submit="save">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <select class="form-select @error('department_id') is-invalid @enderror" wire:model="department_id">
                            <option selected disabled value="">Choose...</option>
                            @foreach ($this->departments->sortBy('description') as $department)
                                <option value="{{ $department->id }}">{{ $department->description }}</option>
                            @endforeach
                        </select>
                        <label class="form-label">Department: <span class="text-danger">*</span></label>
                        @error('department_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <select class="form-select @error('season_id') is-invalid @enderror" wire:model="season_id">
                            <option selected disabled value="">Choose...</option>
                            @foreach ($this->seasons as $season)
                                <option value="{{ $season->id }}">{{ $season->description }}</option>
                            @endforeach
                        </select>
                        <label class="form-label">Season: <span class="text-danger">*</span></label>
                        @error('season_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <select class="form-select @error('customer_id') is-invalid @enderror" wire:model="customer_id">
                            <option selected disabled value="">Choose...</option>
                            @foreach ($this->customers->sortBy('name') as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                            @endforeach
                        </select>
                        <label class="form-label">Customer: <span class="text-danger">*</span></label>
                        @error('customer_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <select class="form-select @error('category') is-invalid @enderror" wire:model="category">
                            <option value="ladies">Ladies</option>
                            <option value="mens">Mens</option>
                            <option value="childrens">Childrens</option>
                            <option value="accessories">Accessories</option>
                        </select>
                        <label class="form-label">Category: <span class="text-danger">*</span></label>
                        @error('category') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
            </div>

            <div class="form-floating mb-3 form-outline">
                <input type="text" class="form-control @error('description') is-invalid @enderror" wire:model="description" placeholder="Description">
                <label class="form-label">Description: <span class="text-danger">*</span></label>
                @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <select class="form-select @error('gauge_id') is-invalid @enderror" wire:model="gauge_id">
                            <option selected disabled value="">Choose...</option>
                            @foreach ($this->gauges->sortBy('gauge') as $gauge)
                                <option value="{{ $gauge->id }}">{{ $gauge->gauge }}</option>
                            @endforeach
                        </select>
                        <label class="form-label">Gauge: <span class="text-danger">*</span></label>
                        @error('gauge_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <select class="form-select @error('factory_id') is-invalid @enderror" wire:model="factory_id">
                            <option selected disabled value="">Choose...</option>
                            @foreach ($this->factories->sortBy('name') as $factory)
                                <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                            @endforeach
                        </select>
                        <label class="form-label">Factory: <span class="text-danger">*</span></label>
                        @error('factory_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <input type="date" class="form-control @error('issued') is-invalid @enderror" wire:model="issued">
                        <label class="form-label">Date of Issue: <span class="text-danger">*</span></label>
                        @error('issued') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-floating mb-3 form-outline">
                        <input type="text" class="form-control @error('yarn') is-invalid @enderror" wire:model="yarn" placeholder="Yarn">
                        <label class="form-label">Yarn:</label>
                        @error('yarn') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
            </div>
        </form>

        <div class="quick-add-info mt-3 p-3 bg-light rounded">
            <small class="text-muted">
                <i class="bi bi-info-circle me-1"></i>
                This will create a <strong>Design</strong>, <strong>Style</strong>, <strong>Style Version (A)</strong>, and <strong>Colourway (TBC)</strong>.
            </small>
        </div>
    </div>
    <div class="modal-footer">
        <button class="btn btn-primary" wire:click="save" wire:loading.attr="disabled">
            <span wire:loading.remove wire:target="save">Create All</span>
            <span wire:loading wire:target="save">Creating...</span>
        </button>
        <button class="btn btn-secondary" wire:click="$dispatch('close-modal')">Cancel</button>
    </div>
</div>

