<div>
	<div class="modal-body">
		@if (Session::get('message'))
			<div class="alert {{ Session::get('alert-class') }}" role="alert">
				<h4>{{ Session::get('message') }}</h3>
				@foreach ($errors->all() as $error)
					{{ $error }}<br>
				@endforeach
			</div>
		@endif

		<form wire:submit="save">
			<div class="row">
				<div class="col">
					<div class="form-floating mb-3 form-outline">
						<input type="text" class="form-control" wire:model="form.description">
						<label class="form-label">Description:</label>
					</div>
					<div class="form-floating mb-3 form-outline">
						<select class="form-select" wire:model="form.gauge_id">
							<option selected disabled value="">Choose...</option>
							@foreach ($this->gauges()->sortBy('name') as $gauge)
								<option value="{{$gauge->id}}">{{$gauge->gauge}}</option>
							@endforeach
						</select>
						<label class="form-label">Gauge:</label>
					</div>
					<div class="form-floating my-3 form-outline">
						<input type="date" class="form-control" wire:model="form.issued">
						<label>Date of Issue:</label>
					</div>
					<div class="form-floating my-3 form-outline">
						<input type="text" class="form-control" wire:model="form.yarn">
						<label>Yarn:</label>
					</div>
					<div class="form-floating mb-3 form-outline">
						<select class="form-select" wire:model="form.factory_id">
							<option selected disabled value="">Choose...</option>
							@foreach ($this->factories()->sortBy('name') as $factory)
								<option value="{{$factory->id}}">{{$factory->name}}</option>
							@endforeach
						</select>
						<label class="form-label">Factory:</label>
					</div>
					<div class="form-floating mb-3 form-outline">
						<select class="form-select" wire:model="form.customers_id">
							<option selected disabled value="">Choose...</option>
							@foreach ($this->customers()->sortBy('name') as $customer)
								<option value="{{$customer->id}}">{{$customer->name}}</option>
							@endforeach
						</select>
						<label type="submit" class="form-label">Customer:</label>
					</div>
				</div>
			</div>
		</form>
	</div>
	<div class="modal-footer">
		<button class="btn btn-primary" wire:click="save">Save</button>			
		<button class="btn btn-danger" wire:click="$dispatch('close-modal')" onclick="confirm('Are you sure?') || event.stopImmediatePropagation()">Close</button>			
	</div>
</div>
