<div>
    <div class="wdash-card-header">
        <h3><i class="fas fa-exclamation-triangle"></i> Unconfirmed Prices</h3>
        <div wire:loading>
            <i class="fas fa-spinner fa-spin" style="color: rgba(255,255,255,0.4);"></i>
        </div>
    </div>

    @if($isLoading)
        <div class="wdash-card-body" style="min-height: 300px;">
            <div class="wdash-empty">
                <i class="fas fa-spinner fa-spin"></i> Loading...
            </div>
        </div>
    @elseif(empty($pricesData))
        <div class="wdash-card-body" style="min-height: 200px;">
            <div class="wdash-empty" style="color: #34d399;">
                <i class="fas fa-check-circle" style="font-size: 2rem; margin-bottom: 0.5rem; display: block;"></i>
                All Prices Confirmed!
            </div>
        </div>
    @else
        {{-- Summary Stats --}}
        <div class="wdash-inner-stats" style="grid-template-columns: repeat(2, 1fr);">
            <div class="wdash-inner-stat">
                <div class="wdash-inner-stat-icon wdash-inner-stat-icon-warning">
                    <i class="fas fa-users"></i>
                </div>
                <div class="wdash-inner-stat-content">
                    <span class="wdash-inner-stat-value">{{ count($pricesData) }}</span>
                    <span class="wdash-inner-stat-label">Customers</span>
                </div>
            </div>
            <div class="wdash-inner-stat">
                <div class="wdash-inner-stat-icon" style="background: rgba(248,113,113,0.15); color: #f87171;">
                    <i class="fas fa-tag"></i>
                </div>
                <div class="wdash-inner-stat-content">
                    <span class="wdash-inner-stat-value">{{ array_sum(array_column($pricesData, 'unconfirmed_count')) }}</span>
                    <span class="wdash-inner-stat-label">Unconfirmed</span>
                </div>
            </div>
        </div>

        {{-- Customer Table --}}
        <div class="wdash-card-body wdash-card-body-flush" style="max-height: 350px; overflow-y: auto;">
            <table class="wdash-table">
                <thead>
                    <tr>
                        <th>Customer</th>
                        <th class="text-end">Unconfirmed</th>
                        <th class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($pricesData as $row)
                        <tr style="cursor: pointer;" wire:click="viewPrices({{ $row->customer_id }})">
                            <td>
                                <div style="display: flex; align-items: center; gap: 0.75rem;">
                                    <div style="width: 28px; height: 28px; border-radius: 8px; background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%); display: flex; align-items: center; justify-content: center; font-size: 0.7rem; font-weight: 600; color: #0c1929; flex-shrink: 0;">
                                        {{ strtoupper(substr($row->customer_name, 0, 1)) }}
                                    </div>
                                    <span style="font-weight: 500;">{{ Str::limit($row->customer_name, 30) }}</span>
                                </div>
                            </td>
                            <td class="text-end">
                                <span class="wdash-badge wdash-badge-danger">{{ $row->unconfirmed_count }}</span>
                            </td>
                            <td class="text-center">
                                <button wire:click.stop="viewPrices({{ $row->customer_id }})" 
                                        class="wdash-action-btn" 
                                        style="padding: 0.375rem 0.75rem; font-size: 0.75rem;"
                                        title="View unconfirmed prices">
                                    <i class="fas fa-eye"></i>
                                    <span>View</span>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>
