<div style="position: relative;">
    <div class="wdash-card-header">
        <h3><i class="fas fa-shipping-fast"></i> Pending Shipments This Week</h3>
        @if($totalQuantity > 0)
            <div style="display: flex; gap: 0.5rem;">
                <span class="wdash-badge wdash-badge-info">{{ number_format($totalQuantity) }} units</span>
                <span class="wdash-badge wdash-badge-success">£{{ number_format($totalSaleValue, 0) }}</span>
            </div>
        @else
            <span class="wdash-badge wdash-badge-muted">
                {{ \Carbon\Carbon::now()->startOfWeek()->format('M d') }} - {{ \Carbon\Carbon::now()->endOfWeek()->format('M d') }}
            </span>
        @endif
    </div>
    
    <div class="wdash-card-body wdash-card-body-flush" wire:loading.class="opacity-50" style="max-height: 400px; overflow-y: auto;">
        @if($isLoading)
            <div class="wdash-empty" style="padding: 2rem;">
                <i class="fas fa-spinner fa-spin"></i> Loading...
            </div>
        @elseif(empty($shipmentsData))
            <div class="wdash-empty" style="padding: 2rem;">
                <i class="fas fa-calendar-check" style="font-size: 2rem; margin-bottom: 0.5rem; display: block; opacity: 0.5;"></i>
                No pending shipments this week
            </div>
        @else
            <table class="wdash-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Customer</th>
                        <th>Style</th>
                        <th class="text-end">Qty</th>
                        <th class="text-end">Value</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($shipmentsData as $shipment)
                        @php
                            $hasFlagged = $shipment->has_flagged_issue ?? 0;
                            $hasSampleIssue = $shipment->has_issue ?? 0;
                            $hasAnyIssue = $hasFlagged || $hasSampleIssue;
                            $exftyPassed = \Carbon\Carbon::parse($shipment->earliest_exfty)->isPast();
                        @endphp
                        <tr style="cursor: pointer; {{ $exftyPassed ? 'background: rgba(251,191,36,0.1);' : '' }}" 
                            wire:click="viewStyle({{ $shipment->style_id }}, '{{ $shipment->shipment_line_ids }}')">
                            <td>
                                @if($shipment->earliest_exfty == $shipment->latest_exfty)
                                    <span class="wdash-badge {{ $hasAnyIssue ? 'wdash-badge-danger' : 'wdash-badge-success' }}" 
                                          title="{{ $hasAnyIssue ? 'Has issues' : 'Ready to ship' }}">
                                        {{ \Carbon\Carbon::parse($shipment->earliest_exfty)->format('D, M d') }}
                                    </span>
                                @else
                                    <div style="display: flex; flex-direction: column; gap: 0.25rem;">
                                        <span class="wdash-badge {{ $hasAnyIssue ? 'wdash-badge-danger' : 'wdash-badge-success' }}">
                                            {{ \Carbon\Carbon::parse($shipment->earliest_exfty)->format('M d') }}
                                        </span>
                                        <span class="wdash-badge {{ $hasAnyIssue ? 'wdash-badge-danger' : 'wdash-badge-success' }}">
                                            {{ \Carbon\Carbon::parse($shipment->latest_exfty)->format('M d') }}
                                        </span>
                                    </div>
                                @endif
                            </td>
                            <td>
                                <div style="font-weight: 500; color: #fff;">{{ $shipment->customer_name }}</div>
                                <div style="font-size: 0.7rem; color: rgba(255,255,255,0.4);">{{ $shipment->season }}</div>
                            </td>
                            <td>
                                <div style="font-weight: 500; color: #fff;">{{ $shipment->design_name }}</div>
                                <div style="font-size: 0.7rem; color: rgba(255,255,255,0.4);">
                                    {{ $shipment->colourway_count }} colourway{{ $shipment->colourway_count != 1 ? 's' : '' }}
                                </div>
                            </td>
                            <td class="text-end">
                                <span class="wdash-badge wdash-badge-muted">{{ number_format($shipment->total_qty ?? 0) }}</span>
                            </td>
                            <td class="text-end">
                                <span class="wdash-badge wdash-badge-success">£{{ number_format($shipment->total_sale_value ?? 0) }}</span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
    
    @if(!empty($shipmentsData))
        <div style="padding: 0.75rem 1.25rem; border-top: 1px solid rgba(255,255,255,0.05); display: flex; justify-content: space-between; align-items: center;">
            <span style="font-size: 0.75rem; color: rgba(255,255,255,0.4);">
                <i class="fas fa-info-circle"></i>
                {{ count($shipmentsData) }} style{{ count($shipmentsData) != 1 ? 's' : '' }}
            </span>
            <span style="font-size: 0.75rem; color: rgba(255,255,255,0.4);">
                Click to view details
            </span>
        </div>
    @endif
    
    <div wire:loading style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">
        <i class="fas fa-spinner fa-spin" style="font-size: 1.5rem; color: #38bdf8;"></i>
    </div>
</div>
