<div>
    <div class="wdash-card-header">
        <h3><i class="fas fa-chart-bar"></i> Garments Due to Ship</h3>
        <span class="wdash-badge wdash-badge-muted">3 Year View</span>
    </div>

    <div class="wdash-card-body" style="min-height: 350px;">
        @if($isLoading)
            <div class="wdash-empty" style="padding: 4rem 0;">
                <i class="fas fa-spinner fa-spin"></i> Loading chart data...
            </div>
        @else
            <div style="position: relative; height: 300px;">
                <canvas id="garmentsDueChart"></canvas>
            </div>
            <div style="text-align: center; margin-top: 1rem;">
                <span style="font-size: 0.75rem; color: rgba(255,255,255,0.4);">
                    {{ count($chartData['labels'] ?? []) }} months · {{ count($chartData['datasets'] ?? []) }} years
                </span>
            </div>
        @endif
    </div>

    @if(!$isLoading)
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                document.addEventListener('livewire:load', function () {
                    initChart();
                });
                if (window.Livewire) {
                    initChart();
                }
            });

            function initChart() {
                const canvas = document.getElementById('garmentsDueChart');
                if (!canvas) return;
                
                const ctx = canvas.getContext('2d');
                
                if (window.garmentsChart) {
                    window.garmentsChart.destroy();
                }
                
                const chartData = @json($chartData);
                
                // Apply dark theme colors to datasets
                if (chartData.datasets) {
                    const colors = ['#38bdf8', '#34d399', '#a78bfa'];
                    chartData.datasets.forEach((dataset, i) => {
                        dataset.borderColor = colors[i % colors.length];
                        dataset.backgroundColor = colors[i % colors.length] + '20';
                        dataset.pointBackgroundColor = colors[i % colors.length];
                        dataset.pointBorderColor = '#0c1929';
                    });
                }
                
                window.garmentsChart = new Chart(ctx, {
                    type: 'line',
                    data: chartData,
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        interaction: {
                            intersect: false,
                            mode: 'index'
                        },
                        plugins: {
                            legend: {
                                position: 'top',
                                labels: {
                                    usePointStyle: true,
                                    padding: 20,
                                    color: 'rgba(255,255,255,0.7)',
                                    font: { size: 11 }
                                }
                            },
                            tooltip: {
                                backgroundColor: 'rgba(15,23,42,0.95)',
                                titleColor: '#fff',
                                bodyColor: 'rgba(255,255,255,0.8)',
                                borderColor: 'rgba(255,255,255,0.1)',
                                borderWidth: 1,
                                callbacks: {
                                    label: function(context) {
                                        return context.dataset.label + ': ' + context.parsed.y.toLocaleString() + ' garments';
                                    }
                                }
                            }
                        },
                        scales: {
                            x: {
                                display: true,
                                grid: { display: false },
                                ticks: { color: 'rgba(255,255,255,0.5)', font: { size: 10 } }
                            },
                            y: {
                                display: true,
                                beginAtZero: true,
                                grid: { color: 'rgba(255,255,255,0.05)' },
                                ticks: {
                                    color: 'rgba(255,255,255,0.5)',
                                    font: { size: 10 },
                                    callback: function(value) {
                                        return value.toLocaleString();
                                    }
                                }
                            }
                        },
                        elements: {
                            point: { radius: 3, hoverRadius: 5 },
                            line: { tension: 0.3 }
                        }
                    }
                });
            }

            document.addEventListener('livewire:update', function () {
                setTimeout(initChart, 100);
            });
        </script>
    @endif
</div>
